
package org.opentravel.ota;

/** 
 * Specifies the global travel area.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="GlobalIndicatorType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="AT"/>
 *     &lt;xs:enumeration value="PA"/>
 *     &lt;xs:enumeration value="WH"/>
 *     &lt;xs:enumeration value="EH"/>
 *     &lt;xs:enumeration value="PO"/>
 *     &lt;xs:enumeration value="TS"/>
 *     &lt;xs:enumeration value="AP"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum GlobalIndicatorType {
    /** 
     * Atlantic Ocean
     */
    AT, /** 
         * Pacific Ocean
         */
    PA, /** 
         * Western Hemisphere
         */
    WH, /** 
         * Eastern Hemisphere
         */
    EH, /** 
         * Polar Route
         */
    PO, /** 
         * Trans Siberia Route
         */
    TS, /** 
         * Atlantic/Pacific Round-the-World
         */
    AP
}
