
package org.opentravel.ota;

import java.util.Date;

/** 
 * Object to hold an insurance request
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="InsuranceRequestType">
 *   &lt;xs:attribute type="xs:string" use="optional" name="PolicyCode"/>
 *   &lt;xs:attribute type="xs:dateTime" use="optional" name="DepartureDate"/>
 *   &lt;xs:attribute type="xs:dateTime" use="optional" name="ArrivalDate"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="Origin"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="Destination"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="State"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class InsuranceRequestType
{
    private String policyCode;
    private Date departureDate;
    private Date arrivalDate;
    private String origin;
    private String destination;
    private String state;

    /** 
     * Get the 'PolicyCode' attribute value. Insurance Policy Code
     * 
     * @return value
     */
    public String getPolicyCode() {
        return policyCode;
    }

    /** 
     * Set the 'PolicyCode' attribute value. Insurance Policy Code
     * 
     * @param policyCode
     */
    public void setPolicyCode(String policyCode) {
        this.policyCode = policyCode;
    }

    /** 
     * Get the 'DepartureDate' attribute value. The departure date of the journey
     * 
     * @return value
     */
    public Date getDepartureDate() {
        return departureDate;
    }

    /** 
     * Set the 'DepartureDate' attribute value. The departure date of the journey
     * 
     * @param departureDate
     */
    public void setDepartureDate(Date departureDate) {
        this.departureDate = departureDate;
    }

    /** 
     * Get the 'ArrivalDate' attribute value. The arrival date of the journey
     * 
     * @return value
     */
    public Date getArrivalDate() {
        return arrivalDate;
    }

    /** 
     * Set the 'ArrivalDate' attribute value. The arrival date of the journey
     * 
     * @param arrivalDate
     */
    public void setArrivalDate(Date arrivalDate) {
        this.arrivalDate = arrivalDate;
    }

    /** 
     * Get the 'Origin' attribute value. The origin of the journey
     * 
     * @return value
     */
    public String getOrigin() {
        return origin;
    }

    /** 
     * Set the 'Origin' attribute value. The origin of the journey
     * 
     * @param origin
     */
    public void setOrigin(String origin) {
        this.origin = origin;
    }

    /** 
     * Get the 'Destination' attribute value. The destination of the journey
     * 
     * @return value
     */
    public String getDestination() {
        return destination;
    }

    /** 
     * Set the 'Destination' attribute value. The destination of the journey
     * 
     * @param destination
     */
    public void setDestination(String destination) {
        this.destination = destination;
    }

    /** 
     * Get the 'State' attribute value. The state of the insurance
     * 
     * @return value
     */
    public String getState() {
        return state;
    }

    /** 
     * Set the 'State' attribute value. The state of the insurance
     * 
     * @param state
     */
    public void setState(String state) {
        this.state = state;
    }
}
