
package org.opentravel.ota;

/** 
 * 
 Attributes for meal request. Note: you can choose a specific meal or just a general preference

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:attributeGroup xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MealRequestAttributes">
 *   &lt;xs:attribute type="xs:string" use="required" name="mealCode"/>
 *   &lt;xs:attribute type="xs:int" use="optional" name="mealQuantity"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class MealRequestAttributes
{
    private String mealCode;
    private Integer mealQuantity;

    /** 
     * Get the 'mealCode' attribute value. Used to provide the meal code.
     * 
     * @return value
     */
    public String getMealCode() {
        return mealCode;
    }

    /** 
     * Set the 'mealCode' attribute value. Used to provide the meal code.
     * 
     * @param mealCode
     */
    public void setMealCode(String mealCode) {
        this.mealCode = mealCode;
    }

    /** 
     * Get the 'mealQuantity' attribute value. 
                      Used to provide the meal quantity in case multimeal enabled.
                  
     * 
     * @return value
     */
    public Integer getMealQuantity() {
        return mealQuantity;
    }

    /** 
     * Set the 'mealQuantity' attribute value. 
                      Used to provide the meal quantity in case multimeal enabled.
                  
     * 
     * @param mealQuantity
     */
    public void setMealQuantity(Integer mealQuantity) {
        this.mealQuantity = mealQuantity;
    }
}
