
package org.opentravel.ota;

import java.util.Date;

/** 
 * Object to hold a passengers' meal request
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MealRequestType">
 *   &lt;xs:attributeGroup ref="ns:MealRequestAttributes"/>
 *   &lt;xs:attribute type="xs:dateTime" use="optional" name="DepartureDate"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="FlightNumber"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class MealRequestType
{
    private MealRequestAttributes mealRequestAttributes;
    private Date departureDate;
    private String flightNumber;

    /** 
     * Get the 'MealRequestAttributes' attributeGroup value. Attributes for meal request
     * 
     * @return value
     */
    public MealRequestAttributes getMealRequestAttributes() {
        return mealRequestAttributes;
    }

    /** 
     * Set the 'MealRequestAttributes' attributeGroup value. Attributes for meal request
     * 
     * @param mealRequestAttributes
     */
    public void setMealRequestAttributes(
            MealRequestAttributes mealRequestAttributes) {
        this.mealRequestAttributes = mealRequestAttributes;
    }

    /** 
     * Get the 'DepartureDate' attribute value. 
                      The departure date of the flight for the meal requested.
                  
     * 
     * @return value
     */
    public Date getDepartureDate() {
        return departureDate;
    }

    /** 
     * Set the 'DepartureDate' attribute value. 
                      The departure date of the flight for the meal requested.
                  
     * 
     * @param departureDate
     */
    public void setDepartureDate(Date departureDate) {
        this.departureDate = departureDate;
    }

    /** 
     * Get the 'FlightNumber' attribute value. 
                      The number of the flight for which this meal is requested.
                  
     * 
     * @return value
     */
    public String getFlightNumber() {
        return flightNumber;
    }

    /** 
     * Set the 'FlightNumber' attribute value. 
                      The number of the flight for which this meal is requested.
                  
     * 
     * @param flightNumber
     */
    public void setFlightNumber(String flightNumber) {
        this.flightNumber = flightNumber;
    }
}
