
package org.opentravel.ota;

import java.util.ArrayList;
import java.util.List;

/** 
 * 
 The Availability Request message requests Flight Availability for a
 city pair on a specific date for a specific number and type of
 passengers. Optional request information can include:
 - Time / Time Window
 - Connecting cities.
 - Client Preferences (airlines, cabin, flight types etc.)
 The request can be narrowed to request availability for a specific
 airline, specific flight, or specific booking class on a specific
 flight.
 The availability request message contains similar information to a
 standard Airline CRS or GDS availability request message.

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OTA_AirAvailRQ">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element type="ns:POS_Type" name="POS"/>
 *       &lt;xs:element name="ProcessingInfo" minOccurs="0">
 *         &lt;xs:complexType>
 *           &lt;xs:attributeGroup ref="ns:AirProcessingInfoGroup"/>
 *         &lt;/xs:complexType>
 *       &lt;/xs:element>
 *       &lt;xs:element name="OriginDestinationInformation" maxOccurs="5">
 *         &lt;!-- Reference to inner class OriginDestinationInformation -->
 *       &lt;/xs:element>
 *       &lt;xs:element type="ns:SpecificFlightInfoType" name="SpecificFlightInfo" minOccurs="0"/>
 *       &lt;xs:element type="ns:AirSearchPrefsType" name="TravelPreferences" minOccurs="0"/>
 *       &lt;xs:element type="ns:TravelerInfoSummaryType" name="TravelerInfoSummary" minOccurs="0"/>
 *       &lt;xs:element type="ns:AirReservationType" name="ModifiedSegmentInfo" minOccurs="0"/>
 *       &lt;xs:element type="xs:boolean" name="FlexiQuote" minOccurs="0"/>
 *     &lt;/xs:sequence>
 *     &lt;xs:attributeGroup ref="ns:OTA_PayloadStdAttributes"/>
 *     &lt;xs:attributeGroup ref="ns:MaxResponsesGroup"/>
 *     &lt;xs:attributeGroup ref="ns:DirectandStopsGroup"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * 
 * &lt;xs:attributeGroup xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MaxResponsesGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="MaxResponses"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class OTAAirAvailRQ
{
    private POSType POS;
    private AirProcessingInfoGroup processingInfo;
    private List<OriginDestinationInformation> originDestinationInformationList = new ArrayList<OriginDestinationInformation>();
    private SpecificFlightInfoType specificFlightInfo;
    private AirSearchPrefsType travelPreferences;
    private TravelerInfoSummaryType travelerInfoSummary;
    private AirReservationType modifiedSegmentInfo;
    private Boolean flexiQuote;
    private OTAPayloadStdAttributes OTAPayloadStdAttributes;
    private String maxResponses;
    private DirectandStopsGroup directandStopsGroup;

    /** 
     * Get the 'POS' element value. Point of sale object. 
     * 
     * @return value
     */
    public POSType getPOS() {
        return POS;
    }

    /** 
     * Set the 'POS' element value. Point of sale object. 
     * 
     * @param POS
     */
    public void setPOS(POSType POS) {
        this.POS = POS;
    }

    /** 
     * Get the 'AirProcessingInfoGroup' attributeGroup value. A collection of
    						information that specifies how the message processing should
    						occur or how the data should be returned.
     * 
     * @return value
     */
    public AirProcessingInfoGroup getProcessingInfo() {
        return processingInfo;
    }

    /** 
     * Set the 'AirProcessingInfoGroup' attributeGroup value. A collection of
    						information that specifies how the message processing should
    						occur or how the data should be returned.
     * 
     * @param processingInfo
     */
    public void setProcessingInfo(AirProcessingInfoGroup processingInfo) {
        this.processingInfo = processingInfo;
    }

    /** 
     * Get the list of 'OriginDestinationInformation' element items.
     * 
     * @return list
     */
    public List<OriginDestinationInformation> getOriginDestinationInformationList() {
        return originDestinationInformationList;
    }

    /** 
     * Set the list of 'OriginDestinationInformation' element items.
     * 
     * @param list
     */
    public void setOriginDestinationInformationList(
            List<OriginDestinationInformation> list) {
        originDestinationInformationList = list;
    }

    /** 
     * Get the 'SpecificFlightInfo' element value. Information used to
    						specify a flight for which availablity is to be checked. 
     * 
     * @return value
     */
    public SpecificFlightInfoType getSpecificFlightInfo() {
        return specificFlightInfo;
    }

    /** 
     * Set the 'SpecificFlightInfo' element value. Information used to
    						specify a flight for which availablity is to be checked. 
     * 
     * @param specificFlightInfo
     */
    public void setSpecificFlightInfo(SpecificFlightInfoType specificFlightInfo) {
        this.specificFlightInfo = specificFlightInfo;
    }

    /** 
     * Get the 'TravelPreferences' element value. Air Availability
    						Request preference information.
     * 
     * @return value
     */
    public AirSearchPrefsType getTravelPreferences() {
        return travelPreferences;
    }

    /** 
     * Set the 'TravelPreferences' element value. Air Availability
    						Request preference information.
     * 
     * @param travelPreferences
     */
    public void setTravelPreferences(AirSearchPrefsType travelPreferences) {
        this.travelPreferences = travelPreferences;
    }

    /** 
     * Get the 'TravelerInfoSummary' element value. Used to specify
    						passenger and fare information for which availablity is to be
    						checked. 
     * 
     * @return value
     */
    public TravelerInfoSummaryType getTravelerInfoSummary() {
        return travelerInfoSummary;
    }

    /** 
     * Set the 'TravelerInfoSummary' element value. Used to specify
    						passenger and fare information for which availablity is to be
    						checked. 
     * 
     * @param travelerInfoSummary
     */
    public void setTravelerInfoSummary(
            TravelerInfoSummaryType travelerInfoSummary) {
        this.travelerInfoSummary = travelerInfoSummary;
    }

    /** 
     * Get the 'ModifiedSegmentInfo' element value. Contains the
    						reservation segment details to be modified.
     * 
     * @return value
     */
    public AirReservationType getModifiedSegmentInfo() {
        return modifiedSegmentInfo;
    }

    /** 
     * Set the 'ModifiedSegmentInfo' element value. Contains the
    						reservation segment details to be modified.
     * 
     * @param modifiedSegmentInfo
     */
    public void setModifiedSegmentInfo(AirReservationType modifiedSegmentInfo) {
        this.modifiedSegmentInfo = modifiedSegmentInfo;
    }

    /** 
     * Get the 'FlexiQuote' element value. A boolean flag to
    						indicate whether to quote the flexi-charges with the availability
    						search. 
     * 
     * @return value
     */
    public Boolean getFlexiQuote() {
        return flexiQuote;
    }

    /** 
     * Set the 'FlexiQuote' element value. A boolean flag to
    						indicate whether to quote the flexi-charges with the availability
    						search. 
     * 
     * @param flexiQuote
     */
    public void setFlexiQuote(Boolean flexiQuote) {
        this.flexiQuote = flexiQuote;
    }

    /** 
     * Get the 'OTA_PayloadStdAttributes' attributeGroup value.
     * 
     * @return value
     */
    public OTAPayloadStdAttributes getOTAPayloadStdAttributes() {
        return OTAPayloadStdAttributes;
    }

    /** 
     * Set the 'OTA_PayloadStdAttributes' attributeGroup value.
     * 
     * @param OTAPayloadStdAttributes
     */
    public void setOTAPayloadStdAttributes(
            OTAPayloadStdAttributes OTAPayloadStdAttributes) {
        this.OTAPayloadStdAttributes = OTAPayloadStdAttributes;
    }

    /** 
     * Get the 'MaxResponses' attribute value. A positive integer value
    				that indicates the maximum number of responses desired in the
    				return.
     * 
     * @return value
     */
    public String getMaxResponses() {
        return maxResponses;
    }

    /** 
     * Set the 'MaxResponses' attribute value. A positive integer value
    				that indicates the maximum number of responses desired in the
    				return.
     * 
     * @param maxResponses
     */
    public void setMaxResponses(String maxResponses) {
        this.maxResponses = maxResponses;
    }

    /** 
     * Get the 'DirectandStopsGroup' attributeGroup value.
     * 
     * @return value
     */
    public DirectandStopsGroup getDirectandStopsGroup() {
        return directandStopsGroup;
    }

    /** 
     * Set the 'DirectandStopsGroup' attributeGroup value.
     * 
     * @param directandStopsGroup
     */
    public void setDirectandStopsGroup(DirectandStopsGroup directandStopsGroup) {
        this.directandStopsGroup = directandStopsGroup;
    }
    /** 
     * Information on the
    						locations between which availability is to be checked.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OriginDestinationInformation" maxOccurs="5">
     *   &lt;xs:complexType>
     *     &lt;xs:complexContent>
     *       &lt;xs:extension base="ns:OriginDestinationInformationType">
     *         &lt;xs:sequence>
     *           &lt;xs:element type="ns:SpecificFlightInfoType" name="SpecificFlightInfo" minOccurs="0"/>
     *           &lt;xs:element type="ns:AirSearchPrefsType" name="TravelPreferences" minOccurs="0"/>
     *         &lt;/xs:sequence>
     *         &lt;xs:attribute type="xs:boolean" use="optional" name="SameAirportInd"/>
     *         &lt;xs:attribute type="xs:string" use="optional" name="RPH"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:complexContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class OriginDestinationInformation
            extends
                OriginDestinationInformationType
    {
        private SpecificFlightInfoType specificFlightInfo;
        private AirSearchPrefsType travelPreferences;
        private Boolean sameAirportInd;
        private String RPH;

        /** 
         * Get the 'SpecificFlightInfo' element value. To specify a
        											flight for this origin and destination for which
        											availability is to be checked.
         * 
         * @return value
         */
        public SpecificFlightInfoType getSpecificFlightInfo() {
            return specificFlightInfo;
        }

        /** 
         * Set the 'SpecificFlightInfo' element value. To specify a
        											flight for this origin and destination for which
        											availability is to be checked.
         * 
         * @param specificFlightInfo
         */
        public void setSpecificFlightInfo(
                SpecificFlightInfoType specificFlightInfo) {
            this.specificFlightInfo = specificFlightInfo;
        }

        /** 
         * Get the 'TravelPreferences' element value. Traveler
        											preference information for this particular origin and
        											destination.
         * 
         * @return value
         */
        public AirSearchPrefsType getTravelPreferences() {
            return travelPreferences;
        }

        /** 
         * Set the 'TravelPreferences' element value. Traveler
        											preference information for this particular origin and
        											destination.
         * 
         * @param travelPreferences
         */
        public void setTravelPreferences(AirSearchPrefsType travelPreferences) {
            this.travelPreferences = travelPreferences;
        }

        /** 
         * Get the 'SameAirportInd' attribute value. If true, the
        										return departure must be from the same airport as the
        										outbound arrival.
         * 
         * @return value
         */
        public Boolean getSameAirportInd() {
            return sameAirportInd;
        }

        /** 
         * Set the 'SameAirportInd' attribute value. If true, the
        										return departure must be from the same airport as the
        										outbound arrival.
         * 
         * @param sameAirportInd
         */
        public void setSameAirportInd(Boolean sameAirportInd) {
            this.sameAirportInd = sameAirportInd;
        }

        /** 
         * Get the 'RPH' attribute value. Uniquely identifies this origin destination
        										information.
         * 
         * @return value
         */
        public String getRPH() {
            return RPH;
        }

        /** 
         * Set the 'RPH' attribute value. Uniquely identifies this origin destination
        										information.
         * 
         * @param RPH
         */
        public void setRPH(String RPH) {
            this.RPH = RPH;
        }
    }
}
