
package org.opentravel.ota;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

/** 
 * 
 The Availability Response message contains Flight Availability for a
 city pair on a specific date. A set of OriginDestinationOptions is
 returned, each of which contains one or more (connecting) flights
 that serve the city pair. For each flight the following information
 is returned:
 - Origin and destination airports
 - Departure and arrival date/times
 - Booking Class availability
 - Equipment
 - Meal Information
 - Codeshare information.
 This message contains similar information to a standard airline CRS or
 GDS availability response message.

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OTA_AirAvailRS">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:sequence>
 *         &lt;xs:element type="ns:SuccessType" name="Success" minOccurs="0"/>
 *         &lt;xs:element type="ns:WarningsType" name="Warnings" minOccurs="0"/>
 *         &lt;xs:choice>
 *           &lt;xs:element name="OriginDestinationOptions" minOccurs="0"/>
 *           &lt;xs:element name="OriginDestinationInformation" minOccurs="0" maxOccurs="5">
 *             &lt;!-- Reference to inner class OriginDestinationInformation -->
 *           &lt;/xs:element>
 *         &lt;/xs:choice>
 *         &lt;xs:element type="ns:FreeTextType" name="Comment" minOccurs="0"/>
 *         &lt;xs:element name="AAAirAvailRSExt" minOccurs="0"/>
 *       &lt;/xs:sequence>
 *       &lt;xs:element type="ns:ErrorsType" name="Errors" minOccurs="0"/>
 *     &lt;/xs:sequence>
 *     &lt;xs:attributeGroup ref="ns:OTA_PayloadStdAttributes"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class OTAAirAvailRS
{
    private SuccessType success;
    private WarningsType warnings;
    private int choiceSelect = -1;
    private static final int ORIGIN_DESTINATION_OPTIONS_CHOICE = 0;
    private static final int ORIGIN_DESTINATION_INFORMATION_LIST_CHOICE = 1;
    private boolean originDestinationOptions;
    private List<OriginDestinationInformation> originDestinationInformationList = new ArrayList<OriginDestinationInformation>();
    private FreeTextType comment;
    private boolean AAAirAvailRSExt;
    private ErrorsType errors;
    private OTAPayloadStdAttributes OTAPayloadStdAttributes;

    /** 
     * Get the 'Success' element value.
     * 
     * @return value
     */
    public SuccessType getSuccess() {
        return success;
    }

    /** 
     * Set the 'Success' element value.
     * 
     * @param success
     */
    public void setSuccess(SuccessType success) {
        this.success = success;
    }

    /** 
     * Get the 'Warnings' element value.
     * 
     * @return value
     */
    public WarningsType getWarnings() {
        return warnings;
    }

    /** 
     * Set the 'Warnings' element value.
     * 
     * @param warnings
     */
    public void setWarnings(WarningsType warnings) {
        this.warnings = warnings;
    }

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if OriginDestinationOptions is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifOriginDestinationOptions() {
        return choiceSelect == ORIGIN_DESTINATION_OPTIONS_CHOICE;
    }

    /** 
     * Check if the 'OriginDestinationOptions' element is present.
     * 
     * @return <code>true</code> if present, <code>false</code> if not
     */
    public boolean ifOriginDestinationOptionsPresent() {
        return originDestinationOptions;
    }

    /** 
     * Set flag for 'OriginDestinationOptions' element present.
     * 
     * @param originDestinationOptions
     */
    public void flagOriginDestinationOptionsPresent(
            boolean originDestinationOptions) {
        setChoiceSelect(ORIGIN_DESTINATION_OPTIONS_CHOICE);
        this.originDestinationOptions = originDestinationOptions;
    }

    /** 
     * Check if OriginDestinationInformationList is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifOriginDestinationInformationList() {
        return choiceSelect == ORIGIN_DESTINATION_INFORMATION_LIST_CHOICE;
    }

    /** 
     * Get the list of 'OriginDestinationInformation' element items.
     * 
     * @return list
     */
    public List<OriginDestinationInformation> getOriginDestinationInformationList() {
        return originDestinationInformationList;
    }

    /** 
     * Set the list of 'OriginDestinationInformation' element items.
     * 
     * @param list
     */
    public void setOriginDestinationInformationList(
            List<OriginDestinationInformation> list) {
        setChoiceSelect(ORIGIN_DESTINATION_INFORMATION_LIST_CHOICE);
        originDestinationInformationList = list;
    }

    /** 
     * Get the 'Comment' element value.
     * 
     * @return value
     */
    public FreeTextType getComment() {
        return comment;
    }

    /** 
     * Set the 'Comment' element value.
     * 
     * @param comment
     */
    public void setComment(FreeTextType comment) {
        this.comment = comment;
    }

    /** 
     * Check if the 'AAAirAvailRSExt' element is present.
     * 
     * @return <code>true</code> if present, <code>false</code> if not
     */
    public boolean ifAAAirAvailRSExtPresent() {
        return AAAirAvailRSExt;
    }

    /** 
     * Set flag for 'AAAirAvailRSExt' element present.
     * 
     * @param AAAirAvailRSExt
     */
    public void flagAAAirAvailRSExtPresent(boolean AAAirAvailRSExt) {
        this.AAAirAvailRSExt = AAAirAvailRSExt;
    }

    /** 
     * Get the 'Errors' element value.
     * 
     * @return value
     */
    public ErrorsType getErrors() {
        return errors;
    }

    /** 
     * Set the 'Errors' element value.
     * 
     * @param errors
     */
    public void setErrors(ErrorsType errors) {
        this.errors = errors;
    }

    /** 
     * Get the 'OTA_PayloadStdAttributes' attributeGroup value.
     * 
     * @return value
     */
    public OTAPayloadStdAttributes getOTAPayloadStdAttributes() {
        return OTAPayloadStdAttributes;
    }

    /** 
     * Set the 'OTA_PayloadStdAttributes' attributeGroup value.
     * 
     * @param OTAPayloadStdAttributes
     */
    public void setOTAPayloadStdAttributes(
            OTAPayloadStdAttributes OTAPayloadStdAttributes) {
        this.OTAPayloadStdAttributes = OTAPayloadStdAttributes;
    }
    /** 
     * Information on the
    								locations between which availability was requested.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OriginDestinationInformation" minOccurs="0" maxOccurs="5">
     *   &lt;xs:complexType>
     *     &lt;xs:complexContent>
     *       &lt;xs:extension base="ns:OriginDestinationInformationType">
     *         &lt;xs:sequence>
     *           &lt;xs:element name="OriginDestinationOptions">
     *             &lt;xs:complexType>
     *               &lt;xs:sequence>
     *                 &lt;xs:element name="OriginDestinationOption" maxOccurs="999">
     *                   &lt;!-- Reference to inner class OriginDestinationOption -->
     *                 &lt;/xs:element>
     *               &lt;/xs:sequence>
     *             &lt;/xs:complexType>
     *           &lt;/xs:element>
     *         &lt;/xs:sequence>
     *         &lt;xs:attribute type="xs:boolean" use="optional" name="SameAirportInd"/>
     *         &lt;xs:attribute type="xs:string" use="optional" name="RPH"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:complexContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class OriginDestinationInformation
            extends
                OriginDestinationInformationType
    {
        private List<OriginDestinationOption> originDestinationOptionList = new ArrayList<OriginDestinationOption>();
        private Boolean sameAirportInd;
        private String RPH;

        /** 
         * Get the list of 'OriginDestinationOption' element items. A container for origin destination option
        													information.
         * 
         * @return list
         */
        public List<OriginDestinationOption> getOriginDestinationOptionList() {
            return originDestinationOptionList;
        }

        /** 
         * Set the list of 'OriginDestinationOption' element items. A container for origin destination option
        													information.
         * 
         * @param list
         */
        public void setOriginDestinationOptionList(
                List<OriginDestinationOption> list) {
            originDestinationOptionList = list;
        }

        /** 
         * Get the 'SameAirportInd' attribute value. If true, the
        												return departure must be from the same airport as the
        												outbound arrival.
         * 
         * @return value
         */
        public Boolean getSameAirportInd() {
            return sameAirportInd;
        }

        /** 
         * Set the 'SameAirportInd' attribute value. If true, the
        												return departure must be from the same airport as the
        												outbound arrival.
         * 
         * @param sameAirportInd
         */
        public void setSameAirportInd(Boolean sameAirportInd) {
            this.sameAirportInd = sameAirportInd;
        }

        /** 
         * Get the 'RPH' attribute value. Uniquely identifies this origin
        												destination information.
         * 
         * @return value
         */
        public String getRPH() {
            return RPH;
        }

        /** 
         * Set the 'RPH' attribute value. Uniquely identifies this origin
        												destination information.
         * 
         * @param RPH
         */
        public void setRPH(String RPH) {
            this.RPH = RPH;
        }
        /** 
         * Holds the
        																collection of flight options for this
        																origin-destination pair. There maybe limits imposed by
        																individual supplier that are below the maximum
        																occurrences for this element.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OriginDestinationOption" maxOccurs="999">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="FlightSegment" maxOccurs="4">
         *         &lt;!-- Reference to inner class FlightSegment -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class OriginDestinationOption
        {
            private List<FlightSegment> flightSegmentList = new ArrayList<FlightSegment>();

            /** 
             * Get the list of 'FlightSegment' element items.
             * 
             * @return list
             */
            public List<FlightSegment> getFlightSegmentList() {
                return flightSegmentList;
            }

            /** 
             * Set the list of 'FlightSegment' element items.
             * 
             * @param list
             */
            public void setFlightSegmentList(List<FlightSegment> list) {
                flightSegmentList = list;
            }
            /** 
             * Details
            																		of the flight option for an origin destination pair.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FlightSegment" maxOccurs="4">
             *   &lt;xs:complexType>
             *     &lt;xs:complexContent>
             *       &lt;xs:extension base="ns:FlightSegmentType">
             *         &lt;xs:sequence>
             *           &lt;xs:element type="ns:FreeTextType" name="TrafficRestrictionInfo" minOccurs="0"/>
             *           &lt;xs:element type="ns:FreeTextType" name="Comment" minOccurs="0" maxOccurs="10"/>
             *           &lt;xs:element type="ns:MarketingCabinType" name="MarketingCabin" minOccurs="0" maxOccurs="9"/>
             *           &lt;xs:element name="BookingClassAvail" minOccurs="0" maxOccurs="99">
             *             &lt;!-- Reference to inner class BookingClassAvail -->
             *           &lt;/xs:element>
             *         &lt;/xs:sequence>
             *         &lt;xs:attribute type="xs:string" use="optional" name="JourneyDuration"/>
             *         &lt;xs:attributeGroup ref="ns:SmokingIndicatorGroup"/>
             *         &lt;xs:attribute type="xs:decimal" use="optional" name="OnTimeRate"/>
             *         &lt;xs:attribute type="ns:TicketType" default="Paper" name="Ticket"/>
             *         &lt;xs:attribute type="xs:string" use="optional" name="ParticipationLevelCode"/>
             *         &lt;xs:attribute type="xs:string" use="optional" name="GroundDuration"/>
             *         &lt;xs:attribute type="xs:string" use="optional" name="AccumulatedDuration"/>
             *         &lt;xs:attribute type="xs:integer" use="optional" name="Distance"/>
             *       &lt;/xs:extension>
             *     &lt;/xs:complexContent>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * 
             * &lt;xs:attributeGroup xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SmokingIndicatorGroup">
             *   &lt;xs:attribute type="xs:boolean" use="optional" default="false" name="SmokingAllowed"/>
             * &lt;/xs:attributeGroup>
             * </pre>
             */
            public static class FlightSegment extends FlightSegmentType
            {
                private FreeTextType trafficRestrictionInfo;
                private List<FreeTextType> commentList = new ArrayList<FreeTextType>();
                private List<MarketingCabinType> marketingCabinList = new ArrayList<MarketingCabinType>();
                private List<BookingClassAvail> bookingClassAvailList = new ArrayList<BookingClassAvail>();
                private String journeyDuration;
                private Boolean smokingAllowed;
                private BigDecimal onTimeRate;
                private TicketType ticket;
                private String participationLevelCode;
                private String groundDuration;
                private String accumulatedDuration;
                private BigInteger distance;

                /** 
                 * Get the 'TrafficRestrictionInfo' element value. Traffic
                																							restriction information for a specific flight.
                 * 
                 * @return value
                 */
                public FreeTextType getTrafficRestrictionInfo() {
                    return trafficRestrictionInfo;
                }

                /** 
                 * Set the 'TrafficRestrictionInfo' element value. Traffic
                																							restriction information for a specific flight.
                 * 
                 * @param trafficRestrictionInfo
                 */
                public void setTrafficRestrictionInfo(
                        FreeTextType trafficRestrictionInfo) {
                    this.trafficRestrictionInfo = trafficRestrictionInfo;
                }

                /** 
                 * Get the list of 'Comment' element items. Any
                																							special comments on the leg. eg. operated by
                																							XX. 
                 * 
                 * @return list
                 */
                public List<FreeTextType> getCommentList() {
                    return commentList;
                }

                /** 
                 * Set the list of 'Comment' element items. Any
                																							special comments on the leg. eg. operated by
                																							XX. 
                 * 
                 * @param list
                 */
                public void setCommentList(List<FreeTextType> list) {
                    commentList = list;
                }

                /** 
                 * Get the list of 'MarketingCabin' element items. The
                																							airline specific branding for cabins.
                 * 
                 * @return list
                 */
                public List<MarketingCabinType> getMarketingCabinList() {
                    return marketingCabinList;
                }

                /** 
                 * Set the list of 'MarketingCabin' element items. The
                																							airline specific branding for cabins.
                 * 
                 * @param list
                 */
                public void setMarketingCabinList(List<MarketingCabinType> list) {
                    marketingCabinList = list;
                }

                /** 
                 * Get the list of 'BookingClassAvail' element items.
                 * 
                 * @return list
                 */
                public List<BookingClassAvail> getBookingClassAvailList() {
                    return bookingClassAvailList;
                }

                /** 
                 * Set the list of 'BookingClassAvail' element items.
                 * 
                 * @param list
                 */
                public void setBookingClassAvailList(
                        List<BookingClassAvail> list) {
                    bookingClassAvailList = list;
                }

                /** 
                 * Get the 'JourneyDuration' attribute value. The
                																						duration of the flight from departure location
                																						to destination location.
                 * 
                 * @return value
                 */
                public String getJourneyDuration() {
                    return journeyDuration;
                }

                /** 
                 * Set the 'JourneyDuration' attribute value. The
                																						duration of the flight from departure location
                																						to destination location.
                 * 
                 * @param journeyDuration
                 */
                public void setJourneyDuration(String journeyDuration) {
                    this.journeyDuration = journeyDuration;
                }

                /** 
                 * Get the 'SmokingAllowed' attribute value. Indicates smoking is
                			allowed when true and is not allowed when false.
                 * 
                 * @return value
                 */
                public Boolean getSmokingAllowed() {
                    return smokingAllowed;
                }

                /** 
                 * Set the 'SmokingAllowed' attribute value. Indicates smoking is
                			allowed when true and is not allowed when false.
                 * 
                 * @param smokingAllowed
                 */
                public void setSmokingAllowed(Boolean smokingAllowed) {
                    this.smokingAllowed = smokingAllowed;
                }

                /** 
                 * Get the 'OnTimeRate' attribute value. Specifies
                																						the Dept. of Transport on time rate of the
                																						flight.
                 * 
                 * @return value
                 */
                public BigDecimal getOnTimeRate() {
                    return onTimeRate;
                }

                /** 
                 * Set the 'OnTimeRate' attribute value. Specifies
                																						the Dept. of Transport on time rate of the
                																						flight.
                 * 
                 * @param onTimeRate
                 */
                public void setOnTimeRate(BigDecimal onTimeRate) {
                    this.onTimeRate = onTimeRate;
                }

                /** 
                 * Get the 'Ticket' attribute value. Specifies
                																						if the flight is e-ticketable or not.
                 * 
                 * @return value
                 */
                public TicketType getTicket() {
                    return ticket;
                }

                /** 
                 * Set the 'Ticket' attribute value. Specifies
                																						if the flight is e-ticketable or not.
                 * 
                 * @param ticket
                 */
                public void setTicket(TicketType ticket) {
                    this.ticket = ticket;
                }

                /** 
                 * Get the 'ParticipationLevelCode' attribute value. To
                																						specify the level of participation by a vendor
                																						in another system. Refer to OTA Code List
                																						'Participation Level Code' (PLC).
                 * 
                 * @return value
                 */
                public String getParticipationLevelCode() {
                    return participationLevelCode;
                }

                /** 
                 * Set the 'ParticipationLevelCode' attribute value. To
                																						specify the level of participation by a vendor
                																						in another system. Refer to OTA Code List
                																						'Participation Level Code' (PLC).
                 * 
                 * @param participationLevelCode
                 */
                public void setParticipationLevelCode(
                        String participationLevelCode) {
                    this.participationLevelCode = participationLevelCode;
                }

                /** 
                 * Get the 'GroundDuration' attribute value. The
                																						duration of a ground stop.
                 * 
                 * @return value
                 */
                public String getGroundDuration() {
                    return groundDuration;
                }

                /** 
                 * Set the 'GroundDuration' attribute value. The
                																						duration of a ground stop.
                 * 
                 * @param groundDuration
                 */
                public void setGroundDuration(String groundDuration) {
                    this.groundDuration = groundDuration;
                }

                /** 
                 * Get the 'AccumulatedDuration' attribute value. The
                																						total duration time of the flight. This is the
                																						combination of both JourneyDuration and
                																						GroundDuration.
                 * 
                 * @return value
                 */
                public String getAccumulatedDuration() {
                    return accumulatedDuration;
                }

                /** 
                 * Set the 'AccumulatedDuration' attribute value. The
                																						total duration time of the flight. This is the
                																						combination of both JourneyDuration and
                																						GroundDuration.
                 * 
                 * @param accumulatedDuration
                 */
                public void setAccumulatedDuration(String accumulatedDuration) {
                    this.accumulatedDuration = accumulatedDuration;
                }

                /** 
                 * Get the 'Distance' attribute value. Miles
                																						acquired per flight segment, usually used for
                																						earning of frequent flyer miles.
                 * 
                 * @return value
                 */
                public BigInteger getDistance() {
                    return distance;
                }

                /** 
                 * Set the 'Distance' attribute value. Miles
                																						acquired per flight segment, usually used for
                																						earning of frequent flyer miles.
                 * 
                 * @param distance
                 */
                public void setDistance(BigInteger distance) {
                    this.distance = distance;
                }
                /** 
                 * Booking
                																							codes available to be sold for a particular
                																							flight segment.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BookingClassAvail" minOccurs="0" maxOccurs="99">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attributeGroup ref="ns:BookingClassAvailabilityGroup"/>
                 *     &lt;xs:attribute type="xs:string" use="required" name="RPH"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class BookingClassAvail
                {
                    private BookingClassAvailabilityGroup bookingClassAvailabilityGroup;
                    private String RPH;

                    /** 
                     * Get the 'BookingClassAvailabilityGroup' attributeGroup value.
                     * 
                     * @return value
                     */
                    public BookingClassAvailabilityGroup getBookingClassAvailabilityGroup() {
                        return bookingClassAvailabilityGroup;
                    }

                    /** 
                     * Set the 'BookingClassAvailabilityGroup' attributeGroup value.
                     * 
                     * @param bookingClassAvailabilityGroup
                     */
                    public void setBookingClassAvailabilityGroup(
                            BookingClassAvailabilityGroup bookingClassAvailabilityGroup) {
                        this.bookingClassAvailabilityGroup = bookingClassAvailabilityGroup;
                    }

                    /** 
                     * Get the 'RPH' attribute value. RPH
                    																								refers back to Marketing Cabin Type."
                     * 
                     * @return value
                     */
                    public String getRPH() {
                        return RPH;
                    }

                    /** 
                     * Set the 'RPH' attribute value. RPH
                    																								refers back to Marketing Cabin Type."
                     * 
                     * @param RPH
                     */
                    public void setRPH(String RPH) {
                        this.RPH = RPH;
                    }
                }
            }
        }
    }
}
