
package org.opentravel.ota;

/** 
 * The AirBook Modify
 Request message requests the system to modify an existing booking
 for one or more identified passengers. The message may be used for
 any kind of modification to a booking file, i.e. a modification to
 existing flight segments and special service information the
 addition of new elements, a name change or a booking file split.
 Analogous to the TTY process, existing data is submitted as well as
 the modified data. Attribute 'Operation' indicates the way elements
 have to be changed. Flight segments as well as seats- and special
 service requests will indicate a modification using the appropriate
 Status attribute.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OTA_AirBookModifyRQ">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element type="ns:POS_Type" name="POS"/>
 *       &lt;xs:element name="AirBookModifyRQ">
 *         &lt;xs:complexType>
 *           &lt;xs:complexContent>
 *             &lt;xs:extension base="ns:AirReservationType">
 *               &lt;xs:attribute type="xs:string" use="optional" name="ModificationType"/>
 *             &lt;/xs:extension>
 *           &lt;/xs:complexContent>
 *         &lt;/xs:complexType>
 *       &lt;/xs:element>
 *       &lt;xs:element type="ns:AirReservationType" name="AirReservation" minOccurs="0"/>
 *     &lt;/xs:sequence>
 *     &lt;xs:attributeGroup ref="ns:OTA_PayloadStdAttributes"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class OTAAirBookModifyRQ
{
    private POSType POS;
    private AirReservationType airBookModifyRQAirReservationType;
    private String airBookModifyRQModificationType;
    private AirReservationType airReservation;
    private OTAPayloadStdAttributes OTAPayloadStdAttributes;

    /** 
     * Get the 'POS' element value. This identifes the
    						party making the modification request. Trading partners are open
    						to define their own UniqueID.
     * 
     * @return value
     */
    public POSType getPOS() {
        return POS;
    }

    /** 
     * Set the 'POS' element value. This identifes the
    						party making the modification request. Trading partners are open
    						to define their own UniqueID.
     * 
     * @param POS
     */
    public void setPOS(POSType POS) {
        this.POS = POS;
    }

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public AirReservationType getAirBookModifyRQAirReservationType() {
        return airBookModifyRQAirReservationType;
    }

    /** 
     * Set the extension value.
     * 
     * @param airBookModifyRQAirReservationType
     */
    public void setAirBookModifyRQAirReservationType(
            AirReservationType airBookModifyRQAirReservationType) {
        this.airBookModifyRQAirReservationType = airBookModifyRQAirReservationType;
    }

    /** 
     * Get the 'ModificationType' attribute value. Specifies the type
    										of booking modification being requested. Refer to OTA Code
    										List Modification Type (MOD).
     * 
     * @return value
     */
    public String getAirBookModifyRQModificationType() {
        return airBookModifyRQModificationType;
    }

    /** 
     * Set the 'ModificationType' attribute value. Specifies the type
    										of booking modification being requested. Refer to OTA Code
    										List Modification Type (MOD).
     * 
     * @param airBookModifyRQModificationType
     */
    public void setAirBookModifyRQModificationType(
            String airBookModifyRQModificationType) {
        this.airBookModifyRQModificationType = airBookModifyRQModificationType;
    }

    /** 
     * Get the 'AirReservation' element value. Contains all booking
    						information of the current reservation, in this case of the
    						reservation which is to be modified.
     * 
     * @return value
     */
    public AirReservationType getAirReservation() {
        return airReservation;
    }

    /** 
     * Set the 'AirReservation' element value. Contains all booking
    						information of the current reservation, in this case of the
    						reservation which is to be modified.
     * 
     * @param airReservation
     */
    public void setAirReservation(AirReservationType airReservation) {
        this.airReservation = airReservation;
    }

    /** 
     * Get the 'OTA_PayloadStdAttributes' attributeGroup value.
     * 
     * @return value
     */
    public OTAPayloadStdAttributes getOTAPayloadStdAttributes() {
        return OTAPayloadStdAttributes;
    }

    /** 
     * Set the 'OTA_PayloadStdAttributes' attributeGroup value.
     * 
     * @param OTAPayloadStdAttributes
     */
    public void setOTAPayloadStdAttributes(
            OTAPayloadStdAttributes OTAPayloadStdAttributes) {
        this.OTAPayloadStdAttributes = OTAPayloadStdAttributes;
    }
}
