
package org.opentravel.ota;

import java.util.ArrayList;
import java.util.List;

/** 
 * The Book Request message
 requests the system to book a specific itinerary for one or more
 identified passengers. The message contains optional pricing
 information, allowing the booking class availability and pricing to
 be rechecked as part of the booking process. Optional request
 information can include:- Seat and Meal Requests- SSR, OSI, and
 Remarks.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OTA_AirBookRQ">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element type="ns:POS_Type" name="POS"/>
 *       &lt;xs:element type="ns:AirItineraryType" name="AirItinerary"/>
 *       &lt;xs:element type="ns:BookingPriceInfoType" name="PriceInfo" minOccurs="0"/>
 *       &lt;xs:element type="ns:TravelerInfoType" name="TravelerInfo"/>
 *       &lt;xs:element name="Fulfillment" minOccurs="0">
 *         &lt;!-- Reference to inner class Fulfillment -->
 *       &lt;/xs:element>
 *       &lt;xs:element type="ns:TicketingInfoType" name="Ticketing" minOccurs="0"/>
 *       &lt;xs:element name="Queue" minOccurs="0" maxOccurs="10">
 *         &lt;!-- Reference to inner class Queue -->
 *       &lt;/xs:element>
 *       &lt;xs:element type="ns:UniqueID_Type" name="BookingReferenceID" minOccurs="0"/>
 *       &lt;xs:element ref="ns:TPA_Extensions"/>
 *       &lt;xs:element ref="ns:TravelersFulfillments" minOccurs="0"/>
 *     &lt;/xs:sequence>
 *     &lt;xs:attributeGroup ref="ns:OTA_PayloadStdAttributes"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class OTAAirBookRQ
{
    private POSType POS;
    private AirItineraryType airItinerary;
    private BookingPriceInfoType priceInfo;
    private TravelerInfoType travelerInfo;
    private Fulfillment fulfillment;
    private TicketingInfoType ticketing;
    private List<Queue> queueList = new ArrayList<Queue>();
    private UniqueIDType bookingReferenceID;
    private TPAExtensionsType TPAExtensions;
    private TravelersFulfillments travelersFulfillments;
    private OTAPayloadStdAttributes OTAPayloadStdAttributes;

    /** 
     * Get the 'POS' element value. This identifes the
    						party making the booking request. Trading partners are open to
    						define their own UniqueID.
     * 
     * @return value
     */
    public POSType getPOS() {
        return POS;
    }

    /** 
     * Set the 'POS' element value. This identifes the
    						party making the booking request. Trading partners are open to
    						define their own UniqueID.
     * 
     * @param POS
     */
    public void setPOS(POSType POS) {
        this.POS = POS;
    }

    /** 
     * Get the 'AirItinerary' element value. A collection of all
    						flight segments requested for booking.
     * 
     * @return value
     */
    public AirItineraryType getAirItinerary() {
        return airItinerary;
    }

    /** 
     * Set the 'AirItinerary' element value. A collection of all
    						flight segments requested for booking.
     * 
     * @param airItinerary
     */
    public void setAirItinerary(AirItineraryType airItinerary) {
        this.airItinerary = airItinerary;
    }

    /** 
     * Get the 'PriceInfo' element value. Pricing information
    						for the air itinerary to be booked e.g. this data could come from
    						the OTA_AirPriceRS data.
     * 
     * @return value
     */
    public BookingPriceInfoType getPriceInfo() {
        return priceInfo;
    }

    /** 
     * Set the 'PriceInfo' element value. Pricing information
    						for the air itinerary to be booked e.g. this data could come from
    						the OTA_AirPriceRS data.
     * 
     * @param priceInfo
     */
    public void setPriceInfo(BookingPriceInfoType priceInfo) {
        this.priceInfo = priceInfo;
    }

    /** 
     * Get the 'TravelerInfo' element value. All traveler
    						information relevant to a booking request.
     * 
     * @return value
     */
    public TravelerInfoType getTravelerInfo() {
        return travelerInfo;
    }

    /** 
     * Set the 'TravelerInfo' element value. All traveler
    						information relevant to a booking request.
     * 
     * @param travelerInfo
     */
    public void setTravelerInfo(TravelerInfoType travelerInfo) {
        this.travelerInfo = travelerInfo;
    }

    /** 
     * Get the 'Fulfillment' element value.
     * 
     * @return value
     */
    public Fulfillment getFulfillment() {
        return fulfillment;
    }

    /** 
     * Set the 'Fulfillment' element value.
     * 
     * @param fulfillment
     */
    public void setFulfillment(Fulfillment fulfillment) {
        this.fulfillment = fulfillment;
    }

    /** 
     * Get the 'Ticketing' element value. Information used to
    						specify the ticketing arrangement.
     * 
     * @return value
     */
    public TicketingInfoType getTicketing() {
        return ticketing;
    }

    /** 
     * Set the 'Ticketing' element value. Information used to
    						specify the ticketing arrangement.
     * 
     * @param ticketing
     */
    public void setTicketing(TicketingInfoType ticketing) {
        this.ticketing = ticketing;
    }

    /** 
     * Get the list of 'Queue' element items.
     * 
     * @return list
     */
    public List<Queue> getQueueList() {
        return queueList;
    }

    /** 
     * Set the list of 'Queue' element items.
     * 
     * @param list
     */
    public void setQueueList(List<Queue> list) {
        queueList = list;
    }

    /** 
     * Get the 'BookingReferenceID' element value. This is used for PNR
    						record locator.
     * 
     * @return value
     */
    public UniqueIDType getBookingReferenceID() {
        return bookingReferenceID;
    }

    /** 
     * Set the 'BookingReferenceID' element value. This is used for PNR
    						record locator.
     * 
     * @param bookingReferenceID
     */
    public void setBookingReferenceID(UniqueIDType bookingReferenceID) {
        this.bookingReferenceID = bookingReferenceID;
    }

    /** 
     * Get the 'TPA_Extensions' element value.
     * 
     * @return value
     */
    public TPAExtensionsType getTPAExtensions() {
        return TPAExtensions;
    }

    /** 
     * Set the 'TPA_Extensions' element value.
     * 
     * @param TPAExtensions
     */
    public void setTPAExtensions(TPAExtensionsType TPAExtensions) {
        this.TPAExtensions = TPAExtensions;
    }

    /** 
     * Get the 'TravelersFulfillments' element value.
     * 
     * @return value
     */
    public TravelersFulfillments getTravelersFulfillments() {
        return travelersFulfillments;
    }

    /** 
     * Set the 'TravelersFulfillments' element value.
     * 
     * @param travelersFulfillments
     */
    public void setTravelersFulfillments(
            TravelersFulfillments travelersFulfillments) {
        this.travelersFulfillments = travelersFulfillments;
    }

    /** 
     * Get the 'OTA_PayloadStdAttributes' attributeGroup value.
     * 
     * @return value
     */
    public OTAPayloadStdAttributes getOTAPayloadStdAttributes() {
        return OTAPayloadStdAttributes;
    }

    /** 
     * Set the 'OTA_PayloadStdAttributes' attributeGroup value.
     * 
     * @param OTAPayloadStdAttributes
     */
    public void setOTAPayloadStdAttributes(
            OTAPayloadStdAttributes OTAPayloadStdAttributes) {
        this.OTAPayloadStdAttributes = OTAPayloadStdAttributes;
    }
    /** 
     * All payment
    						information relevant to a booking request.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Fulfillment" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="PaymentDetails" minOccurs="0">
     *         &lt;!-- Reference to inner class PaymentDetails -->
     *       &lt;/xs:element>
     *       &lt;xs:element type="ns:AddressType" name="DeliveryAddress" minOccurs="0"/>
     *       &lt;xs:element type="ns:PersonNameType" name="Name" minOccurs="0"/>
     *       &lt;xs:element name="Receipt" minOccurs="0">
     *         &lt;!-- Reference to inner class Receipt -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Fulfillment
    {
        private PaymentDetails paymentDetails;
        private AddressType deliveryAddress;
        private PersonNameType name;
        private Receipt receipt;

        /** 
         * Get the 'PaymentDetails' element value.
         * 
         * @return value
         */
        public PaymentDetails getPaymentDetails() {
            return paymentDetails;
        }

        /** 
         * Set the 'PaymentDetails' element value.
         * 
         * @param paymentDetails
         */
        public void setPaymentDetails(PaymentDetails paymentDetails) {
            this.paymentDetails = paymentDetails;
        }

        /** 
         * Get the 'DeliveryAddress' element value. Ticket delivery
        									information for the booking request.
         * 
         * @return value
         */
        public AddressType getDeliveryAddress() {
            return deliveryAddress;
        }

        /** 
         * Set the 'DeliveryAddress' element value. Ticket delivery
        									information for the booking request.
         * 
         * @param deliveryAddress
         */
        public void setDeliveryAddress(AddressType deliveryAddress) {
            this.deliveryAddress = deliveryAddress;
        }

        /** 
         * Get the 'Name' element value. Purchaser name
        									details
         * 
         * @return value
         */
        public PersonNameType getName() {
            return name;
        }

        /** 
         * Set the 'Name' element value. Purchaser name
        									details
         * 
         * @param name
         */
        public void setName(PersonNameType name) {
            this.name = name;
        }

        /** 
         * Get the 'Receipt' element value.
         * 
         * @return value
         */
        public Receipt getReceipt() {
            return receipt;
        }

        /** 
         * Set the 'Receipt' element value.
         * 
         * @param receipt
         */
        public void setReceipt(Receipt receipt) {
            this.receipt = receipt;
        }
        /** 
         * Container for
        									Payment Detail.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PaymentDetails" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="ns:PaymentDetailType" name="PaymentDetail" maxOccurs="99"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class PaymentDetails
        {
            private List<PaymentDetailType> paymentDetailList = new ArrayList<PaymentDetailType>();

            /** 
             * Get the list of 'PaymentDetail' element items. Form of payment
            											details for the requested booking. It is possible to use
            											multiple forms of payment for one transaction, therefore
            											this element may be used more than once.
             * 
             * @return list
             */
            public List<PaymentDetailType> getPaymentDetailList() {
                return paymentDetailList;
            }

            /** 
             * Set the list of 'PaymentDetail' element items. Form of payment
            											details for the requested booking. It is possible to use
            											multiple forms of payment for one transaction, therefore
            											this element may be used more than once.
             * 
             * @param list
             */
            public void setPaymentDetailList(List<PaymentDetailType> list) {
                paymentDetailList = list;
            }
        }
        /** 
         *  Specifies the
        									requested distribution method for the ticket receipt.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Receipt" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" name="DistribType"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Receipt
        {
            private String distribType;

            /** 
             * Get the 'DistribType' attribute value.  Refer to OTA
            										Code List Distribution Type (DTB).
            									
             * 
             * @return value
             */
            public String getDistribType() {
                return distribType;
            }

            /** 
             * Set the 'DistribType' attribute value.  Refer to OTA
            										Code List Distribution Type (DTB).
            									
             * 
             * @param distribType
             */
            public void setDistribType(String distribType) {
                this.distribType = distribType;
            }
        }
    }
    /** 
     * Specifies information
    						necessary to place this booking on a particular host system
    						queue.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Queue" minOccurs="0" maxOccurs="10">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:string" use="optional" name="PseudoCityCode"/>
     *     &lt;xs:attribute type="xs:string" name="QueueNumber"/>
     *     &lt;xs:attribute type="xs:string" name="QueueCategory"/>
     *     &lt;xs:attribute type="xs:string" use="optional" name="DateTime"/>
     *     &lt;xs:attribute type="xs:string" use="optional" name="Text"/>
     *     &lt;xs:attribute type="xs:string" use="optional" name="CarrierCode"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Queue
    {
        private String pseudoCityCode;
        private String queueNumber;
        private String queueCategory;
        private String dateTime;
        private String text;
        private String carrierCode;

        /** 
         * Get the 'PseudoCityCode' attribute value. A 3 character
        								ATA/IATA airport/city code of the system that delivers the
        								message.
         * 
         * @return value
         */
        public String getPseudoCityCode() {
            return pseudoCityCode;
        }

        /** 
         * Set the 'PseudoCityCode' attribute value. A 3 character
        								ATA/IATA airport/city code of the system that delivers the
        								message.
         * 
         * @param pseudoCityCode
         */
        public void setPseudoCityCode(String pseudoCityCode) {
            this.pseudoCityCode = pseudoCityCode;
        }

        /** 
         * Get the 'QueueNumber' attribute value.  A number specifying
        								the requested queue in which the PNR should be placed in the
        								host system.
         * 
         * @return value
         */
        public String getQueueNumber() {
            return queueNumber;
        }

        /** 
         * Set the 'QueueNumber' attribute value.  A number specifying
        								the requested queue in which the PNR should be placed in the
        								host system.
         * 
         * @param queueNumber
         */
        public void setQueueNumber(String queueNumber) {
            this.queueNumber = queueNumber;
        }

        /** 
         * Get the 'QueueCategory' attribute value.  A subdivision of a
        								particular queue used to provide additional functional
        								granularity.
         * 
         * @return value
         */
        public String getQueueCategory() {
            return queueCategory;
        }

        /** 
         * Set the 'QueueCategory' attribute value.  A subdivision of a
        								particular queue used to provide additional functional
        								granularity.
         * 
         * @param queueCategory
         */
        public void setQueueCategory(String queueCategory) {
            this.queueCategory = queueCategory;
        }

        /** 
         * Get the 'DateTime' attribute value. Date/time when the
        								time initiated queuing should take place.
         * 
         * @return value
         */
        public String getDateTime() {
            return dateTime;
        }

        /** 
         * Set the 'DateTime' attribute value. Date/time when the
        								time initiated queuing should take place.
         * 
         * @param dateTime
         */
        public void setDateTime(String dateTime) {
            this.dateTime = dateTime;
        }

        /** 
         * Get the 'Text' attribute value. Text describing why
        								the queuing takes place.
        							
         * 
         * @return value
         */
        public String getText() {
            return text;
        }

        /** 
         * Set the 'Text' attribute value. Text describing why
        								the queuing takes place.
        							
         * 
         * @param text
         */
        public void setText(String text) {
            this.text = text;
        }

        /** 
         * Get the 'CarrierCode' attribute value. Identifies
        								airline/system on which the reservation is being queued.
         * 
         * @return value
         */
        public String getCarrierCode() {
            return carrierCode;
        }

        /** 
         * Set the 'CarrierCode' attribute value. Identifies
        								airline/system on which the reservation is being queued.
         * 
         * @param carrierCode
         */
        public void setCarrierCode(String carrierCode) {
            this.carrierCode = carrierCode;
        }
    }
}
