
package org.opentravel.ota;

import java.util.ArrayList;
import java.util.List;

/** 
 * 
 The Book Response message
 contains the itinerary, passenger and pricing
 information sent in the
 request, along with a Booking reference
 number (PNR Locator) and
 ticketing information if the booking was
 successful.
 This message
 contains similar information to a standard airline CRS or
 GDS Display
 PNR message.

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OTA_AirBookRS">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element type="ns:WarningsType" name="Warnings" minOccurs="0"/>
 *       &lt;xs:element type="ns:AirReservationType" name="AirReservation" minOccurs="0" maxOccurs="9"/>
 *       &lt;xs:element type="ns:SuccessType" name="Success" minOccurs="0"/>
 *       &lt;xs:element type="ns:ErrorsType" name="Errors" minOccurs="0"/>
 *     &lt;/xs:sequence>
 *     &lt;xs:attribute type="xs:boolean" default="false" name="Cancel"/>
 *     &lt;xs:attributeGroup ref="ns:OTA_PayloadStdAttributes"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class OTAAirBookRS
{
    private WarningsType warnings;
    private List<AirReservationType> airReservationList = new ArrayList<AirReservationType>();
    private SuccessType success;
    private ErrorsType errors;
    private Boolean cancel;
    private OTAPayloadStdAttributes OTAPayloadStdAttributes;

    /** 
     * Get the 'Warnings' element value.  Standard way to
    						indicate successful processing of an OTA message, but one in
    						which warnings are generated.
    					
     * 
     * @return value
     */
    public WarningsType getWarnings() {
        return warnings;
    }

    /** 
     * Set the 'Warnings' element value.  Standard way to
    						indicate successful processing of an OTA message, but one in
    						which warnings are generated.
    					
     * 
     * @param warnings
     */
    public void setWarnings(WarningsType warnings) {
        this.warnings = warnings;
    }

    /** 
     * Get the list of 'AirReservation' element items.  Contains all booking
    						response information pertaining to a completed reservation.
    					
     * 
     * @return list
     */
    public List<AirReservationType> getAirReservationList() {
        return airReservationList;
    }

    /** 
     * Set the list of 'AirReservation' element items.  Contains all booking
    						response information pertaining to a completed reservation.
    					
     * 
     * @param list
     */
    public void setAirReservationList(List<AirReservationType> list) {
        airReservationList = list;
    }

    /** 
     * Get the 'Success' element value.  Standard way to
    						indicate successful processing of an OTA message. Returning an
    						empty element of this type indicates success.
    					
     * 
     * @return value
     */
    public SuccessType getSuccess() {
        return success;
    }

    /** 
     * Set the 'Success' element value.  Standard way to
    						indicate successful processing of an OTA message. Returning an
    						empty element of this type indicates success.
    					
     * 
     * @param success
     */
    public void setSuccess(SuccessType success) {
        this.success = success;
    }

    /** 
     * Get the 'Errors' element value.  A collection of
    						errors that occurred during the processing of a message.
    					
     * 
     * @return value
     */
    public ErrorsType getErrors() {
        return errors;
    }

    /** 
     * Set the 'Errors' element value.  A collection of
    						errors that occurred during the processing of a message.
    					
     * 
     * @param errors
     */
    public void setErrors(ErrorsType errors) {
        this.errors = errors;
    }

    /** 
     * Get the 'Cancel' attribute value.  AWG to revisit.
    				
     * 
     * @return value
     */
    public Boolean getCancel() {
        return cancel;
    }

    /** 
     * Set the 'Cancel' attribute value.  AWG to revisit.
    				
     * 
     * @param cancel
     */
    public void setCancel(Boolean cancel) {
        this.cancel = cancel;
    }

    /** 
     * Get the 'OTA_PayloadStdAttributes' attributeGroup value.  The
    					OTA_PayloadStdAttributes defines the standard attributes that
    					appear on the root element for all OTA payloads.
    				
     * 
     * @return value
     */
    public OTAPayloadStdAttributes getOTAPayloadStdAttributes() {
        return OTAPayloadStdAttributes;
    }

    /** 
     * Set the 'OTA_PayloadStdAttributes' attributeGroup value.  The
    					OTA_PayloadStdAttributes defines the standard attributes that
    					appear on the root element for all OTA payloads.
    				
     * 
     * @param OTAPayloadStdAttributes
     */
    public void setOTAPayloadStdAttributes(
            OTAPayloadStdAttributes OTAPayloadStdAttributes) {
        this.OTAPayloadStdAttributes = OTAPayloadStdAttributes;
    }
}
