
package org.opentravel.ota;

/** 
 * 
 The Availability Request message requests pricing information for
 specific flights on specific dates for a specific number and type of
 passengers. Optional information in the message allows fare
 restriction preferences and negotiated fare contract codes to be
 included in the message.
 The pricing request contains the information necessary to perform an
 availability / sell from availability / price series of entries on
 an airline CRS or GDS.

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OTA_AirPriceRQ">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element type="ns:POS_Type" name="POS"/>
 *       &lt;xs:element type="ns:AirItineraryType" name="AirItinerary"/>
 *       &lt;xs:element type="ns:TravelerInfoSummaryType" name="TravelerInfoSummary"/>
 *       &lt;xs:element type="ns:AirReservationType" name="ModifiedSegmentInfo" minOccurs="0"/>
 *       &lt;xs:element name="FlexiFareSelectionOptions" minOccurs="0">
 *         &lt;!-- Reference to inner class FlexiFareSelectionOptions -->
 *       &lt;/xs:element>
 *       &lt;xs:element name="BundledServiceSelectionOptions" minOccurs="0">
 *         &lt;!-- Reference to inner class BundledServiceSelectionOptions -->
 *       &lt;/xs:element>
 *     &lt;/xs:sequence>
 *     &lt;xs:attributeGroup ref="ns:OTA_PayloadStdAttributes"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class OTAAirPriceRQ
{
    private POSType POS;
    private AirItineraryType airItinerary;
    private TravelerInfoSummaryType travelerInfoSummary;
    private AirReservationType modifiedSegmentInfo;
    private FlexiFareSelectionOptions flexiFareSelectionOptions;
    private BundledServiceSelectionOptions bundledServiceSelectionOptions;
    private OTAPayloadStdAttributes OTAPayloadStdAttributes;

    /** 
     * Get the 'POS' element value. Point of sale object. 
     * 
     * @return value
     */
    public POSType getPOS() {
        return POS;
    }

    /** 
     * Set the 'POS' element value. Point of sale object. 
     * 
     * @param POS
     */
    public void setPOS(POSType POS) {
        this.POS = POS;
    }

    /** 
     * Get the 'AirItinerary' element value. The Air Itineraries to
    						be priced
     * 
     * @return value
     */
    public AirItineraryType getAirItinerary() {
        return airItinerary;
    }

    /** 
     * Set the 'AirItinerary' element value. The Air Itineraries to
    						be priced
     * 
     * @param airItinerary
     */
    public void setAirItinerary(AirItineraryType airItinerary) {
        this.airItinerary = airItinerary;
    }

    /** 
     * Get the 'TravelerInfoSummary' element value. Specify passenger
    						numbers and types
     * 
     * @return value
     */
    public TravelerInfoSummaryType getTravelerInfoSummary() {
        return travelerInfoSummary;
    }

    /** 
     * Set the 'TravelerInfoSummary' element value. Specify passenger
    						numbers and types
     * 
     * @param travelerInfoSummary
     */
    public void setTravelerInfoSummary(
            TravelerInfoSummaryType travelerInfoSummary) {
        this.travelerInfoSummary = travelerInfoSummary;
    }

    /** 
     * Get the 'ModifiedSegmentInfo' element value. Contains the
    						reservation segment details to be modified.
     * 
     * @return value
     */
    public AirReservationType getModifiedSegmentInfo() {
        return modifiedSegmentInfo;
    }

    /** 
     * Set the 'ModifiedSegmentInfo' element value. Contains the
    						reservation segment details to be modified.
     * 
     * @param modifiedSegmentInfo
     */
    public void setModifiedSegmentInfo(AirReservationType modifiedSegmentInfo) {
        this.modifiedSegmentInfo = modifiedSegmentInfo;
    }

    /** 
     * Get the 'FlexiFareSelectionOptions' element value.
     * 
     * @return value
     */
    public FlexiFareSelectionOptions getFlexiFareSelectionOptions() {
        return flexiFareSelectionOptions;
    }

    /** 
     * Set the 'FlexiFareSelectionOptions' element value.
     * 
     * @param flexiFareSelectionOptions
     */
    public void setFlexiFareSelectionOptions(
            FlexiFareSelectionOptions flexiFareSelectionOptions) {
        this.flexiFareSelectionOptions = flexiFareSelectionOptions;
    }

    /** 
     * Get the 'BundledServiceSelectionOptions' element value.
     * 
     * @return value
     */
    public BundledServiceSelectionOptions getBundledServiceSelectionOptions() {
        return bundledServiceSelectionOptions;
    }

    /** 
     * Set the 'BundledServiceSelectionOptions' element value.
     * 
     * @param bundledServiceSelectionOptions
     */
    public void setBundledServiceSelectionOptions(
            BundledServiceSelectionOptions bundledServiceSelectionOptions) {
        this.bundledServiceSelectionOptions = bundledServiceSelectionOptions;
    }

    /** 
     * Get the 'OTA_PayloadStdAttributes' attributeGroup value.
     * 
     * @return value
     */
    public OTAPayloadStdAttributes getOTAPayloadStdAttributes() {
        return OTAPayloadStdAttributes;
    }

    /** 
     * Set the 'OTA_PayloadStdAttributes' attributeGroup value.
     * 
     * @param OTAPayloadStdAttributes
     */
    public void setOTAPayloadStdAttributes(
            OTAPayloadStdAttributes OTAPayloadStdAttributes) {
        this.OTAPayloadStdAttributes = OTAPayloadStdAttributes;
    }
    /** 
     * The flexibility
    						selection options.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FlexiFareSelectionOptions" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:boolean" name="OutBoundFlexiSelected" minOccurs="0" maxOccurs="1"/>
     *       &lt;xs:element type="xs:boolean" name="InBoundFlexiSelected" minOccurs="0" maxOccurs="1"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class FlexiFareSelectionOptions
    {
        private Boolean outBoundFlexiSelected;
        private Boolean inBoundFlexiSelected;

        /** 
         * Get the 'OutBoundFlexiSelected' element value. Indicates whether
        									to select out-bound flexi fares.
         * 
         * @return value
         */
        public Boolean getOutBoundFlexiSelected() {
            return outBoundFlexiSelected;
        }

        /** 
         * Set the 'OutBoundFlexiSelected' element value. Indicates whether
        									to select out-bound flexi fares.
         * 
         * @param outBoundFlexiSelected
         */
        public void setOutBoundFlexiSelected(Boolean outBoundFlexiSelected) {
            this.outBoundFlexiSelected = outBoundFlexiSelected;
        }

        /** 
         * Get the 'InBoundFlexiSelected' element value. Indicates whether
        									to select in-bound flexi fares.
         * 
         * @return value
         */
        public Boolean getInBoundFlexiSelected() {
            return inBoundFlexiSelected;
        }

        /** 
         * Set the 'InBoundFlexiSelected' element value. Indicates whether
        									to select in-bound flexi fares.
         * 
         * @param inBoundFlexiSelected
         */
        public void setInBoundFlexiSelected(Boolean inBoundFlexiSelected) {
            this.inBoundFlexiSelected = inBoundFlexiSelected;
        }
    }
    /** 
     * Bundled Services
    						selection options.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BundledServiceSelectionOptions" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:int" name="OutBoundBunldedServiceId" minOccurs="0" maxOccurs="1"/>
     *       &lt;xs:element type="xs:int" name="InBoundBunldedServiceId" minOccurs="0" maxOccurs="1"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class BundledServiceSelectionOptions
    {
        private Integer outBoundBunldedServiceId;
        private Integer inBoundBunldedServiceId;

        /** 
         * Get the 'OutBoundBunldedServiceId' element value. Bundled service ID
        									from available bundled services
         * 
         * @return value
         */
        public Integer getOutBoundBunldedServiceId() {
            return outBoundBunldedServiceId;
        }

        /** 
         * Set the 'OutBoundBunldedServiceId' element value. Bundled service ID
        									from available bundled services
         * 
         * @param outBoundBunldedServiceId
         */
        public void setOutBoundBunldedServiceId(Integer outBoundBunldedServiceId) {
            this.outBoundBunldedServiceId = outBoundBunldedServiceId;
        }

        /** 
         * Get the 'InBoundBunldedServiceId' element value. Bundled service ID
        									from available bundled services
         * 
         * @return value
         */
        public Integer getInBoundBunldedServiceId() {
            return inBoundBunldedServiceId;
        }

        /** 
         * Set the 'InBoundBunldedServiceId' element value. Bundled service ID
        									from available bundled services
         * 
         * @param inBoundBunldedServiceId
         */
        public void setInBoundBunldedServiceId(Integer inBoundBunldedServiceId) {
            this.inBoundBunldedServiceId = inBoundBunldedServiceId;
        }
    }
}
