
package org.opentravel.ota;

/** 
 * 
 The Pricing Response
 message contains a 'Priced Itinerary'. This
 includes:
 - The set of
 flights sent in the Pricing request message
 - Pricing information
 including taxes and full fare breakdown for
 each passenger type
 -
 Ticketing information
 - Fare Basis Codes and the information
 necessary to make a Fare Rules
 entry.
 This message contains similar
 information to a standard airline CRS or
 GDS itinerary pricing
 response message.

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OTA_AirPriceRS">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element type="ns:PricedItinerariesType" name="PricedItineraries" minOccurs="0"/>
 *       &lt;xs:element type="ns:SuccessType" name="Success" minOccurs="0"/>
 *       &lt;xs:element type="ns:WarningsType" name="Warnings" minOccurs="0"/>
 *       &lt;xs:element type="ns:ErrorsType" name="Errors" minOccurs="0"/>
 *     &lt;/xs:sequence>
 *     &lt;xs:attributeGroup ref="ns:OTA_PayloadStdAttributes"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class OTAAirPriceRS
{
    private PricedItinerariesType pricedItineraries;
    private SuccessType success;
    private WarningsType warnings;
    private ErrorsType errors;
    private OTAPayloadStdAttributes OTAPayloadStdAttributes;

    /** 
     * Get the 'PricedItineraries' element value.  Provides priced
    						itinerary information.
    					
     * 
     * @return value
     */
    public PricedItinerariesType getPricedItineraries() {
        return pricedItineraries;
    }

    /** 
     * Set the 'PricedItineraries' element value.  Provides priced
    						itinerary information.
    					
     * 
     * @param pricedItineraries
     */
    public void setPricedItineraries(PricedItinerariesType pricedItineraries) {
        this.pricedItineraries = pricedItineraries;
    }

    /** 
     * Get the 'Success' element value.  Standard way to
    						indicate successful processing of an OTA message. Returning an
    						empty element of this type indicates success.
    					
     * 
     * @return value
     */
    public SuccessType getSuccess() {
        return success;
    }

    /** 
     * Set the 'Success' element value.  Standard way to
    						indicate successful processing of an OTA message. Returning an
    						empty element of this type indicates success.
    					
     * 
     * @param success
     */
    public void setSuccess(SuccessType success) {
        this.success = success;
    }

    /** 
     * Get the 'Warnings' element value.  Standard way to
    						indicate successful processing of an OTA message, but one in
    						which warnings are generated.
    					
     * 
     * @return value
     */
    public WarningsType getWarnings() {
        return warnings;
    }

    /** 
     * Set the 'Warnings' element value.  Standard way to
    						indicate successful processing of an OTA message, but one in
    						which warnings are generated.
    					
     * 
     * @param warnings
     */
    public void setWarnings(WarningsType warnings) {
        this.warnings = warnings;
    }

    /** 
     * Get the 'Errors' element value.  A collection of
    						errors that occurred during the processing of a message.
    					
     * 
     * @return value
     */
    public ErrorsType getErrors() {
        return errors;
    }

    /** 
     * Set the 'Errors' element value.  A collection of
    						errors that occurred during the processing of a message.
    					
     * 
     * @param errors
     */
    public void setErrors(ErrorsType errors) {
        this.errors = errors;
    }

    /** 
     * Get the 'OTA_PayloadStdAttributes' attributeGroup value.  The
    					OTA_PayloadStdAttributes defines the standard attributes that
    					appear on the root element for all OTA payloads.
    				
     * 
     * @return value
     */
    public OTAPayloadStdAttributes getOTAPayloadStdAttributes() {
        return OTAPayloadStdAttributes;
    }

    /** 
     * Set the 'OTA_PayloadStdAttributes' attributeGroup value.  The
    					OTA_PayloadStdAttributes defines the standard attributes that
    					appear on the root element for all OTA payloads.
    				
     * 
     * @param OTAPayloadStdAttributes
     */
    public void setOTAPayloadStdAttributes(
            OTAPayloadStdAttributes OTAPayloadStdAttributes) {
        this.OTAPayloadStdAttributes = OTAPayloadStdAttributes;
    }
}
