
package org.opentravel.ota;

import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

/** 
 * 
 A generic message, available as an action on several OTA services
 which requests a server to read and return the document type
 identified by the UniqueID element.

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OTA_ReadRQ">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element type="ns:POS_Type" name="POS" minOccurs="0"/>
 *       &lt;xs:element type="ns:UniqueID_Type" name="UniqueID" minOccurs="0"/>
 *       &lt;xs:element name="ReadRequests" minOccurs="0">
 *         &lt;!-- Reference to inner class ReadRequests -->
 *       &lt;/xs:element>
 *       &lt;xs:element ref="ns:TPA_Extensions"/>
 *     &lt;/xs:sequence>
 *     &lt;xs:attributeGroup ref="ns:OTA_PayloadStdAttributes"/>
 *     &lt;xs:attributeGroup ref="ns:ReqRespVersion"/>
 *     &lt;xs:attribute type="xs:string" name="ReservationType"/>
 *     &lt;xs:attribute type="xs:boolean" use="optional" name="ReturnListIndicator"/>
 *     &lt;xs:attributeGroup ref="ns:ResponseGroup"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * 
 * &lt;xs:attributeGroup xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ReqRespVersion">
 *   &lt;xs:attribute type="xs:string" use="optional" name="ReqRespVersion"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class OTAReadRQ
{
    private POSType POS;
    private UniqueIDType uniqueID;
    private ReadRequests readRequests;
    private TPAExtensionsType TPAExtensions;
    private OTAPayloadStdAttributes OTAPayloadStdAttributes;
    private String reqRespVersion;
    private String reservationType;
    private Boolean returnListIndicator;
    private ResponseGroup responseGroup;

    /** 
     * Get the 'POS' element value. Identifies the party
    						or connection channel making the request.
     * 
     * @return value
     */
    public POSType getPOS() {
        return POS;
    }

    /** 
     * Set the 'POS' element value. Identifies the party
    						or connection channel making the request.
     * 
     * @param POS
     */
    public void setPOS(POSType POS) {
        this.POS = POS;
    }

    /** 
     * Get the 'UniqueID' element value. A reference to
    						identify the booking.
     * 
     * @return value
     */
    public UniqueIDType getUniqueID() {
        return uniqueID;
    }

    /** 
     * Set the 'UniqueID' element value. A reference to
    						identify the booking.
     * 
     * @param uniqueID
     */
    public void setUniqueID(UniqueIDType uniqueID) {
        this.uniqueID = uniqueID;
    }

    /** 
     * Get the 'ReadRequests' element value.
     * 
     * @return value
     */
    public ReadRequests getReadRequests() {
        return readRequests;
    }

    /** 
     * Set the 'ReadRequests' element value.
     * 
     * @param readRequests
     */
    public void setReadRequests(ReadRequests readRequests) {
        this.readRequests = readRequests;
    }

    /** 
     * Get the 'TPA_Extensions' element value.
     * 
     * @return value
     */
    public TPAExtensionsType getTPAExtensions() {
        return TPAExtensions;
    }

    /** 
     * Set the 'TPA_Extensions' element value.
     * 
     * @param TPAExtensions
     */
    public void setTPAExtensions(TPAExtensionsType TPAExtensions) {
        this.TPAExtensions = TPAExtensions;
    }

    /** 
     * Get the 'OTA_PayloadStdAttributes' attributeGroup value.
     * 
     * @return value
     */
    public OTAPayloadStdAttributes getOTAPayloadStdAttributes() {
        return OTAPayloadStdAttributes;
    }

    /** 
     * Set the 'OTA_PayloadStdAttributes' attributeGroup value.
     * 
     * @param OTAPayloadStdAttributes
     */
    public void setOTAPayloadStdAttributes(
            OTAPayloadStdAttributes OTAPayloadStdAttributes) {
        this.OTAPayloadStdAttributes = OTAPayloadStdAttributes;
    }

    /** 
     * Get the 'ReqRespVersion' attribute value. Used to request the
    				version of the payload message desired for the response.
     * 
     * @return value
     */
    public String getReqRespVersion() {
        return reqRespVersion;
    }

    /** 
     * Set the 'ReqRespVersion' attribute value. Used to request the
    				version of the payload message desired for the response.
     * 
     * @param reqRespVersion
     */
    public void setReqRespVersion(String reqRespVersion) {
        this.reqRespVersion = reqRespVersion;
    }

    /** 
     * Get the 'ReservationType' attribute value. To specify the type of
    					reservation, Global, Air, Hotel, Car, Package, or Golf, that is
    					being requested. Refer to OTA Code List Travel Sector (TVS). 
     * 
     * @return value
     */
    public String getReservationType() {
        return reservationType;
    }

    /** 
     * Set the 'ReservationType' attribute value. To specify the type of
    					reservation, Global, Air, Hotel, Car, Package, or Golf, that is
    					being requested. Refer to OTA Code List Travel Sector (TVS). 
     * 
     * @param reservationType
     */
    public void setReservationType(String reservationType) {
        this.reservationType = reservationType;
    }

    /** 
     * Get the 'ReturnListIndicator' attribute value. To indicate if a list
    					should always be returned even when only one reservation matches
    					the input criteria. The default is to return the reservation
    					record. If set to true, then always return a list. 
     * 
     * @return value
     */
    public Boolean getReturnListIndicator() {
        return returnListIndicator;
    }

    /** 
     * Set the 'ReturnListIndicator' attribute value. To indicate if a list
    					should always be returned even when only one reservation matches
    					the input criteria. The default is to return the reservation
    					record. If set to true, then always return a list. 
     * 
     * @param returnListIndicator
     */
    public void setReturnListIndicator(Boolean returnListIndicator) {
        this.returnListIndicator = returnListIndicator;
    }

    /** 
     * Get the 'ResponseGroup' attributeGroup value. Used to indicate a
    					maximum number of items desired in the list response message or
    					when used for subsequent retrievals of additional data the
    					MoreDataEchoToken determines where to continue the list.
     * 
     * @return value
     */
    public ResponseGroup getResponseGroup() {
        return responseGroup;
    }

    /** 
     * Set the 'ResponseGroup' attributeGroup value. Used to indicate a
    					maximum number of items desired in the list response message or
    					when used for subsequent retrievals of additional data the
    					MoreDataEchoToken determines where to continue the list.
     * 
     * @param responseGroup
     */
    public void setResponseGroup(ResponseGroup responseGroup) {
        this.responseGroup = responseGroup;
    }
    /** 
     * A grouping of Read
    						Requests
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ReadRequests" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:choice>
     *       &lt;xs:element name="ReadRequest" minOccurs="0" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class ReadRequest -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="GlobalReservationReadRequest" minOccurs="0" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class GlobalReservationReadRequest -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="AirReadRequest" minOccurs="0" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class AirReadRequest -->
     *       &lt;/xs:element>
     *     &lt;/xs:choice>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class ReadRequests
    {
        private int readRequestsSelect = -1;
        private static final int READ_REQUEST_LIST_CHOICE = 0;
        private static final int GLOBAL_RESERVATION_READ_REQUEST_LIST_CHOICE = 1;
        private static final int AIR_READ_REQUEST_LIST_CHOICE = 2;
        private List<ReadRequest> readRequestList = new ArrayList<ReadRequest>();
        private List<GlobalReservationReadRequest> globalReservationReadRequestList = new ArrayList<GlobalReservationReadRequest>();
        private List<AirReadRequest> airReadRequestList = new ArrayList<AirReadRequest>();

        private void setReadRequestsSelect(int choice) {
            if (readRequestsSelect == -1) {
                readRequestsSelect = choice;
            } else if (readRequestsSelect != choice) {
                throw new IllegalStateException(
                        "Need to call clearReadRequestsSelect() before changing existing choice");
            }
        }

        /** 
         * Clear the choice selection.
         */
        public void clearReadRequestsSelect() {
            readRequestsSelect = -1;
        }

        /** 
         * Check if ReadRequestList is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifReadRequestList() {
            return readRequestsSelect == READ_REQUEST_LIST_CHOICE;
        }

        /** 
         * Get the list of 'ReadRequest' element items.
         * 
         * @return list
         */
        public List<ReadRequest> getReadRequestList() {
            return readRequestList;
        }

        /** 
         * Set the list of 'ReadRequest' element items.
         * 
         * @param list
         */
        public void setReadRequestList(List<ReadRequest> list) {
            setReadRequestsSelect(READ_REQUEST_LIST_CHOICE);
            readRequestList = list;
        }

        /** 
         * Check if GlobalReservationReadRequestList is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifGlobalReservationReadRequestList() {
            return readRequestsSelect == GLOBAL_RESERVATION_READ_REQUEST_LIST_CHOICE;
        }

        /** 
         * Get the list of 'GlobalReservationReadRequest' element items.
         * 
         * @return list
         */
        public List<GlobalReservationReadRequest> getGlobalReservationReadRequestList() {
            return globalReservationReadRequestList;
        }

        /** 
         * Set the list of 'GlobalReservationReadRequest' element items.
         * 
         * @param list
         */
        public void setGlobalReservationReadRequestList(
                List<GlobalReservationReadRequest> list) {
            setReadRequestsSelect(GLOBAL_RESERVATION_READ_REQUEST_LIST_CHOICE);
            globalReservationReadRequestList = list;
        }

        /** 
         * Check if AirReadRequestList is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifAirReadRequestList() {
            return readRequestsSelect == AIR_READ_REQUEST_LIST_CHOICE;
        }

        /** 
         * Get the list of 'AirReadRequest' element items.
         * 
         * @return list
         */
        public List<AirReadRequest> getAirReadRequestList() {
            return airReadRequestList;
        }

        /** 
         * Set the list of 'AirReadRequest' element items.
         * 
         * @param list
         */
        public void setAirReadRequestList(List<AirReadRequest> list) {
            setReadRequestsSelect(AIR_READ_REQUEST_LIST_CHOICE);
            airReadRequestList = list;
        }
        /** 
         * A request to read a
        									reservation when the booking reference is known. 
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ReadRequest" minOccurs="0" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="ns:UniqueID_Type" name="UniqueID"/>
         *       &lt;xs:element type="ns:VerificationType" name="Verification" minOccurs="0"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class ReadRequest
        {
            private UniqueIDType uniqueID;
            private VerificationType verification;

            /** 
             * Get the 'UniqueID' element value. The booking
            											reference for the reservation.
             * 
             * @return value
             */
            public UniqueIDType getUniqueID() {
                return uniqueID;
            }

            /** 
             * Set the 'UniqueID' element value. The booking
            											reference for the reservation.
             * 
             * @param uniqueID
             */
            public void setUniqueID(UniqueIDType uniqueID) {
                this.uniqueID = uniqueID;
            }

            /** 
             * Get the 'Verification' element value. This is to be
            											used for verification that the record being sent is the
            											specific record requested. This is optional and is intended
            											to provide a more secure mechanism to ensure the correct
            											record is being sent. 
             * 
             * @return value
             */
            public VerificationType getVerification() {
                return verification;
            }

            /** 
             * Set the 'Verification' element value. This is to be
            											used for verification that the record being sent is the
            											specific record requested. This is optional and is intended
            											to provide a more secure mechanism to ensure the correct
            											record is being sent. 
             * 
             * @param verification
             */
            public void setVerification(VerificationType verification) {
                this.verification = verification;
            }
        }
        /** 
         * An individual Read
        									Request for a global reservation when the booking reference is
        									not known
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="GlobalReservationReadRequest" minOccurs="0" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="ns:PersonNameType" name="TravelerName"/>
         *     &lt;/xs:sequence>
         *     &lt;xs:attributeGroup ref="ns:DateTimeSpanGroup"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class GlobalReservationReadRequest
        {
            private PersonNameType travelerName;
            private DateTimeSpanGroup dateTimeSpanGroup;

            /** 
             * Get the 'TravelerName' element value. The name of the
            											traveler for whom the reservation is requested.
             * 
             * @return value
             */
            public PersonNameType getTravelerName() {
                return travelerName;
            }

            /** 
             * Set the 'TravelerName' element value. The name of the
            											traveler for whom the reservation is requested.
             * 
             * @param travelerName
             */
            public void setTravelerName(PersonNameType travelerName) {
                this.travelerName = travelerName;
            }

            /** 
             * Get the 'DateTimeSpanGroup' attributeGroup value. The travel start
            										date.
             * 
             * @return value
             */
            public DateTimeSpanGroup getDateTimeSpanGroup() {
                return dateTimeSpanGroup;
            }

            /** 
             * Set the 'DateTimeSpanGroup' attributeGroup value. The travel start
            										date.
             * 
             * @param dateTimeSpanGroup
             */
            public void setDateTimeSpanGroup(DateTimeSpanGroup dateTimeSpanGroup) {
                this.dateTimeSpanGroup = dateTimeSpanGroup;
            }
        }
        /** 
         * To retrieve an
        									airline reservation when the booking reference is not known or
        									to search for a list of passengers meeting certain criteria 
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AirReadRequest" minOccurs="0" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="ns:POS_Type" name="POS" minOccurs="0"/>
         *       &lt;xs:element type="ns:CompanyNameType" name="Airline" minOccurs="0"/>
         *       &lt;xs:element type="xs:string" name="FlightNumber" minOccurs="0"/>
         *       &lt;xs:element type="ns:LocationType" name="DepartureAirport" minOccurs="0"/>
         *       &lt;xs:element type="xs:date" name="DepartureDate" minOccurs="0"/>
         *       &lt;xs:element type="ns:PersonNameType" name="Name" minOccurs="0"/>
         *       &lt;xs:element name="Telephone" minOccurs="0">
         *         &lt;xs:complexType>
         *           &lt;xs:attributeGroup ref="ns:TelephoneGroup"/>
         *         &lt;/xs:complexType>
         *       &lt;/xs:element>
         *       &lt;xs:element name="CustLoyalty" minOccurs="0">
         *         &lt;xs:complexType>
         *           &lt;xs:attributeGroup ref="ns:CustomerLoyaltyGroup"/>
         *         &lt;/xs:complexType>
         *       &lt;/xs:element>
         *       &lt;xs:element type="ns:PaymentCardType" name="CreditCardInfo" minOccurs="0"/>
         *       &lt;xs:element type="ns:TicketingInfoRS_Type" name="TicketNumber" minOccurs="0"/>
         *       &lt;xs:element name="QueueInfo" minOccurs="0">
         *         &lt;!-- Reference to inner class QueueInfo -->
         *       &lt;/xs:element>
         *       &lt;xs:element ref="ns:TPA_Extensions" minOccurs="0"/>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute type="xs:string" use="optional" name="SeatNumber"/>
         *     &lt;xs:attribute type="xs:boolean" use="optional" name="IncludeFF_EquivPartnerLev"/>
         *     &lt;xs:attribute type="xs:boolean" use="optional" name="ReturnFF_Number"/>
         *     &lt;xs:attribute type="xs:boolean" use="optional" name="ReturnDownlineSeg"/>
         *     &lt;xs:attribute use="optional" name="InfoToReturn">
         *       &lt;xs:simpleType>
         *         &lt;!-- Reference to inner class InfoToReturn -->
         *       &lt;/xs:simpleType>
         *     &lt;/xs:attribute>
         *     &lt;xs:attribute use="optional" name="FF_RequestCriteria">
         *       &lt;xs:simpleType>
         *         &lt;!-- Reference to inner class FFRequestCriteria -->
         *       &lt;/xs:simpleType>
         *     &lt;/xs:attribute>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class AirReadRequest
        {
            private POSType POS;
            private CompanyNameType airline;
            private String flightNumber;
            private LocationType departureAirport;
            private Date departureDate;
            private PersonNameType name;
            private TelephoneGroup telephone;
            private CustomerLoyaltyGroup custLoyalty;
            private PaymentCardType creditCardInfo;
            private TicketingInfoRSType ticketNumber;
            private QueueInfo queueInfo;
            private TPAExtensionsType TPAExtensions;
            private String seatNumber;
            private Boolean includeFFEquivPartnerLev;
            private Boolean returnFFNumber;
            private Boolean returnDownlineSeg;
            private InfoToReturn infoToReturn;
            private FFRequestCriteria FFRequestCriteria1;

            /** 
             * Get the 'POS' element value. To request a
            											list of reservations made by specified travel agent, ERSP,
            											booking channel, etc.
             * 
             * @return value
             */
            public POSType getPOS() {
                return POS;
            }

            /** 
             * Set the 'POS' element value. To request a
            											list of reservations made by specified travel agent, ERSP,
            											booking channel, etc.
             * 
             * @param POS
             */
            public void setPOS(POSType POS) {
                this.POS = POS;
            }

            /** 
             * Get the 'Airline' element value. Specify airline
            											on which the person is booked.
            										
             * 
             * @return value
             */
            public CompanyNameType getAirline() {
                return airline;
            }

            /** 
             * Set the 'Airline' element value. Specify airline
            											on which the person is booked.
            										
             * 
             * @param airline
             */
            public void setAirline(CompanyNameType airline) {
                this.airline = airline;
            }

            /** 
             * Get the 'FlightNumber' element value. Specific flight
            											number on which the passenger is booked.
             * 
             * @return value
             */
            public String getFlightNumber() {
                return flightNumber;
            }

            /** 
             * Set the 'FlightNumber' element value. Specific flight
            											number on which the passenger is booked.
             * 
             * @param flightNumber
             */
            public void setFlightNumber(String flightNumber) {
                this.flightNumber = flightNumber;
            }

            /** 
             * Get the 'DepartureAirport' element value. Flight Origin -
            											IATA 3 letter code.  
             * 
             * @return value
             */
            public LocationType getDepartureAirport() {
                return departureAirport;
            }

            /** 
             * Set the 'DepartureAirport' element value. Flight Origin -
            											IATA 3 letter code.  
             * 
             * @param departureAirport
             */
            public void setDepartureAirport(LocationType departureAirport) {
                this.departureAirport = departureAirport;
            }

            /** 
             * Get the 'DepartureDate' element value. Request a
            											reservation with this departure date.
             * 
             * @return value
             */
            public Date getDepartureDate() {
                return departureDate;
            }

            /** 
             * Set the 'DepartureDate' element value. Request a
            											reservation with this departure date.
             * 
             * @param departureDate
             */
            public void setDepartureDate(Date departureDate) {
                this.departureDate = departureDate;
            }

            /** 
             * Get the 'Name' element value. Request a
            											reservation based on a passenger name.
             * 
             * @return value
             */
            public PersonNameType getName() {
                return name;
            }

            /** 
             * Set the 'Name' element value. Request a
            											reservation based on a passenger name.
             * 
             * @param name
             */
            public void setName(PersonNameType name) {
                this.name = name;
            }

            /** 
             * Get the 'TelephoneGroup' attributeGroup value. Request a
            											reservation based on a telephone number.
             * 
             * @return value
             */
            public TelephoneGroup getTelephone() {
                return telephone;
            }

            /** 
             * Set the 'TelephoneGroup' attributeGroup value. Request a
            											reservation based on a telephone number.
             * 
             * @param telephone
             */
            public void setTelephone(TelephoneGroup telephone) {
                this.telephone = telephone;
            }

            /** 
             * Get the 'CustomerLoyaltyGroup' attributeGroup value. Request booking
            											records based on frequent flyer information.
             * 
             * @return value
             */
            public CustomerLoyaltyGroup getCustLoyalty() {
                return custLoyalty;
            }

            /** 
             * Set the 'CustomerLoyaltyGroup' attributeGroup value. Request booking
            											records based on frequent flyer information.
             * 
             * @param custLoyalty
             */
            public void setCustLoyalty(CustomerLoyaltyGroup custLoyalty) {
                this.custLoyalty = custLoyalty;
            }

            /** 
             * Get the 'CreditCardInfo' element value. Request booking
            											records by credit card information.
             * 
             * @return value
             */
            public PaymentCardType getCreditCardInfo() {
                return creditCardInfo;
            }

            /** 
             * Set the 'CreditCardInfo' element value. Request booking
            											records by credit card information.
             * 
             * @param creditCardInfo
             */
            public void setCreditCardInfo(PaymentCardType creditCardInfo) {
                this.creditCardInfo = creditCardInfo;
            }

            /** 
             * Get the 'TicketNumber' element value. Request booking
            											record by ticket number.
             * 
             * @return value
             */
            public TicketingInfoRSType getTicketNumber() {
                return ticketNumber;
            }

            /** 
             * Set the 'TicketNumber' element value. Request booking
            											record by ticket number.
             * 
             * @param ticketNumber
             */
            public void setTicketNumber(TicketingInfoRSType ticketNumber) {
                this.ticketNumber = ticketNumber;
            }

            /** 
             * Get the 'QueueInfo' element value.
             * 
             * @return value
             */
            public QueueInfo getQueueInfo() {
                return queueInfo;
            }

            /** 
             * Set the 'QueueInfo' element value.
             * 
             * @param queueInfo
             */
            public void setQueueInfo(QueueInfo queueInfo) {
                this.queueInfo = queueInfo;
            }

            /** 
             * Get the 'TPA_Extensions' element value.
             * 
             * @return value
             */
            public TPAExtensionsType getTPAExtensions() {
                return TPAExtensions;
            }

            /** 
             * Set the 'TPA_Extensions' element value.
             * 
             * @param TPAExtensions
             */
            public void setTPAExtensions(TPAExtensionsType TPAExtensions) {
                this.TPAExtensions = TPAExtensions;
            }

            /** 
             * Get the 'SeatNumber' attribute value. To specify a seat
            										number to be used as criteria for requesting a booking
            										record. 
             * 
             * @return value
             */
            public String getSeatNumber() {
                return seatNumber;
            }

            /** 
             * Set the 'SeatNumber' attribute value. To specify a seat
            										number to be used as criteria for requesting a booking
            										record. 
             * 
             * @param seatNumber
             */
            public void setSeatNumber(String seatNumber) {
                this.seatNumber = seatNumber;
            }

            /** 
             * Get the 'IncludeFF_EquivPartnerLev' attribute value. When requesting
            										booking records by frequent flyer level, this is used to
            										indicate that booking records with the codeshare equivalent
            										partner level should also be returned.
             * 
             * @return value
             */
            public Boolean getIncludeFFEquivPartnerLev() {
                return includeFFEquivPartnerLev;
            }

            /** 
             * Set the 'IncludeFF_EquivPartnerLev' attribute value. When requesting
            										booking records by frequent flyer level, this is used to
            										indicate that booking records with the codeshare equivalent
            										partner level should also be returned.
             * 
             * @param includeFFEquivPartnerLev
             */
            public void setIncludeFFEquivPartnerLev(
                    Boolean includeFFEquivPartnerLev) {
                this.includeFFEquivPartnerLev = includeFFEquivPartnerLev;
            }

            /** 
             * Get the 'ReturnFF_Number' attribute value. To specify that
            										FF number should be returned for each booking record in the
            										list. The default is do not return, set to true, the FF
            										number should be returned.
             * 
             * @return value
             */
            public Boolean getReturnFFNumber() {
                return returnFFNumber;
            }

            /** 
             * Set the 'ReturnFF_Number' attribute value. To specify that
            										FF number should be returned for each booking record in the
            										list. The default is do not return, set to true, the FF
            										number should be returned.
             * 
             * @param returnFFNumber
             */
            public void setReturnFFNumber(Boolean returnFFNumber) {
                this.returnFFNumber = returnFFNumber;
            }

            /** 
             * Get the 'ReturnDownlineSeg' attribute value. To specify that
            										downline segment info should be returned. The default is do
            										not return, set to true, the information should be returned.
             * 
             * @return value
             */
            public Boolean getReturnDownlineSeg() {
                return returnDownlineSeg;
            }

            /** 
             * Set the 'ReturnDownlineSeg' attribute value. To specify that
            										downline segment info should be returned. The default is do
            										not return, set to true, the information should be returned.
             * 
             * @param returnDownlineSeg
             */
            public void setReturnDownlineSeg(Boolean returnDownlineSeg) {
                this.returnDownlineSeg = returnDownlineSeg;
            }

            /** 
             * Get the 'InfoToReturn' attribute value. To specify what
            										type of FF level information should be returned.
             * 
             * @return value
             */
            public InfoToReturn getInfoToReturn() {
                return infoToReturn;
            }

            /** 
             * Set the 'InfoToReturn' attribute value. To specify what
            										type of FF level information should be returned.
             * 
             * @param infoToReturn
             */
            public void setInfoToReturn(InfoToReturn infoToReturn) {
                this.infoToReturn = infoToReturn;
            }

            /** 
             * Get the 'FF_RequestCriteria' attribute value. To specify
            										criteria as to whether to return only the FF level specified
            										or levels above and below.
             * 
             * @return value
             */
            public FFRequestCriteria getFFRequestCriteria1() {
                return FFRequestCriteria1;
            }

            /** 
             * Set the 'FF_RequestCriteria' attribute value. To specify
            										criteria as to whether to return only the FF level specified
            										or levels above and below.
             * 
             * @param FFRequestCriteria1
             */
            public void setFFRequestCriteria1(
                    FFRequestCriteria FFRequestCriteria1) {
                this.FFRequestCriteria1 = FFRequestCriteria1;
            }
            /** 
             * Requests items
            											from a booking file queue. 
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="QueueInfo" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="Queue" maxOccurs="99">
             *         &lt;!-- Reference to inner class Queue -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:boolean" name="FirstItemOnlyInd"/>
             *     &lt;xs:attribute type="xs:boolean" name="RemoveFromQueueInd"/>
             *     &lt;xs:attribute type="xs:boolean" name="FullDataInd"/>
             *     &lt;xs:attribute type="xs:string" name="StartDate"/>
             *     &lt;xs:attribute type="xs:string" name="EndDate"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class QueueInfo
            {
                private List<Queue> queueList = new ArrayList<Queue>();
                private Boolean firstItemOnlyInd;
                private Boolean removeFromQueueInd;
                private Boolean fullDataInd;
                private String startDate;
                private String endDate;

                /** 
                 * Get the list of 'Queue' element items.
                 * 
                 * @return list
                 */
                public List<Queue> getQueueList() {
                    return queueList;
                }

                /** 
                 * Set the list of 'Queue' element items.
                 * 
                 * @param list
                 */
                public void setQueueList(List<Queue> list) {
                    queueList = list;
                }

                /** 
                 * Get the 'FirstItemOnlyInd' attribute value. If true, only
                													the first item on the queue is to be returned. If false,
                													all items on the queue are to be returned.
                 * 
                 * @return value
                 */
                public Boolean getFirstItemOnlyInd() {
                    return firstItemOnlyInd;
                }

                /** 
                 * Set the 'FirstItemOnlyInd' attribute value. If true, only
                													the first item on the queue is to be returned. If false,
                													all items on the queue are to be returned.
                 * 
                 * @param firstItemOnlyInd
                 */
                public void setFirstItemOnlyInd(Boolean firstItemOnlyInd) {
                    this.firstItemOnlyInd = firstItemOnlyInd;
                }

                /** 
                 * Get the 'RemoveFromQueueInd' attribute value. If true, items
                													are to be removed from the queue after display. If false,
                													items are to remain on the queue after display. If this
                													attribute is omitted, items on the queue are to be
                													retained on the queue.
                 * 
                 * @return value
                 */
                public Boolean getRemoveFromQueueInd() {
                    return removeFromQueueInd;
                }

                /** 
                 * Set the 'RemoveFromQueueInd' attribute value. If true, items
                													are to be removed from the queue after display. If false,
                													items are to remain on the queue after display. If this
                													attribute is omitted, items on the queue are to be
                													retained on the queue.
                 * 
                 * @param removeFromQueueInd
                 */
                public void setRemoveFromQueueInd(Boolean removeFromQueueInd) {
                    this.removeFromQueueInd = removeFromQueueInd;
                }

                /** 
                 * Get the 'FullDataInd' attribute value. Option to
                													define if the full booking file data need to be returned.
                													If true, all booking file info is returned. If false,
                													only the condensed info is returned.
                 * 
                 * @return value
                 */
                public Boolean getFullDataInd() {
                    return fullDataInd;
                }

                /** 
                 * Set the 'FullDataInd' attribute value. Option to
                													define if the full booking file data need to be returned.
                													If true, all booking file info is returned. If false,
                													only the condensed info is returned.
                 * 
                 * @param fullDataInd
                 */
                public void setFullDataInd(Boolean fullDataInd) {
                    this.fullDataInd = fullDataInd;
                }

                /** 
                 * Get the 'StartDate' attribute value. Bookings
                													modified after this start date or date time should be
                													returned. If used in conjunction with an end date, only
                													bookings modified within that date range should be
                													returned.
                 * 
                 * @return value
                 */
                public String getStartDate() {
                    return startDate;
                }

                /** 
                 * Set the 'StartDate' attribute value. Bookings
                													modified after this start date or date time should be
                													returned. If used in conjunction with an end date, only
                													bookings modified within that date range should be
                													returned.
                 * 
                 * @param startDate
                 */
                public void setStartDate(String startDate) {
                    this.startDate = startDate;
                }

                /** 
                 * Get the 'EndDate' attribute value. Bookings
                													modified before this end date or date time should be
                													returned. If used in conjunction with a start date, only
                													bookings modified within that date range should be
                													returned.
                 * 
                 * @return value
                 */
                public String getEndDate() {
                    return endDate;
                }

                /** 
                 * Set the 'EndDate' attribute value. Bookings
                													modified before this end date or date time should be
                													returned. If used in conjunction with a start date, only
                													bookings modified within that date range should be
                													returned.
                 * 
                 * @param endDate
                 */
                public void setEndDate(String endDate) {
                    this.endDate = endDate;
                }
                /** 
                 * Specifies
                														queue information.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Queue" maxOccurs="99">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" name="PseudoCityCode"/>
                 *     &lt;xs:attribute type="xs:string" name="SystemCode"/>
                 *     &lt;xs:attribute type="xs:string" use="required" name="QueueNumber"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Queue
                {
                    private String pseudoCityCode;
                    private String systemCode;
                    private String queueNumber;

                    /** 
                     * Get the 'PseudoCityCode' attribute value. An ATA/IATA
                    															airport/city code, office code, pseudo city code, etc.
                    															of the queue to be returned. If this is omitted, the
                    															pseudo city code contained in the point of sale
                    															information should be used.
                     * 
                     * @return value
                     */
                    public String getPseudoCityCode() {
                        return pseudoCityCode;
                    }

                    /** 
                     * Set the 'PseudoCityCode' attribute value. An ATA/IATA
                    															airport/city code, office code, pseudo city code, etc.
                    															of the queue to be returned. If this is omitted, the
                    															pseudo city code contained in the point of sale
                    															information should be used.
                     * 
                     * @param pseudoCityCode
                     */
                    public void setPseudoCityCode(String pseudoCityCode) {
                        this.pseudoCityCode = pseudoCityCode;
                    }

                    /** 
                     * Get the 'SystemCode' attribute value. Identifies
                    															the airline and/or system where the queue resides. If
                    															this is omitted, the airline and/or system code
                    															(AirlineVendorID) contained in the point of sale
                    															information should be used.
                     * 
                     * @return value
                     */
                    public String getSystemCode() {
                        return systemCode;
                    }

                    /** 
                     * Set the 'SystemCode' attribute value. Identifies
                    															the airline and/or system where the queue resides. If
                    															this is omitted, the airline and/or system code
                    															(AirlineVendorID) contained in the point of sale
                    															information should be used.
                     * 
                     * @param systemCode
                     */
                    public void setSystemCode(String systemCode) {
                        this.systemCode = systemCode;
                    }

                    /** 
                     * Get the 'QueueNumber' attribute value. An
                    															identifier specifying the requested queue on which the
                    															booking file resides in the system.
                     * 
                     * @return value
                     */
                    public String getQueueNumber() {
                        return queueNumber;
                    }

                    /** 
                     * Set the 'QueueNumber' attribute value. An
                    															identifier specifying the requested queue on which the
                    															booking file resides in the system.
                     * 
                     * @param queueNumber
                     */
                    public void setQueueNumber(String queueNumber) {
                        this.queueNumber = queueNumber;
                    }
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
             *   &lt;xs:restriction base="xs:string">
             *     &lt;xs:enumeration value="ListofFF_StatusLevels"/>
             *     &lt;xs:enumeration value="NoFF_Status"/>
             *     &lt;xs:enumeration value="All"/>
             *   &lt;/xs:restriction>
             * &lt;/xs:simpleType>
             * </pre>
             */
            public static enum InfoToReturn {
                LISTOF_FF_STATUS_LEVELS("ListofFF_StatusLevels"), NO_FF_STATUS(
                        "NoFF_Status"), ALL("All");
                private final String value;

                private InfoToReturn(String value) {
                    this.value = value;
                }

                public String xmlValue() {
                    return value;
                }

                public static InfoToReturn convert(String value) {
                    for (InfoToReturn inst : values()) {
                        if (inst.xmlValue().equals(value)) {
                            return inst;
                        }
                    }
                    return null;
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
             *   &lt;xs:restriction base="xs:string">
             *     &lt;xs:enumeration value="ReturnLevelAndAbove"/>
             *     &lt;xs:enumeration value="ReturnLevelAndBelow"/>
             *     &lt;xs:enumeration value="ReturnOnlySpecifiedLevel"/>
             *   &lt;/xs:restriction>
             * &lt;/xs:simpleType>
             * </pre>
             */
            public static enum FFRequestCriteria {
                RETURN_LEVEL_AND_ABOVE("ReturnLevelAndAbove"), RETURN_LEVEL_AND_BELOW(
                        "ReturnLevelAndBelow"), RETURN_ONLY_SPECIFIED_LEVEL(
                        "ReturnOnlySpecifiedLevel");
                private final String value;

                private FFRequestCriteria(String value) {
                    this.value = value;
                }

                public String xmlValue() {
                    return value;
                }

                public static FFRequestCriteria convert(String value) {
                    for (FFRequestCriteria inst : values()) {
                        if (inst.xmlValue().equals(value)) {
                            return inst;
                        }
                    }
                    return null;
                }
            }
        }
    }
}
