
package org.opentravel.ota;

/** 
 * The break down of flexible fare
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PerPaxFlexifareBDType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="PerPaxFlexiFareAmount" minOccurs="0">
 *       &lt;!-- Reference to inner class PerPaxFlexiFareAmount -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PerPaxFlexifareBDType
{
    private PerPaxFlexiFareAmount perPaxFlexiFareAmount;

    /** 
     * Get the 'PerPaxFlexiFareAmount' element value.
     * 
     * @return value
     */
    public PerPaxFlexiFareAmount getPerPaxFlexiFareAmount() {
        return perPaxFlexiFareAmount;
    }

    /** 
     * Set the 'PerPaxFlexiFareAmount' element value.
     * 
     * @param perPaxFlexiFareAmount
     */
    public void setPerPaxFlexiFareAmount(
            PerPaxFlexiFareAmount perPaxFlexiFareAmount) {
        this.perPaxFlexiFareAmount = perPaxFlexiFareAmount;
    }
    /** 
     * 
                          The amount the passenger would have to pay for this flexibile fare.
                      
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PerPaxFlexiFareAmount" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:string" name="ApplicablePaxType"/>
     *     &lt;xs:attributeGroup ref="ns:CurrencyAmountGroup"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class PerPaxFlexiFareAmount
    {
        private String applicablePaxType;
        private CurrencyAmountGroup currencyAmountGroup;

        /** 
         * Get the 'ApplicablePaxType' attribute value. 
                                    The type of passenger the flexible fare applies to.
                                
         * 
         * @return value
         */
        public String getApplicablePaxType() {
            return applicablePaxType;
        }

        /** 
         * Set the 'ApplicablePaxType' attribute value. 
                                    The type of passenger the flexible fare applies to.
                                
         * 
         * @param applicablePaxType
         */
        public void setApplicablePaxType(String applicablePaxType) {
            this.applicablePaxType = applicablePaxType;
        }

        /** 
         * Get the 'CurrencyAmountGroup' attributeGroup value.
         * 
         * @return value
         */
        public CurrencyAmountGroup getCurrencyAmountGroup() {
            return currencyAmountGroup;
        }

        /** 
         * Set the 'CurrencyAmountGroup' attributeGroup value.
         * 
         * @param currencyAmountGroup
         */
        public void setCurrencyAmountGroup(
                CurrencyAmountGroup currencyAmountGroup) {
            this.currencyAmountGroup = currencyAmountGroup;
        }
    }
}
