
package org.opentravel.ota;

import java.util.ArrayList;
import java.util.List;

/** 
 * Container for priced itineraries.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PricedItinerariesType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:PricedItineraryType" name="PricedItinerary" maxOccurs="unbounded"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PricedItinerariesType
{
    private List<PricedItineraryType> pricedItineraryList = new ArrayList<PricedItineraryType>();

    /** 
     * Get the list of 'PricedItinerary' element items. Itinerary with pricing information.
     * 
     * @return list
     */
    public List<PricedItineraryType> getPricedItineraryList() {
        return pricedItineraryList;
    }

    /** 
     * Set the list of 'PricedItinerary' element items. Itinerary with pricing information.
     * 
     * @param list
     */
    public void setPricedItineraryList(List<PricedItineraryType> list) {
        pricedItineraryList = list;
    }
}
