
package org.opentravel.ota;

import java.util.ArrayList;
import java.util.List;

/** 
 * Itinerary with pricing information.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PricedItineraryType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:AirItineraryType" name="AirItinerary" minOccurs="0"/>
 *     &lt;xs:element type="ns:AirItineraryPricingInfoType" name="AirItineraryPricingInfo" minOccurs="0"/>
 *     &lt;xs:element type="ns:FreeTextType" name="Notes" minOccurs="0" maxOccurs="5"/>
 *     &lt;xs:element type="ns:TicketingInfoRS_Type" name="TicketingInfo" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="required" name="SequenceNumber"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="OriginDestinationRPH"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PricedItineraryType
{
    private AirItineraryType airItinerary;
    private AirItineraryPricingInfoType airItineraryPricingInfo;
    private List<FreeTextType> noteList = new ArrayList<FreeTextType>();
    private TicketingInfoRSType ticketingInfo;
    private String sequenceNumber;
    private String originDestinationRPH;

    /** 
     * Get the 'AirItinerary' element value. 
                          Specifies the origin and destination of the traveler. Attributes: DirectionInd - A directional
                          indicator that identifies a type of air booking, either one-way, round-trip, or open-jaw with
                          the enumeration of (OneWay | RT | OpenJaw) respectively. ActionCode - Indicates the status of
                          the booking, such as OK or Wait-List. NumberInParty - Indicates the traveler count.
                      
     * 
     * @return value
     */
    public AirItineraryType getAirItinerary() {
        return airItinerary;
    }

    /** 
     * Set the 'AirItinerary' element value. 
                          Specifies the origin and destination of the traveler. Attributes: DirectionInd - A directional
                          indicator that identifies a type of air booking, either one-way, round-trip, or open-jaw with
                          the enumeration of (OneWay | RT | OpenJaw) respectively. ActionCode - Indicates the status of
                          the booking, such as OK or Wait-List. NumberInParty - Indicates the traveler count.
                      
     * 
     * @param airItinerary
     */
    public void setAirItinerary(AirItineraryType airItinerary) {
        this.airItinerary = airItinerary;
    }

    /** 
     * Get the 'AirItineraryPricingInfo' element value. Pricing Information for an Air Itinerary.
     * 
     * @return value
     */
    public AirItineraryPricingInfoType getAirItineraryPricingInfo() {
        return airItineraryPricingInfo;
    }

    /** 
     * Set the 'AirItineraryPricingInfo' element value. Pricing Information for an Air Itinerary.
     * 
     * @param airItineraryPricingInfo
     */
    public void setAirItineraryPricingInfo(
            AirItineraryPricingInfoType airItineraryPricingInfo) {
        this.airItineraryPricingInfo = airItineraryPricingInfo;
    }

    /** 
     * Get the list of 'Notes' element items. 
                          Provides for free form descriptive information for the priced itinerary.
                      
     * 
     * @return list
     */
    public List<FreeTextType> getNoteList() {
        return noteList;
    }

    /** 
     * Set the list of 'Notes' element items. 
                          Provides for free form descriptive information for the priced itinerary.
                      
     * 
     * @param list
     */
    public void setNoteList(List<FreeTextType> list) {
        noteList = list;
    }

    /** 
     * Get the 'TicketingInfo' element value. Container for TicketingInfoRS_Type.
     * 
     * @return value
     */
    public TicketingInfoRSType getTicketingInfo() {
        return ticketingInfo;
    }

    /** 
     * Set the 'TicketingInfo' element value. Container for TicketingInfoRS_Type.
     * 
     * @param ticketingInfo
     */
    public void setTicketingInfo(TicketingInfoRSType ticketingInfo) {
        this.ticketingInfo = ticketingInfo;
    }

    /** 
     * Get the 'SequenceNumber' attribute value. Assigns a number to priced itineraries.
     * 
     * @return value
     */
    public String getSequenceNumber() {
        return sequenceNumber;
    }

    /** 
     * Set the 'SequenceNumber' attribute value. Assigns a number to priced itineraries.
     * 
     * @param sequenceNumber
     */
    public void setSequenceNumber(String sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    /** 
     * Get the 'OriginDestinationRPH' attribute value. 
                      When a PricedItinerary element contains flights and pricing information for a single
                      OriginDestinationPair from the OTA_LowFareSearchRQ message, this RPH attribute identifies that
                      OriginDestinationPair from the RQ. When the PricedItinerary contains flights and pricing information
                      for all OriginDestinationPairs from the OTA_LowFareSearchRQ message, this attribute should not be
                      included.
                  
     * 
     * @return value
     */
    public String getOriginDestinationRPH() {
        return originDestinationRPH;
    }

    /** 
     * Set the 'OriginDestinationRPH' attribute value. 
                      When a PricedItinerary element contains flights and pricing information for a single
                      OriginDestinationPair from the OTA_LowFareSearchRQ message, this RPH attribute identifies that
                      OriginDestinationPair from the RQ. When the PricedItinerary contains flights and pricing information
                      for all OriginDestinationPairs from the OTA_LowFareSearchRQ message, this attribute should not be
                      included.
                  
     * 
     * @param originDestinationRPH
     */
    public void setOriginDestinationRPH(String originDestinationRPH) {
        this.originDestinationRPH = originDestinationRPH;
    }
}
