
package org.opentravel.ota;

/** 
 * 
 Attributes for ssr request. Note: you can choose a specific ssr or just a general preference

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:attributeGroup xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SSRRequestAttributes">
 *   &lt;xs:attribute type="xs:string" use="required" name="ssrCode"/>
 *   &lt;xs:attribute type="ns:SSRType" use="required" name="ServiceType"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="airportCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="airportType"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="Text"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class SSRRequestAttributes
{
    private String ssrCode;
    private SSRType serviceType;
    private String airportCode;
    private String airportType;
    private String text;

    /** 
     * Get the 'ssrCode' attribute value. Used to provide the ssr code.
     * 
     * @return value
     */
    public String getSsrCode() {
        return ssrCode;
    }

    /** 
     * Set the 'ssrCode' attribute value. Used to provide the ssr code.
     * 
     * @param ssrCode
     */
    public void setSsrCode(String ssrCode) {
        this.ssrCode = ssrCode;
    }

    /** 
     * Get the 'ServiceType' attribute value. Used to provide the requested SSR type.
     * 
     * @return value
     */
    public SSRType getServiceType() {
        return serviceType;
    }

    /** 
     * Set the 'ServiceType' attribute value. Used to provide the requested SSR type.
     * 
     * @param serviceType
     */
    public void setServiceType(SSRType serviceType) {
        this.serviceType = serviceType;
    }

    /** 
     * Get the 'airportCode' attribute value. Used to provide the requested airport code.
     * 
     * @return value
     */
    public String getAirportCode() {
        return airportCode;
    }

    /** 
     * Set the 'airportCode' attribute value. Used to provide the requested airport code.
     * 
     * @param airportCode
     */
    public void setAirportCode(String airportCode) {
        this.airportCode = airportCode;
    }

    /** 
     * Get the 'airportType' attribute value. Used to provide the ariport type.
     * 
     * @return value
     */
    public String getAirportType() {
        return airportType;
    }

    /** 
     * Set the 'airportType' attribute value. Used to provide the ariport type.
     * 
     * @param airportType
     */
    public void setAirportType(String airportType) {
        this.airportType = airportType;
    }

    /** 
     * Get the 'Text' attribute value. Text associated with remark
     * 
     * @return value
     */
    public String getText() {
        return text;
    }

    /** 
     * Set the 'Text' attribute value. Text associated with remark
     * 
     * @param text
     */
    public void setText(String text) {
        this.text = text;
    }
}
