
package org.opentravel.ota;

import java.util.Date;

/** 
 * Object to hold a passengers' ssr request
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SSRRequestType">
 *   &lt;xs:attributeGroup ref="ns:SSRRequestAttributes"/>
 *   &lt;xs:attribute type="xs:dateTime" use="optional" name="DepartureDate"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="FlightNumber"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class SSRRequestType
{
    private SSRRequestAttributes SSRRequestAttributes;
    private Date departureDate;
    private String flightNumber;

    /** 
     * Get the 'SSRRequestAttributes' attributeGroup value. Attributes for ssr request
     * 
     * @return value
     */
    public SSRRequestAttributes getSSRRequestAttributes() {
        return SSRRequestAttributes;
    }

    /** 
     * Set the 'SSRRequestAttributes' attributeGroup value. Attributes for ssr request
     * 
     * @param SSRRequestAttributes
     */
    public void setSSRRequestAttributes(
            SSRRequestAttributes SSRRequestAttributes) {
        this.SSRRequestAttributes = SSRRequestAttributes;
    }

    /** 
     * Get the 'DepartureDate' attribute value. 
                      The departure date of the flight for the ssr requested.
                  
     * 
     * @return value
     */
    public Date getDepartureDate() {
        return departureDate;
    }

    /** 
     * Set the 'DepartureDate' attribute value. 
                      The departure date of the flight for the ssr requested.
                  
     * 
     * @param departureDate
     */
    public void setDepartureDate(Date departureDate) {
        this.departureDate = departureDate;
    }

    /** 
     * Get the 'FlightNumber' attribute value. 
                      The number of the flight for which this ssr is requested.
                  
     * 
     * @return value
     */
    public String getFlightNumber() {
        return flightNumber;
    }

    /** 
     * Set the 'FlightNumber' attribute value. 
                      The number of the flight for which this ssr is requested.
                  
     * 
     * @param flightNumber
     */
    public void setFlightNumber(String flightNumber) {
        this.flightNumber = flightNumber;
    }
}
