
package org.opentravel.ota;

import java.util.ArrayList;
import java.util.List;

/** 
 * Remarks, OSIs, Seat Requests etc.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SpecialReqDetailsType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="SeatRequests" minOccurs="0">
 *       &lt;!-- Reference to inner class SeatRequests -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="SpecialServiceRequests" minOccurs="0">
 *       &lt;!-- Reference to inner class SpecialServiceRequests -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="MealRequests" minOccurs="0">
 *       &lt;!-- Reference to inner class MealRequests -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="AutomaticCheckinRequests" minOccurs="0">
 *       &lt;!-- Reference to inner class AutomaticCheckinRequests -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="SSRRequests" minOccurs="0">
 *       &lt;!-- Reference to inner class SSRRequests -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="BaggageRequests" minOccurs="0">
 *       &lt;!-- Reference to inner class BaggageRequests -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="InsuranceRequests" minOccurs="0" maxOccurs="1">
 *       &lt;!-- Reference to inner class InsuranceRequests -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="OtherServiceInformations" minOccurs="0">
 *       &lt;!-- Reference to inner class OtherServiceInformations -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="Remarks" minOccurs="0">
 *       &lt;!-- Reference to inner class Remarks -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="SpecialRemarks" minOccurs="0">
 *       &lt;!-- Reference to inner class SpecialRemarks -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class SpecialReqDetailsType
{
    private SeatRequests seatRequests;
    private SpecialServiceRequests specialServiceRequests;
    private MealRequests mealRequests;
    private AutomaticCheckinRequests automaticCheckinRequests;
    private SSRRequests SSRRequests1;
    private BaggageRequests baggageRequests;
    private InsuranceRequests insuranceRequests;
    private OtherServiceInformations otherServiceInformations;
    private Remarks remarks;
    private SpecialRemarks specialRemarks;

    /** 
     * Get the 'SeatRequests' element value.
     * 
     * @return value
     */
    public SeatRequests getSeatRequests() {
        return seatRequests;
    }

    /** 
     * Set the 'SeatRequests' element value.
     * 
     * @param seatRequests
     */
    public void setSeatRequests(SeatRequests seatRequests) {
        this.seatRequests = seatRequests;
    }

    /** 
     * Get the 'SpecialServiceRequests' element value.
     * 
     * @return value
     */
    public SpecialServiceRequests getSpecialServiceRequests() {
        return specialServiceRequests;
    }

    /** 
     * Set the 'SpecialServiceRequests' element value.
     * 
     * @param specialServiceRequests
     */
    public void setSpecialServiceRequests(
            SpecialServiceRequests specialServiceRequests) {
        this.specialServiceRequests = specialServiceRequests;
    }

    /** 
     * Get the 'MealRequests' element value.
     * 
     * @return value
     */
    public MealRequests getMealRequests() {
        return mealRequests;
    }

    /** 
     * Set the 'MealRequests' element value.
     * 
     * @param mealRequests
     */
    public void setMealRequests(MealRequests mealRequests) {
        this.mealRequests = mealRequests;
    }

    /** 
     * Get the 'AutomaticCheckinRequests' element value.
     * 
     * @return value
     */
    public AutomaticCheckinRequests getAutomaticCheckinRequests() {
        return automaticCheckinRequests;
    }

    /** 
     * Set the 'AutomaticCheckinRequests' element value.
     * 
     * @param automaticCheckinRequests
     */
    public void setAutomaticCheckinRequests(
            AutomaticCheckinRequests automaticCheckinRequests) {
        this.automaticCheckinRequests = automaticCheckinRequests;
    }

    /** 
     * Get the 'SSRRequests' element value.
     * 
     * @return value
     */
    public SSRRequests getSSRRequests1() {
        return SSRRequests1;
    }

    /** 
     * Set the 'SSRRequests' element value.
     * 
     * @param SSRRequests1
     */
    public void setSSRRequests1(SSRRequests SSRRequests1) {
        this.SSRRequests1 = SSRRequests1;
    }

    /** 
     * Get the 'BaggageRequests' element value.
     * 
     * @return value
     */
    public BaggageRequests getBaggageRequests() {
        return baggageRequests;
    }

    /** 
     * Set the 'BaggageRequests' element value.
     * 
     * @param baggageRequests
     */
    public void setBaggageRequests(BaggageRequests baggageRequests) {
        this.baggageRequests = baggageRequests;
    }

    /** 
     * Get the 'InsuranceRequests' element value.
     * 
     * @return value
     */
    public InsuranceRequests getInsuranceRequests() {
        return insuranceRequests;
    }

    /** 
     * Set the 'InsuranceRequests' element value.
     * 
     * @param insuranceRequests
     */
    public void setInsuranceRequests(InsuranceRequests insuranceRequests) {
        this.insuranceRequests = insuranceRequests;
    }

    /** 
     * Get the 'OtherServiceInformations' element value.
     * 
     * @return value
     */
    public OtherServiceInformations getOtherServiceInformations() {
        return otherServiceInformations;
    }

    /** 
     * Set the 'OtherServiceInformations' element value.
     * 
     * @param otherServiceInformations
     */
    public void setOtherServiceInformations(
            OtherServiceInformations otherServiceInformations) {
        this.otherServiceInformations = otherServiceInformations;
    }

    /** 
     * Get the 'Remarks' element value.
     * 
     * @return value
     */
    public Remarks getRemarks() {
        return remarks;
    }

    /** 
     * Set the 'Remarks' element value.
     * 
     * @param remarks
     */
    public void setRemarks(Remarks remarks) {
        this.remarks = remarks;
    }

    /** 
     * Get the 'SpecialRemarks' element value.
     * 
     * @return value
     */
    public SpecialRemarks getSpecialRemarks() {
        return specialRemarks;
    }

    /** 
     * Set the 'SpecialRemarks' element value.
     * 
     * @param specialRemarks
     */
    public void setSpecialRemarks(SpecialRemarks specialRemarks) {
        this.specialRemarks = specialRemarks;
    }
    /** 
     * A collection of Seat Request
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SeatRequests" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="SeatRequest" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class SeatRequest -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class SeatRequests
    {
        private List<SeatRequest> seatRequestList = new ArrayList<SeatRequest>();

        /** 
         * Get the list of 'SeatRequest' element items.
         * 
         * @return list
         */
        public List<SeatRequest> getSeatRequestList() {
            return seatRequestList;
        }

        /** 
         * Set the list of 'SeatRequest' element items.
         * 
         * @param list
         */
        public void setSeatRequestList(List<SeatRequest> list) {
            seatRequestList = list;
        }
        /** 
         * 
                                        Seating requests for each passenger for each air leg of this trip.
                                    
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SeatRequest" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:complexContent>
         *       &lt;xs:extension base="ns:SeatRequestType">
         *         &lt;xs:attribute type="ns:ListOfRPH" use="required" name="TravelerRefNumberRPHList"/>
         *         &lt;xs:attribute type="ns:ListOfRPH" use="required" name="FlightRefNumberRPHList"/>
         *       &lt;/xs:extension>
         *     &lt;/xs:complexContent>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * 
         * &lt;xs:simpleType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ListOfRPH">
         *   &lt;xs:list itemType="xs:string"/>
         * &lt;/xs:simpleType>
         * </pre>
         */
        public static class SeatRequest extends SeatRequestType
        {
            private List<String> travelerRefNumberRPHList = new ArrayList<String>();
            private List<String> flightRefNumberRPHList = new ArrayList<String>();

            /** 
             * Get the list of 'TravelerRefNumberRPHList' attribute items. One or more travelers to whom this
                                                          request applies
                                                      
             * 
             * @return list
             */
            public List<String> getTravelerRefNumberRPHList() {
                return travelerRefNumberRPHList;
            }

            /** 
             * Set the list of 'TravelerRefNumberRPHList' attribute items. One or more travelers to whom this
                                                          request applies
                                                      
             * 
             * @param list
             */
            public void setTravelerRefNumberRPHList(List<String> list) {
                travelerRefNumberRPHList = list;
            }

            /** 
             * Serializer for 'TravelerRefNumberRPHList' attribute list.
             * 
             * @param values
             * @return text
             */
            public static String serializeTravelerRefNumberRPHList(
                    List<String> values) {
                if (values == null) {
                    return null;
                } else {
                    java.lang.StringBuffer buff = new java.lang.StringBuffer();
                    for (java.util.Iterator<String> iter = values.iterator(); iter
                            .hasNext();) {
                        if (buff.length() > 0) {
                            buff.append(' ');
                        }
                        String value = iter.next();
                        buff.append(value);
                    }
                    return buff.toString();
                }
            }

            /** 
             * Deserializer for 'TravelerRefNumberRPHList' attribute list.
             * 
             * @param text
             * @return values
             * @throws org.jibx.runtime.JiBXException on conversion error
             */
            public static List<String> deserializeTravelerRefNumberRPHList(
                    String text) throws org.jibx.runtime.JiBXException {
                org.jibx.runtime.IListItemDeserializer ldser = new org.jibx.runtime.IListItemDeserializer() {
                    public java.lang.Object deserialize(String text)
                            throws org.jibx.runtime.JiBXException {
                        return text;
                    }
                };
                return (List<String>) org.jibx.runtime.Utility.deserializeList(
                        text, ldser);
            }

            /** 
             * Get the list of 'FlightRefNumberRPHList' attribute items. One or more flights to whom this request
                                                          applies
                                                      
             * 
             * @return list
             */
            public List<String> getFlightRefNumberRPHList() {
                return flightRefNumberRPHList;
            }

            /** 
             * Set the list of 'FlightRefNumberRPHList' attribute items. One or more flights to whom this request
                                                          applies
                                                      
             * 
             * @param list
             */
            public void setFlightRefNumberRPHList(List<String> list) {
                flightRefNumberRPHList = list;
            }

            /** 
             * Serializer for 'FlightRefNumberRPHList' attribute list.
             * 
             * @param values
             * @return text
             */
            public static String serializeFlightRefNumberRPHList(
                    List<String> values) {
                if (values == null) {
                    return null;
                } else {
                    java.lang.StringBuffer buff = new java.lang.StringBuffer();
                    for (java.util.Iterator<String> iter = values.iterator(); iter
                            .hasNext();) {
                        if (buff.length() > 0) {
                            buff.append(' ');
                        }
                        String value = iter.next();
                        buff.append(value);
                    }
                    return buff.toString();
                }
            }

            /** 
             * Deserializer for 'FlightRefNumberRPHList' attribute list.
             * 
             * @param text
             * @return values
             * @throws org.jibx.runtime.JiBXException on conversion error
             */
            public static List<String> deserializeFlightRefNumberRPHList(
                    String text) throws org.jibx.runtime.JiBXException {
                org.jibx.runtime.IListItemDeserializer ldser = new org.jibx.runtime.IListItemDeserializer() {
                    public java.lang.Object deserialize(String text)
                            throws org.jibx.runtime.JiBXException {
                        return text;
                    }
                };
                return (List<String>) org.jibx.runtime.Utility.deserializeList(
                        text, ldser);
            }
        }
    }
    /** 
     * A collection of Special Service Request
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SpecialServiceRequests" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="SpecialServiceRequest" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class SpecialServiceRequest -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class SpecialServiceRequests
    {
        private List<SpecialServiceRequest> specialServiceRequestList = new ArrayList<SpecialServiceRequest>();

        /** 
         * Get the list of 'SpecialServiceRequest' element items.
         * 
         * @return list
         */
        public List<SpecialServiceRequest> getSpecialServiceRequestList() {
            return specialServiceRequestList;
        }

        /** 
         * Set the list of 'SpecialServiceRequest' element items.
         * 
         * @param list
         */
        public void setSpecialServiceRequestList(
                List<SpecialServiceRequest> list) {
            specialServiceRequestList = list;
        }
        /** 
         * Special Service Requests (SSR) for this booking
                                    
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SpecialServiceRequest" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:complexContent>
         *       &lt;xs:extension base="ns:SpecialServiceRequestType">
         *         &lt;xs:attribute type="ns:ListOfRPH" use="optional" name="TravelerRefNumberRPHList"/>
         *         &lt;xs:attribute type="ns:ListOfRPH" use="optional" name="FlightRefNumberRPHList"/>
         *       &lt;/xs:extension>
         *     &lt;/xs:complexContent>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * 
         * &lt;xs:simpleType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ListOfRPH">
         *   &lt;xs:list itemType="xs:string"/>
         * &lt;/xs:simpleType>
         * </pre>
         */
        public static class SpecialServiceRequest
                extends
                    SpecialServiceRequestType
        {
            private List<String> travelerRefNumberRPHList = new ArrayList<String>();
            private List<String> flightRefNumberRPHList = new ArrayList<String>();

            /** 
             * Get the list of 'TravelerRefNumberRPHList' attribute items. One or more travelers to whom this
                                                          request applies
                                                      
             * 
             * @return list
             */
            public List<String> getTravelerRefNumberRPHList() {
                return travelerRefNumberRPHList;
            }

            /** 
             * Set the list of 'TravelerRefNumberRPHList' attribute items. One or more travelers to whom this
                                                          request applies
                                                      
             * 
             * @param list
             */
            public void setTravelerRefNumberRPHList(List<String> list) {
                travelerRefNumberRPHList = list;
            }

            /** 
             * Serializer for 'TravelerRefNumberRPHList' attribute list.
             * 
             * @param values
             * @return text
             */
            public static String serializeTravelerRefNumberRPHList(
                    List<String> values) {
                if (values == null) {
                    return null;
                } else {
                    java.lang.StringBuffer buff = new java.lang.StringBuffer();
                    for (java.util.Iterator<String> iter = values.iterator(); iter
                            .hasNext();) {
                        if (buff.length() > 0) {
                            buff.append(' ');
                        }
                        String value = iter.next();
                        buff.append(value);
                    }
                    return buff.toString();
                }
            }

            /** 
             * Deserializer for 'TravelerRefNumberRPHList' attribute list.
             * 
             * @param text
             * @return values
             * @throws org.jibx.runtime.JiBXException on conversion error
             */
            public static List<String> deserializeTravelerRefNumberRPHList(
                    String text) throws org.jibx.runtime.JiBXException {
                org.jibx.runtime.IListItemDeserializer ldser = new org.jibx.runtime.IListItemDeserializer() {
                    public java.lang.Object deserialize(String text)
                            throws org.jibx.runtime.JiBXException {
                        return text;
                    }
                };
                return (List<String>) org.jibx.runtime.Utility.deserializeList(
                        text, ldser);
            }

            /** 
             * Get the list of 'FlightRefNumberRPHList' attribute items. One or more flights to whom this request
                                                          applies
                                                      
             * 
             * @return list
             */
            public List<String> getFlightRefNumberRPHList() {
                return flightRefNumberRPHList;
            }

            /** 
             * Set the list of 'FlightRefNumberRPHList' attribute items. One or more flights to whom this request
                                                          applies
                                                      
             * 
             * @param list
             */
            public void setFlightRefNumberRPHList(List<String> list) {
                flightRefNumberRPHList = list;
            }

            /** 
             * Serializer for 'FlightRefNumberRPHList' attribute list.
             * 
             * @param values
             * @return text
             */
            public static String serializeFlightRefNumberRPHList(
                    List<String> values) {
                if (values == null) {
                    return null;
                } else {
                    java.lang.StringBuffer buff = new java.lang.StringBuffer();
                    for (java.util.Iterator<String> iter = values.iterator(); iter
                            .hasNext();) {
                        if (buff.length() > 0) {
                            buff.append(' ');
                        }
                        String value = iter.next();
                        buff.append(value);
                    }
                    return buff.toString();
                }
            }

            /** 
             * Deserializer for 'FlightRefNumberRPHList' attribute list.
             * 
             * @param text
             * @return values
             * @throws org.jibx.runtime.JiBXException on conversion error
             */
            public static List<String> deserializeFlightRefNumberRPHList(
                    String text) throws org.jibx.runtime.JiBXException {
                org.jibx.runtime.IListItemDeserializer ldser = new org.jibx.runtime.IListItemDeserializer() {
                    public java.lang.Object deserialize(String text)
                            throws org.jibx.runtime.JiBXException {
                        return text;
                    }
                };
                return (List<String>) org.jibx.runtime.Utility.deserializeList(
                        text, ldser);
            }
        }
    }
    /** 
     * A collection of Meal Request
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MealRequests" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="MealRequest" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class MealRequest -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class MealRequests
    {
        private List<MealRequest> mealRequestList = new ArrayList<MealRequest>();

        /** 
         * Get the list of 'MealRequest' element items.
         * 
         * @return list
         */
        public List<MealRequest> getMealRequestList() {
            return mealRequestList;
        }

        /** 
         * Set the list of 'MealRequest' element items.
         * 
         * @param list
         */
        public void setMealRequestList(List<MealRequest> list) {
            mealRequestList = list;
        }
        /** 
         * 
                                        Meal requests for each passenger for each air leg of this trip.
                                    
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MealRequest" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:complexContent>
         *       &lt;xs:extension base="ns:MealRequestType">
         *         &lt;xs:attribute type="ns:ListOfRPH" use="required" name="TravelerRefNumberRPHList"/>
         *         &lt;xs:attribute type="ns:ListOfRPH" use="required" name="FlightRefNumberRPHList"/>
         *       &lt;/xs:extension>
         *     &lt;/xs:complexContent>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * 
         * &lt;xs:simpleType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ListOfRPH">
         *   &lt;xs:list itemType="xs:string"/>
         * &lt;/xs:simpleType>
         * </pre>
         */
        public static class MealRequest extends MealRequestType
        {
            private List<String> travelerRefNumberRPHList = new ArrayList<String>();
            private List<String> flightRefNumberRPHList = new ArrayList<String>();

            /** 
             * Get the list of 'TravelerRefNumberRPHList' attribute items. One or more travelers to whom this
                                                          request applies
                                                      
             * 
             * @return list
             */
            public List<String> getTravelerRefNumberRPHList() {
                return travelerRefNumberRPHList;
            }

            /** 
             * Set the list of 'TravelerRefNumberRPHList' attribute items. One or more travelers to whom this
                                                          request applies
                                                      
             * 
             * @param list
             */
            public void setTravelerRefNumberRPHList(List<String> list) {
                travelerRefNumberRPHList = list;
            }

            /** 
             * Serializer for 'TravelerRefNumberRPHList' attribute list.
             * 
             * @param values
             * @return text
             */
            public static String serializeTravelerRefNumberRPHList(
                    List<String> values) {
                if (values == null) {
                    return null;
                } else {
                    java.lang.StringBuffer buff = new java.lang.StringBuffer();
                    for (java.util.Iterator<String> iter = values.iterator(); iter
                            .hasNext();) {
                        if (buff.length() > 0) {
                            buff.append(' ');
                        }
                        String value = iter.next();
                        buff.append(value);
                    }
                    return buff.toString();
                }
            }

            /** 
             * Deserializer for 'TravelerRefNumberRPHList' attribute list.
             * 
             * @param text
             * @return values
             * @throws org.jibx.runtime.JiBXException on conversion error
             */
            public static List<String> deserializeTravelerRefNumberRPHList(
                    String text) throws org.jibx.runtime.JiBXException {
                org.jibx.runtime.IListItemDeserializer ldser = new org.jibx.runtime.IListItemDeserializer() {
                    public java.lang.Object deserialize(String text)
                            throws org.jibx.runtime.JiBXException {
                        return text;
                    }
                };
                return (List<String>) org.jibx.runtime.Utility.deserializeList(
                        text, ldser);
            }

            /** 
             * Get the list of 'FlightRefNumberRPHList' attribute items. One or more flights to whom this request
                                                          applies
                                                      
             * 
             * @return list
             */
            public List<String> getFlightRefNumberRPHList() {
                return flightRefNumberRPHList;
            }

            /** 
             * Set the list of 'FlightRefNumberRPHList' attribute items. One or more flights to whom this request
                                                          applies
                                                      
             * 
             * @param list
             */
            public void setFlightRefNumberRPHList(List<String> list) {
                flightRefNumberRPHList = list;
            }

            /** 
             * Serializer for 'FlightRefNumberRPHList' attribute list.
             * 
             * @param values
             * @return text
             */
            public static String serializeFlightRefNumberRPHList(
                    List<String> values) {
                if (values == null) {
                    return null;
                } else {
                    java.lang.StringBuffer buff = new java.lang.StringBuffer();
                    for (java.util.Iterator<String> iter = values.iterator(); iter
                            .hasNext();) {
                        if (buff.length() > 0) {
                            buff.append(' ');
                        }
                        String value = iter.next();
                        buff.append(value);
                    }
                    return buff.toString();
                }
            }

            /** 
             * Deserializer for 'FlightRefNumberRPHList' attribute list.
             * 
             * @param text
             * @return values
             * @throws org.jibx.runtime.JiBXException on conversion error
             */
            public static List<String> deserializeFlightRefNumberRPHList(
                    String text) throws org.jibx.runtime.JiBXException {
                org.jibx.runtime.IListItemDeserializer ldser = new org.jibx.runtime.IListItemDeserializer() {
                    public java.lang.Object deserialize(String text)
                            throws org.jibx.runtime.JiBXException {
                        return text;
                    }
                };
                return (List<String>) org.jibx.runtime.Utility.deserializeList(
                        text, ldser);
            }
        }
    }
    /** 
     * A collection of Auto Checkin Request
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AutomaticCheckinRequests" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="AutomaticCheckinRequest" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class AutomaticCheckinRequest -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class AutomaticCheckinRequests
    {
        private List<AutomaticCheckinRequest> automaticCheckinRequestList = new ArrayList<AutomaticCheckinRequest>();

        /** 
         * Get the list of 'AutomaticCheckinRequest' element items.
         * 
         * @return list
         */
        public List<AutomaticCheckinRequest> getAutomaticCheckinRequestList() {
            return automaticCheckinRequestList;
        }

        /** 
         * Set the list of 'AutomaticCheckinRequest' element items.
         * 
         * @param list
         */
        public void setAutomaticCheckinRequestList(
                List<AutomaticCheckinRequest> list) {
            automaticCheckinRequestList = list;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AutomaticCheckinRequest" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="ns:ListOfRPH" use="required" name="TravelerRefNumberRPHList"/>
         *     &lt;xs:attribute type="ns:ListOfRPH" use="required" name="FlightRefNumberRPHList"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * 
         * &lt;xs:simpleType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ListOfRPH">
         *   &lt;xs:list itemType="xs:string"/>
         * &lt;/xs:simpleType>
         * </pre>
         */
        public static class AutomaticCheckinRequest
        {
            private List<String> travelerRefNumberRPHList = new ArrayList<String>();
            private List<String> flightRefNumberRPHList = new ArrayList<String>();

            /** 
             * Get the list of 'TravelerRefNumberRPHList' attribute items.
             * 
             * @return list
             */
            public List<String> getTravelerRefNumberRPHList() {
                return travelerRefNumberRPHList;
            }

            /** 
             * Set the list of 'TravelerRefNumberRPHList' attribute items.
             * 
             * @param list
             */
            public void setTravelerRefNumberRPHList(List<String> list) {
                travelerRefNumberRPHList = list;
            }

            /** 
             * Serializer for 'TravelerRefNumberRPHList' attribute list.
             * 
             * @param values
             * @return text
             */
            public static String serializeTravelerRefNumberRPHList(
                    List<String> values) {
                if (values == null) {
                    return null;
                } else {
                    java.lang.StringBuffer buff = new java.lang.StringBuffer();
                    for (java.util.Iterator<String> iter = values.iterator(); iter
                            .hasNext();) {
                        if (buff.length() > 0) {
                            buff.append(' ');
                        }
                        String value = iter.next();
                        buff.append(value);
                    }
                    return buff.toString();
                }
            }

            /** 
             * Deserializer for 'TravelerRefNumberRPHList' attribute list.
             * 
             * @param text
             * @return values
             * @throws org.jibx.runtime.JiBXException on conversion error
             */
            public static List<String> deserializeTravelerRefNumberRPHList(
                    String text) throws org.jibx.runtime.JiBXException {
                org.jibx.runtime.IListItemDeserializer ldser = new org.jibx.runtime.IListItemDeserializer() {
                    public java.lang.Object deserialize(String text)
                            throws org.jibx.runtime.JiBXException {
                        return text;
                    }
                };
                return (List<String>) org.jibx.runtime.Utility.deserializeList(
                        text, ldser);
            }

            /** 
             * Get the list of 'FlightRefNumberRPHList' attribute items.
             * 
             * @return list
             */
            public List<String> getFlightRefNumberRPHList() {
                return flightRefNumberRPHList;
            }

            /** 
             * Set the list of 'FlightRefNumberRPHList' attribute items.
             * 
             * @param list
             */
            public void setFlightRefNumberRPHList(List<String> list) {
                flightRefNumberRPHList = list;
            }

            /** 
             * Serializer for 'FlightRefNumberRPHList' attribute list.
             * 
             * @param values
             * @return text
             */
            public static String serializeFlightRefNumberRPHList(
                    List<String> values) {
                if (values == null) {
                    return null;
                } else {
                    java.lang.StringBuffer buff = new java.lang.StringBuffer();
                    for (java.util.Iterator<String> iter = values.iterator(); iter
                            .hasNext();) {
                        if (buff.length() > 0) {
                            buff.append(' ');
                        }
                        String value = iter.next();
                        buff.append(value);
                    }
                    return buff.toString();
                }
            }

            /** 
             * Deserializer for 'FlightRefNumberRPHList' attribute list.
             * 
             * @param text
             * @return values
             * @throws org.jibx.runtime.JiBXException on conversion error
             */
            public static List<String> deserializeFlightRefNumberRPHList(
                    String text) throws org.jibx.runtime.JiBXException {
                org.jibx.runtime.IListItemDeserializer ldser = new org.jibx.runtime.IListItemDeserializer() {
                    public java.lang.Object deserialize(String text)
                            throws org.jibx.runtime.JiBXException {
                        return text;
                    }
                };
                return (List<String>) org.jibx.runtime.Utility.deserializeList(
                        text, ldser);
            }
        }
    }
    /** 
     * A collection of SSR Request
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SSRRequests" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="SSRRequest" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class SSRRequest -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class SSRRequests
    {
        private List<SSRRequest> SSRRequestList = new ArrayList<SSRRequest>();

        /** 
         * Get the list of 'SSRRequest' element items.
         * 
         * @return list
         */
        public List<SSRRequest> getSSRRequestList() {
            return SSRRequestList;
        }

        /** 
         * Set the list of 'SSRRequest' element items.
         * 
         * @param list
         */
        public void setSSRRequestList(List<SSRRequest> list) {
            SSRRequestList = list;
        }
        /** 
         * 
                                        SSR requests for each passenger for each air leg of this trip.
                                    
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SSRRequest" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:complexContent>
         *       &lt;xs:extension base="ns:SSRRequestType">
         *         &lt;xs:attribute type="ns:ListOfRPH" use="required" name="TravelerRefNumberRPHList"/>
         *         &lt;xs:attribute type="ns:ListOfRPH" use="required" name="FlightRefNumberRPHList"/>
         *       &lt;/xs:extension>
         *     &lt;/xs:complexContent>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * 
         * &lt;xs:simpleType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ListOfRPH">
         *   &lt;xs:list itemType="xs:string"/>
         * &lt;/xs:simpleType>
         * </pre>
         */
        public static class SSRRequest extends SSRRequestType
        {
            private List<String> travelerRefNumberRPHList = new ArrayList<String>();
            private List<String> flightRefNumberRPHList = new ArrayList<String>();

            /** 
             * Get the list of 'TravelerRefNumberRPHList' attribute items. One or more travelers to whom this
                                                          request applies
                                                      
             * 
             * @return list
             */
            public List<String> getTravelerRefNumberRPHList() {
                return travelerRefNumberRPHList;
            }

            /** 
             * Set the list of 'TravelerRefNumberRPHList' attribute items. One or more travelers to whom this
                                                          request applies
                                                      
             * 
             * @param list
             */
            public void setTravelerRefNumberRPHList(List<String> list) {
                travelerRefNumberRPHList = list;
            }

            /** 
             * Serializer for 'TravelerRefNumberRPHList' attribute list.
             * 
             * @param values
             * @return text
             */
            public static String serializeTravelerRefNumberRPHList(
                    List<String> values) {
                if (values == null) {
                    return null;
                } else {
                    java.lang.StringBuffer buff = new java.lang.StringBuffer();
                    for (java.util.Iterator<String> iter = values.iterator(); iter
                            .hasNext();) {
                        if (buff.length() > 0) {
                            buff.append(' ');
                        }
                        String value = iter.next();
                        buff.append(value);
                    }
                    return buff.toString();
                }
            }

            /** 
             * Deserializer for 'TravelerRefNumberRPHList' attribute list.
             * 
             * @param text
             * @return values
             * @throws org.jibx.runtime.JiBXException on conversion error
             */
            public static List<String> deserializeTravelerRefNumberRPHList(
                    String text) throws org.jibx.runtime.JiBXException {
                org.jibx.runtime.IListItemDeserializer ldser = new org.jibx.runtime.IListItemDeserializer() {
                    public java.lang.Object deserialize(String text)
                            throws org.jibx.runtime.JiBXException {
                        return text;
                    }
                };
                return (List<String>) org.jibx.runtime.Utility.deserializeList(
                        text, ldser);
            }

            /** 
             * Get the list of 'FlightRefNumberRPHList' attribute items. One or more flights to whom this request
                                                          applies
                                                      
             * 
             * @return list
             */
            public List<String> getFlightRefNumberRPHList() {
                return flightRefNumberRPHList;
            }

            /** 
             * Set the list of 'FlightRefNumberRPHList' attribute items. One or more flights to whom this request
                                                          applies
                                                      
             * 
             * @param list
             */
            public void setFlightRefNumberRPHList(List<String> list) {
                flightRefNumberRPHList = list;
            }

            /** 
             * Serializer for 'FlightRefNumberRPHList' attribute list.
             * 
             * @param values
             * @return text
             */
            public static String serializeFlightRefNumberRPHList(
                    List<String> values) {
                if (values == null) {
                    return null;
                } else {
                    java.lang.StringBuffer buff = new java.lang.StringBuffer();
                    for (java.util.Iterator<String> iter = values.iterator(); iter
                            .hasNext();) {
                        if (buff.length() > 0) {
                            buff.append(' ');
                        }
                        String value = iter.next();
                        buff.append(value);
                    }
                    return buff.toString();
                }
            }

            /** 
             * Deserializer for 'FlightRefNumberRPHList' attribute list.
             * 
             * @param text
             * @return values
             * @throws org.jibx.runtime.JiBXException on conversion error
             */
            public static List<String> deserializeFlightRefNumberRPHList(
                    String text) throws org.jibx.runtime.JiBXException {
                org.jibx.runtime.IListItemDeserializer ldser = new org.jibx.runtime.IListItemDeserializer() {
                    public java.lang.Object deserialize(String text)
                            throws org.jibx.runtime.JiBXException {
                        return text;
                    }
                };
                return (List<String>) org.jibx.runtime.Utility.deserializeList(
                        text, ldser);
            }
        }
    }
    /** 
     * A collection of Meal Request
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BaggageRequests" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="BaggageRequest" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class BaggageRequest -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class BaggageRequests
    {
        private List<BaggageRequest> baggageRequestList = new ArrayList<BaggageRequest>();

        /** 
         * Get the list of 'BaggageRequest' element items.
         * 
         * @return list
         */
        public List<BaggageRequest> getBaggageRequestList() {
            return baggageRequestList;
        }

        /** 
         * Set the list of 'BaggageRequest' element items.
         * 
         * @param list
         */
        public void setBaggageRequestList(List<BaggageRequest> list) {
            baggageRequestList = list;
        }
        /** 
         * 
                                        Baggage requests for each passenger for each air leg of this trip.
                                    
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BaggageRequest" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:complexContent>
         *       &lt;xs:extension base="ns:BaggageRequestType">
         *         &lt;xs:attribute type="ns:ListOfRPH" use="required" name="TravelerRefNumberRPHList"/>
         *         &lt;xs:attribute type="ns:ListOfRPH" use="required" name="FlightRefNumberRPHList"/>
         *       &lt;/xs:extension>
         *     &lt;/xs:complexContent>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * 
         * &lt;xs:simpleType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ListOfRPH">
         *   &lt;xs:list itemType="xs:string"/>
         * &lt;/xs:simpleType>
         * </pre>
         */
        public static class BaggageRequest extends BaggageRequestType
        {
            private List<String> travelerRefNumberRPHList = new ArrayList<String>();
            private List<String> flightRefNumberRPHList = new ArrayList<String>();

            /** 
             * Get the list of 'TravelerRefNumberRPHList' attribute items. One or more travelers to whom this
                                                          request applies
                                                      
             * 
             * @return list
             */
            public List<String> getTravelerRefNumberRPHList() {
                return travelerRefNumberRPHList;
            }

            /** 
             * Set the list of 'TravelerRefNumberRPHList' attribute items. One or more travelers to whom this
                                                          request applies
                                                      
             * 
             * @param list
             */
            public void setTravelerRefNumberRPHList(List<String> list) {
                travelerRefNumberRPHList = list;
            }

            /** 
             * Serializer for 'TravelerRefNumberRPHList' attribute list.
             * 
             * @param values
             * @return text
             */
            public static String serializeTravelerRefNumberRPHList(
                    List<String> values) {
                if (values == null) {
                    return null;
                } else {
                    java.lang.StringBuffer buff = new java.lang.StringBuffer();
                    for (java.util.Iterator<String> iter = values.iterator(); iter
                            .hasNext();) {
                        if (buff.length() > 0) {
                            buff.append(' ');
                        }
                        String value = iter.next();
                        buff.append(value);
                    }
                    return buff.toString();
                }
            }

            /** 
             * Deserializer for 'TravelerRefNumberRPHList' attribute list.
             * 
             * @param text
             * @return values
             * @throws org.jibx.runtime.JiBXException on conversion error
             */
            public static List<String> deserializeTravelerRefNumberRPHList(
                    String text) throws org.jibx.runtime.JiBXException {
                org.jibx.runtime.IListItemDeserializer ldser = new org.jibx.runtime.IListItemDeserializer() {
                    public java.lang.Object deserialize(String text)
                            throws org.jibx.runtime.JiBXException {
                        return text;
                    }
                };
                return (List<String>) org.jibx.runtime.Utility.deserializeList(
                        text, ldser);
            }

            /** 
             * Get the list of 'FlightRefNumberRPHList' attribute items. One or more flights to whom this request
                                                          applies
                                                      
             * 
             * @return list
             */
            public List<String> getFlightRefNumberRPHList() {
                return flightRefNumberRPHList;
            }

            /** 
             * Set the list of 'FlightRefNumberRPHList' attribute items. One or more flights to whom this request
                                                          applies
                                                      
             * 
             * @param list
             */
            public void setFlightRefNumberRPHList(List<String> list) {
                flightRefNumberRPHList = list;
            }

            /** 
             * Serializer for 'FlightRefNumberRPHList' attribute list.
             * 
             * @param values
             * @return text
             */
            public static String serializeFlightRefNumberRPHList(
                    List<String> values) {
                if (values == null) {
                    return null;
                } else {
                    java.lang.StringBuffer buff = new java.lang.StringBuffer();
                    for (java.util.Iterator<String> iter = values.iterator(); iter
                            .hasNext();) {
                        if (buff.length() > 0) {
                            buff.append(' ');
                        }
                        String value = iter.next();
                        buff.append(value);
                    }
                    return buff.toString();
                }
            }

            /** 
             * Deserializer for 'FlightRefNumberRPHList' attribute list.
             * 
             * @param text
             * @return values
             * @throws org.jibx.runtime.JiBXException on conversion error
             */
            public static List<String> deserializeFlightRefNumberRPHList(
                    String text) throws org.jibx.runtime.JiBXException {
                org.jibx.runtime.IListItemDeserializer ldser = new org.jibx.runtime.IListItemDeserializer() {
                    public java.lang.Object deserialize(String text)
                            throws org.jibx.runtime.JiBXException {
                        return text;
                    }
                };
                return (List<String>) org.jibx.runtime.Utility.deserializeList(
                        text, ldser);
            }
        }
    }
    /** 
     * A collection of Insurance Requests
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="InsuranceRequests" minOccurs="0" maxOccurs="1">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="InsuranceRequest" maxOccurs="1">
     *         &lt;xs:complexType>
     *           &lt;xs:complexContent>
     *             &lt;xs:extension base="ns:InsuranceRequestType">
     *               &lt;xs:attribute type="xs:string" use="required" name="RPH"/>
     *             &lt;/xs:extension>
     *           &lt;/xs:complexContent>
     *         &lt;/xs:complexType>
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class InsuranceRequests
    {
        private InsuranceRequestType insuranceRequestInsuranceRequestType;
        private String insuranceRequestRPH;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public InsuranceRequestType getInsuranceRequestInsuranceRequestType() {
            return insuranceRequestInsuranceRequestType;
        }

        /** 
         * Set the extension value.
         * 
         * @param insuranceRequestInsuranceRequestType
         */
        public void setInsuranceRequestInsuranceRequestType(
                InsuranceRequestType insuranceRequestInsuranceRequestType) {
            this.insuranceRequestInsuranceRequestType = insuranceRequestInsuranceRequestType;
        }

        /** 
         * Get the 'RPH' attribute value. Insurance Reference No
                                                    
         * 
         * @return value
         */
        public String getInsuranceRequestRPH() {
            return insuranceRequestRPH;
        }

        /** 
         * Set the 'RPH' attribute value. Insurance Reference No
                                                    
         * 
         * @param insuranceRequestRPH
         */
        public void setInsuranceRequestRPH(String insuranceRequestRPH) {
            this.insuranceRequestRPH = insuranceRequestRPH;
        }
    }
    /** 
     * A collection of Other Service Information
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OtherServiceInformations" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="OtherServiceInformation" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class OtherServiceInformation -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class OtherServiceInformations
    {
        private List<OtherServiceInformation> otherServiceInformationList = new ArrayList<OtherServiceInformation>();

        /** 
         * Get the list of 'OtherServiceInformation' element items.
         * 
         * @return list
         */
        public List<OtherServiceInformation> getOtherServiceInformationList() {
            return otherServiceInformationList;
        }

        /** 
         * Set the list of 'OtherServiceInformation' element items.
         * 
         * @param list
         */
        public void setOtherServiceInformationList(
                List<OtherServiceInformation> list) {
            otherServiceInformationList = list;
        }
        /** 
         * 
                                        Other Service Information (OSI) for relevant airlines
                                    
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OtherServiceInformation" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:complexContent>
         *       &lt;xs:extension base="ns:OtherServiceInfoType">
         *         &lt;xs:attribute type="xs:string" use="optional" name="RPH"/>
         *         &lt;xs:attribute type="ns:ActionType" use="optional" name="Operation"/>
         *       &lt;/xs:extension>
         *     &lt;/xs:complexContent>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class OtherServiceInformation
                extends
                    OtherServiceInfoType
        {
            private String RPH;
            private ActionType operation;

            /** 
             * Get the 'RPH' attribute value. Unique value associated with the OSI.
                                                      
             * 
             * @return value
             */
            public String getRPH() {
                return RPH;
            }

            /** 
             * Set the 'RPH' attribute value. Unique value associated with the OSI.
                                                      
             * 
             * @param RPH
             */
            public void setRPH(String RPH) {
                this.RPH = RPH;
            }

            /** 
             * Get the 'Operation' attribute value. 
                                                          Indicates the required modification to the element.
                                                      
             * 
             * @return value
             */
            public ActionType getOperation() {
                return operation;
            }

            /** 
             * Set the 'Operation' attribute value. 
                                                          Indicates the required modification to the element.
                                                      
             * 
             * @param operation
             */
            public void setOperation(ActionType operation) {
                this.operation = operation;
            }
        }
    }
    /** 
     * A collection of Remark
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Remarks" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="Remark" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class Remark -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Remarks
    {
        private List<Remark> remarkList = new ArrayList<Remark>();

        /** 
         * Get the list of 'Remark' element items.
         * 
         * @return list
         */
        public List<Remark> getRemarkList() {
            return remarkList;
        }

        /** 
         * Set the list of 'Remark' element items.
         * 
         * @param list
         */
        public void setRemarkList(List<Remark> list) {
            remarkList = list;
        }
        /** 
         * Supplementary information for this booking
                                    
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Remark" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:simpleContent>
         *       &lt;xs:extension base="xs:string">
         *         &lt;xs:attribute type="xs:string" use="optional" name="RPH"/>
         *         &lt;xs:attribute type="ns:ActionType" use="optional" name="Operation"/>
         *       &lt;/xs:extension>
         *     &lt;/xs:simpleContent>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Remark
        {
            private String string;
            private String RPH;
            private ActionType operation;

            /** 
             * Get the extension value.
             * 
             * @return value
             */
            public String getString() {
                return string;
            }

            /** 
             * Set the extension value.
             * 
             * @param string
             */
            public void setString(String string) {
                this.string = string;
            }

            /** 
             * Get the 'RPH' attribute value. Unique value associated with the
                                                          Remark.
                                                      
             * 
             * @return value
             */
            public String getRPH() {
                return RPH;
            }

            /** 
             * Set the 'RPH' attribute value. Unique value associated with the
                                                          Remark.
                                                      
             * 
             * @param RPH
             */
            public void setRPH(String RPH) {
                this.RPH = RPH;
            }

            /** 
             * Get the 'Operation' attribute value. 
                                                          Indicates the required modification to the element.
                                                      
             * 
             * @return value
             */
            public ActionType getOperation() {
                return operation;
            }

            /** 
             * Set the 'Operation' attribute value. 
                                                          Indicates the required modification to the element.
                                                      
             * 
             * @param operation
             */
            public void setOperation(ActionType operation) {
                this.operation = operation;
            }
        }
    }
    /** 
     * A collection of Special Remark
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SpecialRemarks" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="SpecialRemark" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class SpecialRemark -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class SpecialRemarks
    {
        private List<SpecialRemark> specialRemarkList = new ArrayList<SpecialRemark>();

        /** 
         * Get the list of 'SpecialRemark' element items.
         * 
         * @return list
         */
        public List<SpecialRemark> getSpecialRemarkList() {
            return specialRemarkList;
        }

        /** 
         * Set the list of 'SpecialRemark' element items.
         * 
         * @param list
         */
        public void setSpecialRemarkList(List<SpecialRemark> list) {
            specialRemarkList = list;
        }
        /** 
         * Itinerary Remarks, Invoice Remarks, etc.
                                    
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SpecialRemark" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:complexContent>
         *       &lt;xs:extension base="ns:SpecialRemarkType">
         *         &lt;xs:attribute type="ns:ActionType" use="optional" name="Operation"/>
         *         &lt;xs:attribute type="xs:string" use="optional" name="RPH"/>
         *       &lt;/xs:extension>
         *     &lt;/xs:complexContent>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class SpecialRemark extends SpecialRemarkType
        {
            private ActionType operation;
            private String RPH;

            /** 
             * Get the 'Operation' attribute value. 
                                                          Indicates the required modification to the element.
                                                      
             * 
             * @return value
             */
            public ActionType getOperation() {
                return operation;
            }

            /** 
             * Set the 'Operation' attribute value. 
                                                          Indicates the required modification to the element.
                                                      
             * 
             * @param operation
             */
            public void setOperation(ActionType operation) {
                this.operation = operation;
            }

            /** 
             * Get the 'RPH' attribute value. Unique value associated with the Special
                                                          Remark.
                                                      
             * 
             * @return value
             */
            public String getRPH() {
                return RPH;
            }

            /** 
             * Set the 'RPH' attribute value. Unique value associated with the Special
                                                          Remark.
                                                      
             * 
             * @param RPH
             */
            public void setRPH(String RPH) {
                this.RPH = RPH;
            }
        }
    }
}
