
package org.opentravel.ota;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TaxInvoice">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:int" name="taxInvoiceId" minOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="invoiceType" minOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="dateOfIssue" minOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="taxRegistrationNumber" minOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="stateCode" minOccurs="1"/>
 *     &lt;xs:element type="xs:int" name="taxRate1Id" minOccurs="1"/>
 *     &lt;xs:element type="xs:decimal" name="taxRate1Amount" minOccurs="1"/>
 *     &lt;xs:element type="xs:int" name="taxRate2Id" minOccurs="1"/>
 *     &lt;xs:element type="xs:decimal" name="taxRate2Amount" minOccurs="1"/>
 *     &lt;xs:element type="xs:int" name="taxRate3Id" minOccurs="1"/>
 *     &lt;xs:element type="xs:decimal" name="taxRate3Amount" minOccurs="1"/>
 *     &lt;xs:element type="xs:int" name="taxRate4Id" minOccurs="1"/>
 *     &lt;xs:element type="xs:decimal" name="taxRate4Amount" minOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="originalPnr" minOccurs="1"/>
 *     &lt;xs:element type="xs:int" name="originalTaxInvoiceId" minOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="currencyCode" minOccurs="1"/>
 *     &lt;xs:element type="xs:decimal" name="taxRate1Percentage" minOccurs="1"/>
 *     &lt;xs:element type="xs:decimal" name="taxRate2Percentage" minOccurs="1"/>
 *     &lt;xs:element type="xs:decimal" name="taxRate3Percentage" minOccurs="1"/>
 *     &lt;xs:element type="xs:decimal" name="taxRate4Percentage" minOccurs="1"/>
 *     &lt;xs:element type="xs:decimal" name="totalTaxAmount" minOccurs="1"/>
 *     &lt;xs:element type="xs:decimal" name="totalTaxAndCessAmount" minOccurs="1"/>
 *     &lt;xs:element type="xs:decimal" name="totalValueOfService" minOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="dateOfIssueOriginalTaxInvoice" minOccurs="1"/>
 *     &lt;xs:element type="ns:TaxInvoiceAirlineDetails" name="TaxInvoiceAirlineDetails" minOccurs="1" maxOccurs="99"/>
 *     &lt;xs:element type="ns:TaxInvoiceRecipientDetails" name="TaxInvoiceRecipientDetails" minOccurs="1" maxOccurs="99"/>
 *     &lt;xs:element type="ns:TaxInvoiceOtherDetails" name="TaxInvoiceOtherDetails" minOccurs="1" maxOccurs="99"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class TaxInvoice
{
    private int taxInvoiceId;
    private String invoiceType;
    private String dateOfIssue;
    private String taxRegistrationNumber;
    private String stateCode;
    private int taxRate1Id;
    private BigDecimal taxRate1Amount;
    private int taxRate2Id;
    private BigDecimal taxRate2Amount;
    private int taxRate3Id;
    private BigDecimal taxRate3Amount;
    private int taxRate4Id;
    private BigDecimal taxRate4Amount;
    private String originalPnr;
    private int originalTaxInvoiceId;
    private String currencyCode;
    private BigDecimal taxRate1Percentage;
    private BigDecimal taxRate2Percentage;
    private BigDecimal taxRate3Percentage;
    private BigDecimal taxRate4Percentage;
    private BigDecimal totalTaxAmount;
    private BigDecimal totalTaxAndCessAmount;
    private BigDecimal totalValueOfService;
    private String dateOfIssueOriginalTaxInvoice;
    private List<TaxInvoiceAirlineDetails> taxInvoiceAirlineDetailList = new ArrayList<TaxInvoiceAirlineDetails>();
    private List<TaxInvoiceRecipientDetails> taxInvoiceRecipientDetailList = new ArrayList<TaxInvoiceRecipientDetails>();
    private List<TaxInvoiceOtherDetails> taxInvoiceOtherDetailList = new ArrayList<TaxInvoiceOtherDetails>();

    /** 
     * Get the 'taxInvoiceId' element value.
     * 
     * @return value
     */
    public int getTaxInvoiceId() {
        return taxInvoiceId;
    }

    /** 
     * Set the 'taxInvoiceId' element value.
     * 
     * @param taxInvoiceId
     */
    public void setTaxInvoiceId(int taxInvoiceId) {
        this.taxInvoiceId = taxInvoiceId;
    }

    /** 
     * Get the 'invoiceType' element value.
     * 
     * @return value
     */
    public String getInvoiceType() {
        return invoiceType;
    }

    /** 
     * Set the 'invoiceType' element value.
     * 
     * @param invoiceType
     */
    public void setInvoiceType(String invoiceType) {
        this.invoiceType = invoiceType;
    }

    /** 
     * Get the 'dateOfIssue' element value.
     * 
     * @return value
     */
    public String getDateOfIssue() {
        return dateOfIssue;
    }

    /** 
     * Set the 'dateOfIssue' element value.
     * 
     * @param dateOfIssue
     */
    public void setDateOfIssue(String dateOfIssue) {
        this.dateOfIssue = dateOfIssue;
    }

    /** 
     * Get the 'taxRegistrationNumber' element value.
     * 
     * @return value
     */
    public String getTaxRegistrationNumber() {
        return taxRegistrationNumber;
    }

    /** 
     * Set the 'taxRegistrationNumber' element value.
     * 
     * @param taxRegistrationNumber
     */
    public void setTaxRegistrationNumber(String taxRegistrationNumber) {
        this.taxRegistrationNumber = taxRegistrationNumber;
    }

    /** 
     * Get the 'stateCode' element value.
     * 
     * @return value
     */
    public String getStateCode() {
        return stateCode;
    }

    /** 
     * Set the 'stateCode' element value.
     * 
     * @param stateCode
     */
    public void setStateCode(String stateCode) {
        this.stateCode = stateCode;
    }

    /** 
     * Get the 'taxRate1Id' element value.
     * 
     * @return value
     */
    public int getTaxRate1Id() {
        return taxRate1Id;
    }

    /** 
     * Set the 'taxRate1Id' element value.
     * 
     * @param taxRate1Id
     */
    public void setTaxRate1Id(int taxRate1Id) {
        this.taxRate1Id = taxRate1Id;
    }

    /** 
     * Get the 'taxRate1Amount' element value.
     * 
     * @return value
     */
    public BigDecimal getTaxRate1Amount() {
        return taxRate1Amount;
    }

    /** 
     * Set the 'taxRate1Amount' element value.
     * 
     * @param taxRate1Amount
     */
    public void setTaxRate1Amount(BigDecimal taxRate1Amount) {
        this.taxRate1Amount = taxRate1Amount;
    }

    /** 
     * Get the 'taxRate2Id' element value.
     * 
     * @return value
     */
    public int getTaxRate2Id() {
        return taxRate2Id;
    }

    /** 
     * Set the 'taxRate2Id' element value.
     * 
     * @param taxRate2Id
     */
    public void setTaxRate2Id(int taxRate2Id) {
        this.taxRate2Id = taxRate2Id;
    }

    /** 
     * Get the 'taxRate2Amount' element value.
     * 
     * @return value
     */
    public BigDecimal getTaxRate2Amount() {
        return taxRate2Amount;
    }

    /** 
     * Set the 'taxRate2Amount' element value.
     * 
     * @param taxRate2Amount
     */
    public void setTaxRate2Amount(BigDecimal taxRate2Amount) {
        this.taxRate2Amount = taxRate2Amount;
    }

    /** 
     * Get the 'taxRate3Id' element value.
     * 
     * @return value
     */
    public int getTaxRate3Id() {
        return taxRate3Id;
    }

    /** 
     * Set the 'taxRate3Id' element value.
     * 
     * @param taxRate3Id
     */
    public void setTaxRate3Id(int taxRate3Id) {
        this.taxRate3Id = taxRate3Id;
    }

    /** 
     * Get the 'taxRate3Amount' element value.
     * 
     * @return value
     */
    public BigDecimal getTaxRate3Amount() {
        return taxRate3Amount;
    }

    /** 
     * Set the 'taxRate3Amount' element value.
     * 
     * @param taxRate3Amount
     */
    public void setTaxRate3Amount(BigDecimal taxRate3Amount) {
        this.taxRate3Amount = taxRate3Amount;
    }

    /** 
     * Get the 'taxRate4Id' element value.
     * 
     * @return value
     */
    public int getTaxRate4Id() {
        return taxRate4Id;
    }

    /** 
     * Set the 'taxRate4Id' element value.
     * 
     * @param taxRate4Id
     */
    public void setTaxRate4Id(int taxRate4Id) {
        this.taxRate4Id = taxRate4Id;
    }

    /** 
     * Get the 'taxRate4Amount' element value.
     * 
     * @return value
     */
    public BigDecimal getTaxRate4Amount() {
        return taxRate4Amount;
    }

    /** 
     * Set the 'taxRate4Amount' element value.
     * 
     * @param taxRate4Amount
     */
    public void setTaxRate4Amount(BigDecimal taxRate4Amount) {
        this.taxRate4Amount = taxRate4Amount;
    }

    /** 
     * Get the 'originalPnr' element value.
     * 
     * @return value
     */
    public String getOriginalPnr() {
        return originalPnr;
    }

    /** 
     * Set the 'originalPnr' element value.
     * 
     * @param originalPnr
     */
    public void setOriginalPnr(String originalPnr) {
        this.originalPnr = originalPnr;
    }

    /** 
     * Get the 'originalTaxInvoiceId' element value.
     * 
     * @return value
     */
    public int getOriginalTaxInvoiceId() {
        return originalTaxInvoiceId;
    }

    /** 
     * Set the 'originalTaxInvoiceId' element value.
     * 
     * @param originalTaxInvoiceId
     */
    public void setOriginalTaxInvoiceId(int originalTaxInvoiceId) {
        this.originalTaxInvoiceId = originalTaxInvoiceId;
    }

    /** 
     * Get the 'currencyCode' element value.
     * 
     * @return value
     */
    public String getCurrencyCode() {
        return currencyCode;
    }

    /** 
     * Set the 'currencyCode' element value.
     * 
     * @param currencyCode
     */
    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    /** 
     * Get the 'taxRate1Percentage' element value.
     * 
     * @return value
     */
    public BigDecimal getTaxRate1Percentage() {
        return taxRate1Percentage;
    }

    /** 
     * Set the 'taxRate1Percentage' element value.
     * 
     * @param taxRate1Percentage
     */
    public void setTaxRate1Percentage(BigDecimal taxRate1Percentage) {
        this.taxRate1Percentage = taxRate1Percentage;
    }

    /** 
     * Get the 'taxRate2Percentage' element value.
     * 
     * @return value
     */
    public BigDecimal getTaxRate2Percentage() {
        return taxRate2Percentage;
    }

    /** 
     * Set the 'taxRate2Percentage' element value.
     * 
     * @param taxRate2Percentage
     */
    public void setTaxRate2Percentage(BigDecimal taxRate2Percentage) {
        this.taxRate2Percentage = taxRate2Percentage;
    }

    /** 
     * Get the 'taxRate3Percentage' element value.
     * 
     * @return value
     */
    public BigDecimal getTaxRate3Percentage() {
        return taxRate3Percentage;
    }

    /** 
     * Set the 'taxRate3Percentage' element value.
     * 
     * @param taxRate3Percentage
     */
    public void setTaxRate3Percentage(BigDecimal taxRate3Percentage) {
        this.taxRate3Percentage = taxRate3Percentage;
    }

    /** 
     * Get the 'taxRate4Percentage' element value.
     * 
     * @return value
     */
    public BigDecimal getTaxRate4Percentage() {
        return taxRate4Percentage;
    }

    /** 
     * Set the 'taxRate4Percentage' element value.
     * 
     * @param taxRate4Percentage
     */
    public void setTaxRate4Percentage(BigDecimal taxRate4Percentage) {
        this.taxRate4Percentage = taxRate4Percentage;
    }

    /** 
     * Get the 'totalTaxAmount' element value.
     * 
     * @return value
     */
    public BigDecimal getTotalTaxAmount() {
        return totalTaxAmount;
    }

    /** 
     * Set the 'totalTaxAmount' element value.
     * 
     * @param totalTaxAmount
     */
    public void setTotalTaxAmount(BigDecimal totalTaxAmount) {
        this.totalTaxAmount = totalTaxAmount;
    }

    /** 
     * Get the 'totalTaxAndCessAmount' element value.
     * 
     * @return value
     */
    public BigDecimal getTotalTaxAndCessAmount() {
        return totalTaxAndCessAmount;
    }

    /** 
     * Set the 'totalTaxAndCessAmount' element value.
     * 
     * @param totalTaxAndCessAmount
     */
    public void setTotalTaxAndCessAmount(BigDecimal totalTaxAndCessAmount) {
        this.totalTaxAndCessAmount = totalTaxAndCessAmount;
    }

    /** 
     * Get the 'totalValueOfService' element value.
     * 
     * @return value
     */
    public BigDecimal getTotalValueOfService() {
        return totalValueOfService;
    }

    /** 
     * Set the 'totalValueOfService' element value.
     * 
     * @param totalValueOfService
     */
    public void setTotalValueOfService(BigDecimal totalValueOfService) {
        this.totalValueOfService = totalValueOfService;
    }

    /** 
     * Get the 'dateOfIssueOriginalTaxInvoice' element value.
     * 
     * @return value
     */
    public String getDateOfIssueOriginalTaxInvoice() {
        return dateOfIssueOriginalTaxInvoice;
    }

    /** 
     * Set the 'dateOfIssueOriginalTaxInvoice' element value.
     * 
     * @param dateOfIssueOriginalTaxInvoice
     */
    public void setDateOfIssueOriginalTaxInvoice(
            String dateOfIssueOriginalTaxInvoice) {
        this.dateOfIssueOriginalTaxInvoice = dateOfIssueOriginalTaxInvoice;
    }

    /** 
     * Get the list of 'TaxInvoiceAirlineDetails' element items.
     * 
     * @return list
     */
    public List<TaxInvoiceAirlineDetails> getTaxInvoiceAirlineDetailList() {
        return taxInvoiceAirlineDetailList;
    }

    /** 
     * Set the list of 'TaxInvoiceAirlineDetails' element items.
     * 
     * @param list
     */
    public void setTaxInvoiceAirlineDetailList(
            List<TaxInvoiceAirlineDetails> list) {
        taxInvoiceAirlineDetailList = list;
    }

    /** 
     * Get the list of 'TaxInvoiceRecipientDetails' element items.
     * 
     * @return list
     */
    public List<TaxInvoiceRecipientDetails> getTaxInvoiceRecipientDetailList() {
        return taxInvoiceRecipientDetailList;
    }

    /** 
     * Set the list of 'TaxInvoiceRecipientDetails' element items.
     * 
     * @param list
     */
    public void setTaxInvoiceRecipientDetailList(
            List<TaxInvoiceRecipientDetails> list) {
        taxInvoiceRecipientDetailList = list;
    }

    /** 
     * Get the list of 'TaxInvoiceOtherDetails' element items.
     * 
     * @return list
     */
    public List<TaxInvoiceOtherDetails> getTaxInvoiceOtherDetailList() {
        return taxInvoiceOtherDetailList;
    }

    /** 
     * Set the list of 'TaxInvoiceOtherDetails' element items.
     * 
     * @param list
     */
    public void setTaxInvoiceOtherDetailList(List<TaxInvoiceOtherDetails> list) {
        taxInvoiceOtherDetailList = list;
    }
}
