
package org.opentravel.ota;

import java.util.ArrayList;
import java.util.List;

/** 
 * Used to define the types
 of transportaion offered.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TransportationsType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="Transportations" minOccurs="0">
 *       &lt;!-- Reference to inner class Transportations -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class TransportationsType
{
    private Transportations transportations;

    /** 
     * Get the 'Transportations' element value.
     * 
     * @return value
     */
    public Transportations getTransportations() {
        return transportations;
    }

    /** 
     * Set the 'Transportations' element value.
     * 
     * @param transportations
     */
    public void setTransportations(Transportations transportations) {
        this.transportations = transportations;
    }
    /** 
     * Collection of
    					directions to/from a specific location via various modes of
    					transportation
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Transportations" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="Transportation" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class Transportation -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Transportations
    {
        private List<Transportation> transportationList = new ArrayList<Transportation>();

        /** 
         * Get the list of 'Transportation' element items.
         * 
         * @return list
         */
        public List<Transportation> getTransportationList() {
            return transportationList;
        }

        /** 
         * Set the list of 'Transportation' element items.
         * 
         * @param list
         */
        public void setTransportationList(List<Transportation> list) {
            transportationList = list;
        }
        /** 
         * Contains the
        								directions to/from a specific location for a mode of travel.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Transportation" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="ns:DescriptionsType" name="Descriptions" minOccurs="0" maxOccurs="2"/>
         *       &lt;xs:element type="ns:OperationSchedulesType" name="OperationSchedules" minOccurs="0"/>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute type="xs:string" use="optional" name="NotificationRequired"/>
         *     &lt;xs:attribute type="xs:string" use="optional" name="TransportationCode"/>
         *     &lt;xs:attribute type="xs:string" use="optional" name="ChargeUnit"/>
         *     &lt;xs:attribute type="xs:boolean" use="optional" name="Included"/>
         *     &lt;xs:attributeGroup ref="ns:CodeInfoGroup"/>
         *     &lt;xs:attribute type="xs:string" use="optional" name="Description"/>
         *     &lt;xs:attribute type="xs:string" use="optional" name="TypicalTravelTime"/>
         *     &lt;xs:attributeGroup ref="ns:CurrencyAmountGroup"/>
         *     &lt;xs:attribute type="xs:string" use="optional" name="ExistsCode"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Transportation
        {
            private List<DescriptionsType> descriptionList = new ArrayList<DescriptionsType>();
            private OperationSchedulesType operationSchedules;
            private String notificationRequired;
            private String transportationCode;
            private String chargeUnit;
            private Boolean included;
            private CodeInfoGroup codeInfoGroup;
            private String description;
            private String typicalTravelTime;
            private CurrencyAmountGroup currencyAmountGroup;
            private String existsCode;

            /** 
             * Get the list of 'Descriptions' element items.
             * 
             * @return list
             */
            public List<DescriptionsType> getDescriptionList() {
                return descriptionList;
            }

            /** 
             * Set the list of 'Descriptions' element items.
             * 
             * @param list
             */
            public void setDescriptionList(List<DescriptionsType> list) {
                descriptionList = list;
            }

            /** 
             * Get the 'OperationSchedules' element value. Collection of
            										operation schedules for the transportation.
             * 
             * @return value
             */
            public OperationSchedulesType getOperationSchedules() {
                return operationSchedules;
            }

            /** 
             * Set the 'OperationSchedules' element value. Collection of
            										operation schedules for the transportation.
             * 
             * @param operationSchedules
             */
            public void setOperationSchedules(
                    OperationSchedulesType operationSchedules) {
                this.operationSchedules = operationSchedules;
            }

            /** 
             * Get the 'NotificationRequired' attribute value. This would be used
            									for information such as a shuttle needs to be requested or a
            									reservation is required.
             * 
             * @return value
             */
            public String getNotificationRequired() {
                return notificationRequired;
            }

            /** 
             * Set the 'NotificationRequired' attribute value. This would be used
            									for information such as a shuttle needs to be requested or a
            									reservation is required.
             * 
             * @param notificationRequired
             */
            public void setNotificationRequired(String notificationRequired) {
                this.notificationRequired = notificationRequired;
            }

            /** 
             * Get the 'TransportationCode' attribute value. The mode of
            									transportation. Refer to OTA Code List Transportation Code
            									(TRP).
             * 
             * @return value
             */
            public String getTransportationCode() {
                return transportationCode;
            }

            /** 
             * Set the 'TransportationCode' attribute value. The mode of
            									transportation. Refer to OTA Code List Transportation Code
            									(TRP).
             * 
             * @param transportationCode
             */
            public void setTransportationCode(String transportationCode) {
                this.transportationCode = transportationCode;
            }

            /** 
             * Get the 'ChargeUnit' attribute value. Refer to OTA
            									Codelist Charge Type (CHG).
             * 
             * @return value
             */
            public String getChargeUnit() {
                return chargeUnit;
            }

            /** 
             * Set the 'ChargeUnit' attribute value. Refer to OTA
            									Codelist Charge Type (CHG).
             * 
             * @param chargeUnit
             */
            public void setChargeUnit(String chargeUnit) {
                this.chargeUnit = chargeUnit;
            }

            /** 
             * Get the 'Included' attribute value.
             * 
             * @return value
             */
            public Boolean getIncluded() {
                return included;
            }

            /** 
             * Set the 'Included' attribute value.
             * 
             * @param included
             */
            public void setIncluded(Boolean included) {
                this.included = included;
            }

            /** 
             * Get the 'CodeInfoGroup' attributeGroup value. May be used to
            									give further detail on the code (e.g. if a trolley is chosen,
            									the trolley name could be added here) or to remove an
            									obsolete item.								
             * 
             * @return value
             */
            public CodeInfoGroup getCodeInfoGroup() {
                return codeInfoGroup;
            }

            /** 
             * Set the 'CodeInfoGroup' attributeGroup value. May be used to
            									give further detail on the code (e.g. if a trolley is chosen,
            									the trolley name could be added here) or to remove an
            									obsolete item.								
             * 
             * @param codeInfoGroup
             */
            public void setCodeInfoGroup(CodeInfoGroup codeInfoGroup) {
                this.codeInfoGroup = codeInfoGroup;
            }

            /** 
             * Get the 'Description' attribute value. Descriptive
            									information about the mode of transportation.
             * 
             * @return value
             */
            public String getDescription() {
                return description;
            }

            /** 
             * Set the 'Description' attribute value. Descriptive
            									information about the mode of transportation.
             * 
             * @param description
             */
            public void setDescription(String description) {
                this.description = description;
            }

            /** 
             * Get the 'TypicalTravelTime' attribute value. The normal
            									(average) travel time required to get to or from the
            									location, measured in minutes. 
             * 
             * @return value
             */
            public String getTypicalTravelTime() {
                return typicalTravelTime;
            }

            /** 
             * Set the 'TypicalTravelTime' attribute value. The normal
            									(average) travel time required to get to or from the
            									location, measured in minutes. 
             * 
             * @param typicalTravelTime
             */
            public void setTypicalTravelTime(String typicalTravelTime) {
                this.typicalTravelTime = typicalTravelTime;
            }

            /** 
             * Get the 'CurrencyAmountGroup' attributeGroup value.
             * 
             * @return value
             */
            public CurrencyAmountGroup getCurrencyAmountGroup() {
                return currencyAmountGroup;
            }

            /** 
             * Set the 'CurrencyAmountGroup' attributeGroup value.
             * 
             * @param currencyAmountGroup
             */
            public void setCurrencyAmountGroup(
                    CurrencyAmountGroup currencyAmountGroup) {
                this.currencyAmountGroup = currencyAmountGroup;
            }

            /** 
             * Get the 'ExistsCode' attribute value. This attribute is
            									used to explicitly define whether the type of transportation
            									applies. Refer to OTA Code list Option Type Code (OTC). This
            									is used in conjunction with TransportationCode.
             * 
             * @return value
             */
            public String getExistsCode() {
                return existsCode;
            }

            /** 
             * Set the 'ExistsCode' attribute value. This attribute is
            									used to explicitly define whether the type of transportation
            									applies. Refer to OTA Code list Option Type Code (OTC). This
            									is used in conjunction with TransportationCode.
             * 
             * @param existsCode
             */
            public void setExistsCode(String existsCode) {
                this.existsCode = existsCode;
            }
        }
    }
}
