
package org.opentravel.ota;

import java.util.ArrayList;
import java.util.List;

/** 
 * Traveler wise fulfillment details.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TravelersFulfillments">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element name="TravelerFulfillments" maxOccurs="unbounded">
 *         &lt;!-- Reference to inner class TravelerFulfillments -->
 *       &lt;/xs:element>
 *     &lt;/xs:sequence>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class TravelersFulfillments
{
    private List<TravelerFulfillments> travelerFulfillmentList = new ArrayList<TravelerFulfillments>();

    /** 
     * Get the list of 'TravelerFulfillments' element items.
     * 
     * @return list
     */
    public List<TravelerFulfillments> getTravelerFulfillmentList() {
        return travelerFulfillmentList;
    }

    /** 
     * Set the list of 'TravelerFulfillments' element items.
     * 
     * @param list
     */
    public void setTravelerFulfillmentList(List<TravelerFulfillments> list) {
        travelerFulfillmentList = list;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TravelerFulfillments" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="ns:PaymentDetailType" name="PaymentDetail" maxOccurs="2"/>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:string" name="TravelerRefNumberRPH"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class TravelerFulfillments
    {
        private List<PaymentDetailType> paymentDetailList = new ArrayList<PaymentDetailType>();
        private String travelerRefNumberRPH;

        /** 
         * Get the list of 'PaymentDetail' element items. 
                                            Form of Traveler wise payment details for the requested booking. It is possible
                                            to use multiple forms of payment for one transaction, therefore this element may
                                            be used more than once.
                                        
         * 
         * @return list
         */
        public List<PaymentDetailType> getPaymentDetailList() {
            return paymentDetailList;
        }

        /** 
         * Set the list of 'PaymentDetail' element items. 
                                            Form of Traveler wise payment details for the requested booking. It is possible
                                            to use multiple forms of payment for one transaction, therefore this element may
                                            be used more than once.
                                        
         * 
         * @param list
         */
        public void setPaymentDetailList(List<PaymentDetailType> list) {
            paymentDetailList = list;
        }

        /** 
         * Get the 'TravelerRefNumberRPH' attribute value.
         * 
         * @return value
         */
        public String getTravelerRefNumberRPH() {
            return travelerRefNumberRPH;
        }

        /** 
         * Set the 'TravelerRefNumberRPH' attribute value.
         * 
         * @param travelerRefNumberRPH
         */
        public void setTravelerRefNumberRPH(String travelerRefNumberRPH) {
            this.travelerRefNumberRPH = travelerRefNumberRPH;
        }
    }
}
