/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.farelogix.ibus;

import com.gridnine.farelogix.ndc.AirShoppingRQ;
import com.gridnine.farelogix.ndc.AirShoppingRS;
import com.gridnine.farelogix.ndc.ErrorsType;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.system.HttpResponse;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.server.gds.farelogix.ibus.IBusGdsFarelogixContextKeys;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.jibx.JiBXHelper;
import com.gridnine.xtrip.server.model.ibus.http.IBusHttpContextKeys;
import com.gridnine.xtrip.server.xstreamws.XStreamResponseParser;
import java.util.Collection;
import java.util.stream.Collectors;

public class FareLogixHttpResponseParser
extends XStreamResponseParser {
    public void process(MessageContext ctx) throws Exception {
        Object rq = ctx.getObject((Enum)IBusGdsFarelogixContextKeys.FARELOGIX_REQUEST);
        HttpResponse httpResponse = (HttpResponse)ctx.getMandatoryObject((Enum)IBusHttpContextKeys.HTTP_RESPONSE);
        this.checkResponse(httpResponse);
        Class responseClass = this.getResponseClass(rq);
        Object response = this.buildResponse(httpResponse, responseClass);
        this.checkErrors(response);
        ctx.putObject((Enum)IBusGdsFarelogixContextKeys.FARELOGIX_RESPONSE, response);
    }

    private Class getResponseClass(Object rq) {
        if (rq instanceof AirShoppingRQ) {
            return AirShoppingRS.class;
        }
        throw Xeption.forDeveloper((String)("undefined response for request " + rq.getClass()), (Object[])new Object[0]);
    }

    private Object buildResponse(HttpResponse httpResponse, Class responseClass) throws Exception {
        String soapEnvelope = new String(httpResponse.getBody());
        String body = this.getSoapTopLevelTagContent(soapEnvelope, "RSP");
        Object result = JiBXHelper.read((Class)responseClass, (byte[])body.getBytes("utf-8"));
        return result;
    }

    private void checkErrors(Object response) {
        if (response instanceof AirShoppingRS) {
            AirShoppingRS rs = (AirShoppingRS)response;
            this.checkErrorsType(rs.getErrors());
        }
    }

    private void checkErrorsType(ErrorsType errorsType) {
        if (errorsType == null || CollectionUtil.isEmpty((Collection)errorsType.getErrorList())) {
            return;
        }
        String errorsText = errorsType.getErrorList().stream().map(er -> er.getFreeTextType().getString()).collect(Collectors.joining("\n"));
        throw Xeption.forDeveloper((String)errorsText, (Object[])new Object[0]);
    }
}

