/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.farelogix.ibus;

import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.gds.farelogix.model.BaseFlxResponse;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GdsErrorTranslator {
    private static final Map<Pattern, String> USER_MESSAGES = new HashMap<Pattern, String>();

    public Xeption translate(BaseFlxResponse.FlxError flxError) {
        String errCode = flxError.getCode();
        L10nMessage userMessage = this.findMatchesMessageWithArgs(errCode);
        if (userMessage != null) {
            return new Xeption(userMessage, null, null, null);
        }
        return null;
    }

    private L10nMessage findMatchesMessageWithArgs(String text) {
        if (TextUtil.isBlank((String)text)) {
            return null;
        }
        for (Map.Entry<Pattern, String> entry : USER_MESSAGES.entrySet()) {
            Matcher m = entry.getKey().matcher(text);
            if (!m.find()) continue;
            Object[] args = new String[m.groupCount()];
            for (int i = 0; i < m.groupCount(); ++i) {
                args[i] = m.group(i + 1);
            }
            return L10nResourcesManager.createL10nMessage((String)entry.getValue(), (Object[])args);
        }
        return null;
    }

    static {
        USER_MESSAGES.put(Pattern.compile("421"), "FARE_LOGIX_MESSAGE_AIRLINE_DOESNT_CONFIRM_SEATS_RETRY_REQUEST");
        USER_MESSAGES.put(Pattern.compile("9999"), "FARE_LOGIX_MESSAGE_DISCONNECTED_TO_SYSTEM");
        USER_MESSAGES.put(Pattern.compile("140011072"), "FARE_LOGIX_MESSAGE_AIRLINE_DOESNT_CONFIRM_SEATS_CONTACT_CALL_CENTER");
        USER_MESSAGES.put(Pattern.compile("368"), "FARE_LOGIX_MESSAGE_DISCONNECTED_TO_SYSTEM");
    }
}

