/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.farelogix.ibus.cancelReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.server.gds.farelogix.ibus.FarelogixHelper;
import com.gridnine.xtrip.server.gds.farelogix.ibus.IBusGdsFarelogixContextKeys;
import com.gridnine.xtrip.server.gds.farelogix.model.PNRViewRS;
import com.gridnine.xtrip.server.gds.farelogix.model.common.PNRIdentification;
import com.gridnine.xtrip.server.gds.farelogix.model.common.TicketInfo;
import com.gridnine.xtrip.server.gds.farelogix.model.common.TicketStatus;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;

public class FarelogixCheckPnrStatusProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        PNRViewRS response = (PNRViewRS)ctx.getMandatoryObject((Enum)IBusGdsFarelogixContextKeys.FARELOGIX_RESPONSE);
        String pnrStatus = response.getPnrIdentification().getPnrStatus();
        String recordLocator = FarelogixHelper.getRecordLocator(reservation);
        if ("C".equals(pnrStatus)) {
            ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u0411\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 {0} \u0443\u0436\u0435 \u043e\u0442\u043c\u0435\u043d\u0435\u043d\u043e", (Object[])new Object[]{recordLocator}));
            ctx.putObject((Enum)IBusGdsFarelogixContextKeys.FARELOGIX_SKIP_OPERATION, (Object)Boolean.TRUE);
        } else if (response.getPnrIdentification().isTicketIssued() && !this.isVoided(response.getPnrIdentification())) {
            ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u0411\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 {0} \u0443\u0436\u0435 \u0432\u044b\u043f\u0438\u0441\u0430\u043d\u043e", (Object[])new Object[]{recordLocator}));
            throw Xeption.forEndUser((String)"\u0411\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 {0} \u0443\u0436\u0435 \u0432\u044b\u043f\u0438\u0441\u0430\u043d\u043e", (Object[])new Object[]{recordLocator});
        }
    }

    private boolean isVoided(PNRIdentification pnrIdentification) {
        for (TicketInfo ticketInfo : pnrIdentification.getTicketInfos()) {
            if (TicketStatus.parse(ticketInfo.getTicketNumber().getStatus()) == TicketStatus.VOIDED) continue;
            return false;
        }
        return true;
    }
}

