/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.farelogix.ibus.createReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.GDSParameters;
import com.gridnine.xtrip.common.gds.model.GdsReservationCreationParameters;
import com.gridnine.xtrip.common.gds.model.GdsTraveller;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.dict.Aircraft;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.server.gds.farelogix.ibus.FarelogixTestUtil;
import com.gridnine.xtrip.server.gds.farelogix.ibus.IBusGdsFarelogixContextKeys;
import com.gridnine.xtrip.server.gds.farelogix.ibus.createReservation.FarelogixCreateReservationResponseParser;
import com.gridnine.xtrip.server.gds.farelogix.model.XXTransactionResponse;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.test.ModelTestBase;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Element;

public class FarelogixCreateReservationResponseParserTest
extends ModelTestBase {
    private static List<String> geoLocationCodes = Arrays.asList("DXB", "DEL", "BOM");
    private static List<String> aircraftCodes = Arrays.asList("77W", "773", "388");

    public void setUp() throws Exception {
        GeoLocation dict;
        super.setUp();
        Airline airlineEK = new Airline();
        airlineEK.setCode("EK");
        DictionaryCache.get().put((BaseDictionary)airlineEK);
        for (String code : geoLocationCodes) {
            dict = new GeoLocation();
            dict.setCode(code);
            DictionaryCache.get().put((BaseDictionary)dict);
        }
        for (String code : aircraftCodes) {
            dict = new Aircraft();
            dict.setCode(code);
            DictionaryCache.get().put((BaseDictionary)dict);
        }
    }

    @Test
    public void testResponseParser() throws Throwable {
        FarelogixCreateReservationResponseParser processor = new FarelogixCreateReservationResponseParser();
        XXTransactionResponse resp = FarelogixTestUtil.parseXStream(((Object)((Object)this)).getClass(), "FarelogixPnrViewGdsResponse.xml");
        MessageContext ctx = new MessageContext();
        ctx.putObject((Enum)IBusGdsFarelogixContextKeys.FARELOGIX_RESPONSE, (Object)resp.getResponse().getPnrViewRS());
        ctx.putObject((Enum)IBusMidofficeContextKeys.RESERVATION_CREATION_PARAMETERS, (Object)this.buildCreationParameters());
        ctx.putObject((Enum)IBusGdsContextKeys.GDS_PARAMETERS, (Object)this.buildGDSParameters());
        ctx.putObject((Enum)IBusMidofficeContextKeys.TRAVELLERS, this.buildTravellers());
        processor.process(ctx);
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        Element elm = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument().createElement("reservation");
        reservation.toXML(elm);
        Assert.assertEquals((long)4L, (long)reservation.getProducts().size());
    }

    private GDSParameters buildGDSParameters() {
        GDSParameters result = new GDSParameters();
        return result;
    }

    private GdsReservationCreationParameters buildCreationParameters() {
        GdsReservationCreationParameters result = new GdsReservationCreationParameters();
        GdsTraveller gdsTr = new GdsTraveller();
        gdsTr.setPassengerType(DictHelper.getAdultPassengerType());
        gdsTr.setTravellerUid("travellerAdult1");
        result.getGdsTravellers().add(gdsTr);
        gdsTr = new GdsTraveller();
        gdsTr.setPassengerType(DictHelper.getAdultPassengerType());
        gdsTr.setTravellerUid("travellerAdult2");
        result.getGdsTravellers().add(gdsTr);
        gdsTr = new GdsTraveller();
        gdsTr.setPassengerType(DictHelper.getChildPassengerType());
        gdsTr.setTravellerUid("travellerChild");
        result.getGdsTravellers().add(gdsTr);
        gdsTr = new GdsTraveller();
        gdsTr.setPassengerType(DictHelper.getInfantPassengerType());
        gdsTr.setTravellerUid("travellerInfant");
        result.getGdsTravellers().add(gdsTr);
        return result;
    }

    private List<Traveller> buildTravellers() throws Exception {
        ArrayList<Traveller> result = new ArrayList<Traveller>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Traveller tr = new Traveller();
        tr.setUid("travellerAdult1");
        tr.setName("Traveller adult 1");
        Passport psp = new Passport();
        psp.setLastName("IVANOVICH");
        psp.setFirstName("IVAN");
        psp.setBirthday(sdf.parse("1980-11-11"));
        tr.setPassport(psp);
        result.add(tr);
        tr = new Traveller();
        tr.setUid("travellerAdult2");
        tr.setName("Traveller adult 2");
        psp = new Passport();
        psp.setLastName("IVANOVICH");
        psp.setFirstName("Ivanna");
        psp.setBirthday(sdf.parse("1981-11-11"));
        tr.setPassport(psp);
        result.add(tr);
        tr = new Traveller();
        tr.setUid("travellerChild");
        tr.setName("Traveller child");
        psp = new Passport();
        psp.setLastName("IVANOV");
        psp.setFirstName("CHILD");
        psp.setBirthday(sdf.parse("2010-10-21"));
        tr.setPassport(psp);
        result.add(tr);
        tr = new Traveller();
        tr.setUid("travellerInfant");
        tr.setName("Traveller infant");
        psp = new Passport();
        psp.setLastName("IVANOV");
        psp.setFirstName("BABY");
        psp.setBirthday(sdf.parse("2015-11-11"));
        tr.setPassport(psp);
        result.add(tr);
        return result;
    }
}

