/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.farelogix.ibus.modifyFqtv;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.AirlineBonusCardParameters;
import com.gridnine.xtrip.common.gds.model.ModifyAirlineBonusCardsParameters;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.server.gds.farelogix.ibus.FarelogixHelper;
import com.gridnine.xtrip.server.gds.farelogix.ibus.IBusGdsFarelogixContextKeys;
import com.gridnine.xtrip.server.gds.farelogix.model.PNRCreateRQ;
import com.gridnine.xtrip.server.gds.ibus.fqtv.IBusGdsFqtvContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;

public class PNRCreateRQBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        ModifyAirlineBonusCardsParameters mabcp = (ModifyAirlineBonusCardsParameters)ctx.getMandatoryObject((Enum)IBusGdsFqtvContextKeys.MODIFY_AIRLINE_BONUS_CARDS_PARAMETERS);
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        ctx.putObject((Enum)IBusGdsFarelogixContextKeys.FARELOGIX_REQUEST, (Object)this.buildRQ(reservation, mabcp));
    }

    private PNRCreateRQ buildRQ(Reservation reservation, ModifyAirlineBonusCardsParameters mabcp) {
        PNRCreateRQ result = new PNRCreateRQ();
        PNRCreateRQ.OtherPNRElements otherPNRElements = new PNRCreateRQ.OtherPNRElements();
        for (AirlineBonusCardParameters airlineBonusCardParameters : mabcp.getCardsToAdd()) {
            PNRCreateRQ.FrequentTravelerGroup frequentTravellerGroup = new PNRCreateRQ.FrequentTravelerGroup();
            Product product = reservation.getProducts().stream().map(bp -> (Product)bp).filter(p -> p.getTraveller().getUid().equals(airlineBonusCardParameters.getTravellerUid())).findAny().get();
            frequentTravellerGroup.setTravelerIDRef(product.getGdsId());
            frequentTravellerGroup.setFfCompanyCode(airlineBonusCardParameters.getCard().getAirline().getCode());
            frequentTravellerGroup.setFfNumber(airlineBonusCardParameters.getCard().getNumber());
            otherPNRElements.getFrequentTravelerGroups().add(frequentTravellerGroup);
        }
        result.setOtherPNRElements(otherPNRElements);
        PNRCreateRQ.EndTransaction et = new PNRCreateRQ.EndTransaction();
        et.setTransactionType(PNRCreateRQ.TransactionType.END_TRANSACTION_RETRIEVE_PNR);
        et.setIgnoreWarnings(true);
        result.setEndTransaction(et);
        result.setRecordLocator(FarelogixHelper.getRecordLocator(reservation));
        return result;
    }
}

