/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.farelogix.ibus.modifyFqtv;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.AirlineBonusCardParameters;
import com.gridnine.xtrip.common.gds.model.ModifyAirlineBonusCardsParameters;
import com.gridnine.xtrip.common.model.BookingAirlineBonusCard;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.gds.farelogix.ibus.IBusGdsFarelogixContextKeys;
import com.gridnine.xtrip.server.gds.farelogix.model.PNRViewRS;
import com.gridnine.xtrip.server.gds.ibus.fqtv.IBusGdsFqtvContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;

public class PNRViewRSParser
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        ModifyAirlineBonusCardsParameters mabcp = (ModifyAirlineBonusCardsParameters)ctx.getMandatoryObject((Enum)IBusGdsFqtvContextKeys.MODIFY_AIRLINE_BONUS_CARDS_PARAMETERS);
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        PNRViewRS pnrViewRS = (PNRViewRS)ctx.getMandatoryObject((Enum)IBusGdsFarelogixContextKeys.FARELOGIX_RESPONSE);
        for (AirlineBonusCardParameters airlineBonusCardParameters : mabcp.getCardsToAdd()) {
            Product product = BookingHelper.findAirProductByTravellerUid((Reservation)reservation, (String)airlineBonusCardParameters.getTravellerUid());
            String gdsId = product.getGdsId();
            boolean existsInResponse = pnrViewRS.getFrequentTravelerGroups().stream().anyMatch(ftg -> this.isSameFrequentTravelerGroup((PNRViewRS.FrequentTravelerGroup)ftg, gdsId, airlineBonusCardParameters.getCard()));
            if (existsInResponse) continue;
            throw Xeption.forDeveloper((String)"\u041a\u0430\u0440\u0442\u0430 \u043d\u0435 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0430", (Object[])new Object[0]);
        }
    }

    private boolean isSameFrequentTravelerGroup(PNRViewRS.FrequentTravelerGroup ftg, String gdsId, BookingAirlineBonusCard card) {
        if (!MiscUtil.equals((Object)ftg.getTravelerElementNumber(), (Object)gdsId)) {
            return false;
        }
        if (!MiscUtil.equals((Object)ftg.getFfNumber(), (Object)card.getNumber())) {
            return false;
        }
        return MiscUtil.equals((Object)ftg.getFfCompanyCode(), (Object)card.getAirline().getCode());
    }
}

