/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.farelogix.ibus.pnrRetrieve;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.gds.farelogix.ibus.IBusGdsFarelogixContextKeys;
import com.gridnine.xtrip.server.gds.farelogix.model.PNRViewRS;
import com.gridnine.xtrip.server.gds.farelogix.model.common.PNRIdentification;
import com.gridnine.xtrip.server.gds.farelogix.model.common.TicketInfo;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Date;
import java.util.HashSet;

public class FarelogixTicketProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        PNRViewRS response = (PNRViewRS)ctx.getMandatoryObject((Enum)IBusGdsFarelogixContextKeys.FARELOGIX_RESPONSE);
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        this.updateReservation(reservation, response);
    }

    private void updateReservation(Reservation reservation, PNRViewRS response) throws Exception {
        for (Product prod : AirProductHelper.getProducts((Reservation)reservation)) {
            TicketInfo ticketInfo = this.findTicketInfo(prod.getGdsId(), response.getPnrIdentification());
            if (ticketInfo == null) {
                throw Xeption.forDeveloper((String)"can't find ticketInfo by gdsId {0}", (Object[])new Object[]{prod.getGdsId()});
            }
            this.updateTicketNumber(prod, ticketInfo.getTicketNumber().getValue());
            prod.setConjCount(this.calcConjCount(ticketInfo));
            prod.setIssueDate(new Date());
            prod.setStatus(ProductStatus.SELL);
        }
    }

    private TicketInfo findTicketInfo(String gdsId, PNRIdentification pnrIdentification) {
        for (TicketInfo ticketInfo : pnrIdentification.getTicketInfos()) {
            if (!gdsId.equals(ticketInfo.getTravelerElementNumber())) continue;
            return ticketInfo;
        }
        return null;
    }

    private void updateTicketNumber(Product prod, String gdsTicketNumber) {
        if (TextUtil.isBlank((String)gdsTicketNumber)) {
            return;
        }
        prod.setCarrierNumber(gdsTicketNumber.substring(0, 3));
        prod.setSystemNumber(gdsTicketNumber.substring(3, 13));
    }

    private String getValidTicketNumber(String ticketNumber) {
        if (TextUtil.isBlank((String)ticketNumber)) {
            return null;
        }
        return ticketNumber.substring(0, 13);
    }

    private int calcConjCount(TicketInfo ticketInfo) {
        if (ticketInfo.getFlightReferences().isEmpty()) {
            return 0;
        }
        HashSet<String> tickeNumbers = new HashSet<String>();
        for (PNRViewRS.FlightReferences fr : ticketInfo.getFlightReferences()) {
            tickeNumbers.add(this.getValidTicketNumber(fr.getTicketNumber()));
        }
        return tickeNumbers.size() - 1;
    }
}

