/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.farelogix.ibus.pnrRetrieve;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.exceptions.DifferentSegmentsCountException;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.gds.GDSRepriceHelper;
import com.gridnine.xtrip.server.gds.farelogix.ibus.FarelogixHelper;
import com.gridnine.xtrip.server.gds.farelogix.ibus.IBusGdsFarelogixContextKeys;
import com.gridnine.xtrip.server.gds.farelogix.model.PNRViewRS;
import com.gridnine.xtrip.server.gds.farelogix.model.common.CurrencyInfo;
import com.gridnine.xtrip.server.gds.farelogix.model.common.FareGroupRS;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class FarelogixUpdatePricesProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        PNRViewRS response = (PNRViewRS)ctx.getMandatoryObject((Enum)IBusGdsFarelogixContextKeys.FARELOGIX_RESPONSE);
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        ArrayList<Message> messages = new ArrayList<Message>();
        this.updateReservation(reservation, response, messages);
        ctx.addMessages(messages);
    }

    private void updateReservation(Reservation reservation, PNRViewRS response, List<Message> messages) throws Exception {
        this.checkSegmentsCount(reservation, response);
        for (Product prod : AirProductHelper.getProducts((Reservation)reservation)) {
            MiscUtil.Pair<FareGroupRS, PNRViewRS.TravelerGroupRS> pair = FarelogixHelper.findTravelerGroup(prod.getGdsId(), response);
            if (pair == null) {
                throw Xeption.forDeveloper((String)"can't find TravelerGroup by gdsId {0}", (Object[])new Object[]{prod.getGdsId()});
            }
            FareGroupRS fg = (FareGroupRS)pair.getFirst();
            PNRViewRS.TravelerGroupRS tg = (PNRViewRS.TravelerGroupRS)pair.getSecond();
            List segments = AirProductHelper.getSegments((Collection)prod.getSegmentTariffs());
            String calcLine = tg.getFareRules().getFareCalculation();
            List stList = GDSHelper.buildSegmentTariffs((Collection)segments, (String)calcLine);
            prod.getSegmentTariffs().clear();
            prod.getSegmentTariffs().addAll(stList);
            CurrencyInfo currencyInfo = fg.getCurrencyInfo();
            GDSRepriceHelper.updateAndCheckProductPrices((Product)prod, product -> FarelogixHelper.updateProduct(product, tg, currencyInfo, fg.getFareType(), fg.getSource()), messages);
        }
    }

    private void checkSegmentsCount(Reservation reservation, PNRViewRS response) {
        Product prod = AirProductHelper.getAirProductsStream((Reservation)reservation).findFirst().orElse(null);
        List segments = AirProductHelper.getSegments((Collection)prod.getSegmentTariffs());
        if (response.getAirGroup() == null) {
            throw new DifferentSegmentsCountException();
        }
        if (response.getAirGroup().getFlights().size() != segments.size()) {
            throw new DifferentSegmentsCountException();
        }
    }
}

