/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.farelogix.ibus.searchFlightFares;

import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.gds.model.SeatPreferences;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.gds.farelogix.ibus.FarelogixHelper;
import com.gridnine.xtrip.server.gds.farelogix.ibus.IBusGdsFarelogixContextKeys;
import com.gridnine.xtrip.server.gds.farelogix.model.AirAvailabilityRQ;
import com.gridnine.xtrip.server.gds.farelogix.model.common.TravelerIDs;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;
import java.util.List;

public class FarelogixAirAvailabilityRequestBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Flight flight = (Flight)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT);
        ctx.putObject((Enum)IBusGdsFarelogixContextKeys.FARELOGIX_REQUEST, (Object)this.buildRequest(flight));
    }

    private AirAvailabilityRQ buildRequest(Flight flight) {
        AirAvailabilityRQ result = new AirAvailabilityRQ();
        result.setScheduleOnly(false);
        for (SeatPreferences seat : flight.getSeats()) {
            String paxType = FarelogixHelper.getNativeCode(seat.getPassengerType());
            for (int i = 0; i < seat.getCount(); ++i) {
                TravelerIDs tid = new TravelerIDs();
                tid.setAssociationID(String.format("T%s", result.getTravelerIDs().size() + 1));
                tid.setPaxType(paxType);
                result.getTravelerIDs().add(tid);
            }
        }
        result.getOriginDestinations().addAll(this.buildOriginDestinations(flight));
        return result;
    }

    private List<AirAvailabilityRQ.OriginDestination> buildOriginDestinations(Flight flight) {
        ArrayList<AirAvailabilityRQ.OriginDestination> result = new ArrayList<AirAvailabilityRQ.OriginDestination>();
        AirAvailabilityRQ.OriginDestination od = null;
        for (FlightSegment fs : FlightHelper.getSegments((Flight)flight)) {
            AirAvailabilityRQ.FlightSpecific gdsFs = this.buildFlightSpecific(fs);
            od = new AirAvailabilityRQ.OriginDestination();
            od.setPreferences(new AirAvailabilityRQ.Preferences());
            od.setDeparture(this.buildGeoLocation(gdsFs.getDepartureCode()));
            od.setDepartureDate(gdsFs.getDepartureDate());
            String cabin = FarelogixHelper.convertServiceClassToGds(fs.getServiceClass());
            if (!TextUtil.isBlank((String)cabin)) {
                od.getPreferences().setCabin(cabin);
            }
            result.add(od);
            od.getPreferences().getFlightSpecifics().add(gdsFs);
            od.setArrival(this.buildGeoLocation(gdsFs.getArrivalCode()));
        }
        return result;
    }

    private AirAvailabilityRQ.FlightSpecific buildFlightSpecific(FlightSegment fs) {
        AirAvailabilityRQ.FlightSpecific result = new AirAvailabilityRQ.FlightSpecific();
        result.setDepartureCode(FarelogixHelper.getNativeCode(fs.getLocationBegin()));
        result.setArrivalCode(FarelogixHelper.getNativeCode(fs.getLocationEnd()));
        result.setDepartureDate(FarelogixHelper.toLocalDate(fs.getDateBegin()));
        result.setAirlineCode(FarelogixHelper.getNativeCode(fs.getAirline()));
        result.setFlightNumber(fs.getFlightNumber());
        return result;
    }

    private AirAvailabilityRQ.GeoLocation buildGeoLocation(String code) {
        AirAvailabilityRQ.GeoLocation result = new AirAvailabilityRQ.GeoLocation();
        result.setCityCode(code);
        return result;
    }
}

