/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.farelogix.ibus.searchFlights;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.farelogix.ndc.AgencyCoreRepType;
import com.gridnine.farelogix.ndc.AgencyID;
import com.gridnine.farelogix.ndc.AgentUser;
import com.gridnine.farelogix.ndc.AirShopReqAttributeQueryType;
import com.gridnine.farelogix.ndc.AirShoppingRQ;
import com.gridnine.farelogix.ndc.AirlineIDType;
import com.gridnine.farelogix.ndc.AirlinePreferencesType;
import com.gridnine.farelogix.ndc.CabinPreferencesType;
import com.gridnine.farelogix.ndc.CabinType;
import com.gridnine.farelogix.ndc.CarrierFeeInfoType;
import com.gridnine.farelogix.ndc.FarePreferencesType;
import com.gridnine.farelogix.ndc.FlightArrivalType;
import com.gridnine.farelogix.ndc.FlightDepartureType;
import com.gridnine.farelogix.ndc.FlightPreferencesType;
import com.gridnine.farelogix.ndc.MsgPartiesType;
import com.gridnine.farelogix.ndc.PassengerType;
import com.gridnine.farelogix.ndc.PreferenceAttrGroup;
import com.gridnine.farelogix.ndc.TravelAgencySender;
import com.gridnine.farelogix.ndc.UniqueIDContextType;
import com.gridnine.xtrip.common.gds.farelogix.model.FarelogixGdsAccount;
import com.gridnine.xtrip.common.gds.model.FlightSearchParameters;
import com.gridnine.xtrip.common.gds.model.RouteSegment;
import com.gridnine.xtrip.common.gds.model.SeatPreferences;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.server.gds.farelogix.ibus.FarelogixHelper;
import com.gridnine.xtrip.server.gds.farelogix.ibus.IBusGdsFarelogixContextKeys;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class FarelogixSearchFlightsRequestBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        FlightSearchParameters fsp = (FlightSearchParameters)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT_SEARCH_PARAMETERS);
        EntityContainer accountCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        Collection airlines = (Collection)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.APPLICABLE_AIRLINES);
        ctx.putObject((Enum)IBusGdsFarelogixContextKeys.FARELOGIX_REQUEST, (Object)this.buildRequest(fsp, (FarelogixGdsAccount)accountCtr.getEntity(), airlines));
    }

    private AirShoppingRQ buildRequest(FlightSearchParameters fsp, FarelogixGdsAccount gdsAccount, Collection<DictionaryReference<Airline>> airlines) {
        FlightPreferencesType fp;
        AirShoppingRQ result = new AirShoppingRQ();
        result.setParty(new MsgPartiesType());
        TravelAgencySender tas = new TravelAgencySender();
        tas.setAgencyID(this.buildAgencyID(gdsAccount.getAgencyCode()));
        tas.setPseudoCity(this.buildPseudoCity(gdsAccount.getPcc()));
        result.getParty().setSenderTravelAgencySender(tas);
        AgentUser au = new AgentUser();
        au.setPseudoCity(this.buildPseudoCity(gdsAccount.getPcc()));
        au.setAgentUserID(this.buildAgentUserID(gdsAccount.getAccount()));
        au.setUserRole(gdsAccount.getAgtRole());
        tas.setAgentUser(au);
        result.getParty().setSenderTravelAgencySender(tas);
        result.setCoreQueryOriginDestinations(new AirShopReqAttributeQueryType());
        int odInd = 1;
        for (RouteSegment rs : fsp.getRoute()) {
            AirShopReqAttributeQueryType.OriginDestination od = new AirShopReqAttributeQueryType.OriginDestination();
            od.setOriginDestinationKey("OD" + odInd++);
            od.setDeparture(this.getFlightDeparture((DictionaryReference<GeoLocation>)rs.getLocationBegin(), rs.getDate()));
            od.setArrival(this.getFlightArrival((DictionaryReference<GeoLocation>)rs.getLocationEnd(), null));
            result.getCoreQueryOriginDestinations().getOriginDestinationList().add(od);
        }
        result.setDataLists(new AirShoppingRQ.DataLists());
        result.getDataLists().setPassengerList(new AirShoppingRQ.DataLists.PassengerList());
        List passengerList = result.getDataLists().getPassengerList().getPassengerList();
        int adultForInfInd = 0;
        int notInfInd = 0;
        for (SeatPreferences sp : GDSHelper.sortByPassengerType((List)fsp.getSeats())) {
            String ptcValue = FarelogixHelper.getNativeCode(sp.getPassengerType());
            int isInfant = DictHelper.isInfantPassengerTypeCategory((DictionaryReference)sp.getPassengerType());
            for (int i = 0; i < sp.getCount(); ++i) {
                PassengerType tr = new PassengerType();
                if (isInfant == 0) {
                    tr.setPassengerID("T" + String.valueOf(++notInfInd));
                } else {
                    PassengerType adultTr = (PassengerType)passengerList.get(adultForInfInd);
                    String infID = adultTr.getPassengerID() + ".1";
                    tr.setPassengerID(infID);
                    adultTr.setInfantRef(infID);
                    ++adultForInfInd;
                }
                tr.setPTC(ptcValue);
                passengerList.add(tr);
            }
        }
        AirShoppingRQ.Preference preference = new AirShoppingRQ.Preference();
        result.setPreference(preference);
        if (fsp.getServiceClass() != null) {
            CabinPreferencesType cp = new CabinPreferencesType();
            CabinType cabin = new CabinType();
            cabin.setCode(FarelogixHelper.convertServiceClassToGds(fsp.getServiceClass()));
            cp.getCabinTypeList().add(cabin);
            preference.setCabinPreferences(cp);
            fp = new FarePreferencesType();
            fp.setTypes(new FarePreferencesType.Types());
            for (String str : new String[]{"749", "70J"}) {
                FarePreferencesType.Types.Type fpType = new FarePreferencesType.Types.Type();
                fpType.setString(str);
                fp.getTypes().getTypeList().add(fpType);
            }
            preference.setFarePreferences((FarePreferencesType)fp);
        }
        if (!airlines.isEmpty()) {
            AirlinePreferencesType ap = new AirlinePreferencesType();
            for (DictionaryReference<Airline> ak : airlines) {
                ap.getAirlineList().add(this.getAirline(ak));
            }
            preference.setAirlinePreferences(ap);
        }
        if (fsp.isSkipConnected()) {
            fp = new FlightPreferencesType();
            fp.setCharacteristic(new FlightPreferencesType.Characteristic());
            fp.getCharacteristic().setNonStopPreferences(new FlightPreferencesType.Characteristic.NonStopPreferences());
            fp.getCharacteristic().getNonStopPreferences().setString("Preferred");
            preference.setFlightPreferences(fp);
        }
        return result;
    }

    private AgencyCoreRepType.PseudoCity buildPseudoCity(String pcc) {
        AgencyCoreRepType.PseudoCity result = new AgencyCoreRepType.PseudoCity();
        result.setString(pcc);
        return result;
    }

    private AgencyID buildAgencyID(String agencyCode) {
        AgencyID result = new AgencyID();
        result.setString(agencyCode);
        return result;
    }

    private UniqueIDContextType buildAgentUserID(String account) {
        UniqueIDContextType result = new UniqueIDContextType();
        result.setString(account);
        return result;
    }

    private AirlinePreferencesType.Airline getAirline(DictionaryReference<Airline> ak) {
        AirlinePreferencesType.Airline result = new AirlinePreferencesType.Airline();
        result.setAirlineID((AirlineIDType)new CarrierFeeInfoType.CarrierFees.Fee.AirlineID());
        result.getAirlineID().setString(FarelogixHelper.getNativeCode(ak));
        result.setPreferenceAttrGroup(new PreferenceAttrGroup());
        result.getPreferenceAttrGroup().setPreferencesLevel("Required");
        return result;
    }

    private FlightDepartureType getFlightDeparture(DictionaryReference<GeoLocation> geoLocRef, Date date) {
        FlightDepartureType result = new FlightDepartureType();
        result.setAirportCodeString(FarelogixHelper.getNativeCode(geoLocRef));
        result.setDate(FarelogixHelper.toLocalDate(date));
        return result;
    }

    private FlightArrivalType getFlightArrival(DictionaryReference<GeoLocation> geoLocRef, Date date) {
        FlightArrivalType result = new FlightArrivalType();
        result.setAirportCodeString(FarelogixHelper.getNativeCode(geoLocRef));
        result.setDate(FarelogixHelper.toLocalDate(date));
        return result;
    }
}

