/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.farelogix.ibus.selectFlight;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.gds.model.FlightSegmentTariff;
import com.gridnine.xtrip.common.gds.model.GDSParameters;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.Pcc;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.server.gds.farelogix.ibus.FarelogixTestUtil;
import com.gridnine.xtrip.server.gds.farelogix.ibus.IBusGdsFarelogixContextKeys;
import com.gridnine.xtrip.server.gds.farelogix.ibus.selectFlight.FarelogixSelectFlightResponseParser;
import com.gridnine.xtrip.server.gds.farelogix.model.XXTransactionResponse;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.test.ModelTestBase;
import org.junit.Assert;
import org.junit.Test;

public class FarelogixSelectFlightResponseParserTest
extends ModelTestBase {
    EntityReference<SalesPoint> salesPointRef;

    public void setUp() throws Exception {
        super.setUp();
        this.salesPointRef = this.setUpSalesPoint();
    }

    private EntityReference<SalesPoint> setUpSalesPoint() {
        SalesPoint salesPoint = new SalesPoint();
        Pcc pcc = new Pcc();
        pcc.setCode("pcc");
        pcc.setGdsName(GdsName.FARELOGIX);
        salesPoint.getPccs().add(pcc);
        EntityContainer salesPointCtr = EntityContainer.create((BaseEntity)salesPoint, (String)"sales-point");
        EntityStorage.get().save(salesPointCtr, true);
        return EntityStorage.get().save(salesPointCtr, true).toReference();
    }

    @Test
    public void testResponseParser() throws Throwable {
        FarelogixSelectFlightResponseParser processor = new FarelogixSelectFlightResponseParser();
        XXTransactionResponse resp = FarelogixTestUtil.parseXStream(((Object)((Object)this)).getClass(), "FarelogixSelectFlightGdsResponse.xml");
        MessageContext ctx = new MessageContext();
        ctx.putObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT, (Object)new SalesContext());
        ctx.putObject((Enum)IBusGdsFarelogixContextKeys.FARELOGIX_RESPONSE, (Object)resp.getResponse().getFlightPriceRS());
        Flight flight = this.buildFlight();
        Assert.assertNull((Object)flight.getPqTimeLimit());
        ctx.putObject((Enum)IBusGdsContextKeys.FLIGHT, (Object)flight);
        GDSParameters gdsParameters = (GDSParameters)this.loadXSerializable("gdsParams.xml", GDSParameters.class);
        ctx.putObject((Enum)IBusGdsContextKeys.GDS_PARAMETERS, (Object)gdsParameters);
        processor.process(ctx);
        flight = (Flight)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT);
        Assert.assertNotNull((Object)flight.getPqTimeLimit());
    }

    private Flight buildFlight() {
        Flight result = new Flight();
        FlightSegmentTariff fst = new FlightSegmentTariff();
        FlightSegment fs = new FlightSegment();
        fs.setGdsId("1");
        fst.getSegments().add(fs);
        fs = new FlightSegment();
        fs.setGdsId("2");
        fst.getSegments().add(fs);
        result.getSegmentTariffs().add(fst);
        fst = new FlightSegmentTariff();
        fs = new FlightSegment();
        fs.setGdsId("3");
        fst.getSegments().add(fs);
        fs = new FlightSegment();
        fs.setGdsId("4");
        fst.getSegments().add(fs);
        result.getSegmentTariffs().add(fst);
        return result;
    }
}

