/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.farelogix.ibus.splitReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.farelogix.model.FarelogixGdsAccount;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.server.gds.farelogix.ibus.FarelogixHelper;
import com.gridnine.xtrip.server.gds.farelogix.ibus.IBusGdsFarelogixContextKeys;
import com.gridnine.xtrip.server.gds.farelogix.model.PNRSplitRQ;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;

public class FarelogixPnrSplitRequestBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        Collection productUidsToSplit = (Collection)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.PRODUCT_UIDS_TO_SPLIT);
        EntityContainer accountCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        ctx.putObject((Enum)IBusGdsFarelogixContextKeys.FARELOGIX_REQUEST, (Object)this.buildRequest(reservation, productUidsToSplit, (FarelogixGdsAccount)accountCtr.getEntity()));
    }

    private PNRSplitRQ buildRequest(Reservation reservation, Collection<String> productUidsToSplit, FarelogixGdsAccount gdsAccount) {
        PNRSplitRQ result = new PNRSplitRQ();
        result.setReceivedFrom(gdsAccount.getAccount());
        result.setRecordLocator(FarelogixHelper.getRecordLocator(reservation));
        result.setTravelerGroup(new PNRSplitRQ.TravelerGroup());
        productUidsToSplit.forEach(productUid -> {
            Product prod = (Product)CollectionUtil.find((Iterable)reservation.getProducts(), (String)productUid);
            result.getTravelerGroup().getTravelers().add(this.buildTraveler(prod.getGdsId()));
        });
        return result;
    }

    private PNRSplitRQ.Traveler buildTraveler(String gdsId) {
        PNRSplitRQ.Traveler result = new PNRSplitRQ.Traveler();
        result.setElementNumber(gdsId);
        return result;
    }
}

