/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.farelogix.ibus.ticketReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.farelogix.model.FarelogixGdsAccount;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.RecordLocatorType;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.server.gds.farelogix.ibus.FarelogixTestUtil;
import com.gridnine.xtrip.server.gds.farelogix.ibus.IBusGdsFarelogixContextKeys;
import com.gridnine.xtrip.server.gds.farelogix.ibus.ticketReservation.FarelogixTicketIssueRequestBuilder;
import com.gridnine.xtrip.server.gds.farelogix.model.FarelogixRequest;
import com.gridnine.xtrip.server.gds.farelogix.model.TicketIssueRQ;
import com.gridnine.xtrip.server.gds.farelogix.model.XXTransaction;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.test.ModelTestBase;
import org.junit.Test;

public class FarelogixTicketIssueRequestBuilderTest
extends ModelTestBase {
    public void setUp() throws Exception {
        super.setUp();
    }

    @Test
    public void testRequestBuilder() throws Throwable {
        FarelogixTicketIssueRequestBuilder processor = new FarelogixTicketIssueRequestBuilder();
        MessageContext ctx = new MessageContext();
        ctx.putObject((Enum)IBusMidofficeContextKeys.RESERVATION, (Object)this.buildReservation());
        processor.process(ctx);
        TicketIssueRQ rq = (TicketIssueRQ)ctx.getMandatoryObject((Enum)IBusGdsFarelogixContextKeys.FARELOGIX_REQUEST);
        XXTransaction xxtr = new XXTransaction();
        xxtr.setRequest(new FarelogixRequest());
        xxtr.getRequest().setTicketIssueRQ(rq);
        FarelogixTestUtil.assertObjects(((Object)((Object)this)).getClass(), "FarelogixTicketIssueRequest.xml", xxtr);
    }

    private Reservation buildReservation() throws Exception {
        FarelogixGdsAccount account = new FarelogixGdsAccount();
        account.setGds(GdsName.FARELOGIX);
        EntityContainer accountCtr = EntityContainer.create((BaseEntity)account);
        EntityStorage.get().save(accountCtr, true);
        Reservation result = new Reservation();
        CommonReservationGdsNameInfoHelper.setRecordLocator((Reservation)result, (GdsName)GdsName.FARELOGIX, (RecordLocatorType)RecordLocatorType.DEFAULT, (String)"pnr");
        result.getGdsNameInfo().setOnlineGdsAccount(accountCtr.toReference());
        SegmentTariff st = new SegmentTariff();
        Segment seg = new Segment();
        seg.setGdsId("segmentGdsId1");
        st.getSegments().add(seg);
        seg = new Segment();
        seg.setGdsId("segmentGdsId2");
        st.getSegments().add(seg);
        Product prod = new Product();
        prod.setGdsId("travelerId1");
        prod.getSegmentTariffs().add(XCloneHelper.clone((XCloneable)st, (boolean)true));
        result.getProducts().add(prod);
        prod = new Product();
        prod.setGdsId("travelerId2");
        prod.getSegmentTariffs().add(XCloneHelper.clone((XCloneable)st, (boolean)true));
        result.getProducts().add(prod);
        return result;
    }
}

