/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.farelogix.model;

import com.gridnine.xtrip.common.xml.xstream.converters.XStreamAliasEnumToStringConverter;
import com.gridnine.xtrip.common.xml.xstream.converters.XStreamLocalDateConverter;
import com.gridnine.xtrip.server.gds.farelogix.model.BaseFlxRequest;
import com.gridnine.xtrip.server.gds.farelogix.model.common.EmailAddressType;
import com.gridnine.xtrip.server.gds.farelogix.model.common.Flight;
import com.gridnine.xtrip.server.gds.farelogix.model.common.FlightPriceClass;
import com.gridnine.xtrip.server.gds.farelogix.model.common.Gender;
import com.gridnine.xtrip.server.gds.farelogix.model.common.PhoneType;
import com.gridnine.xtrip.server.gds.farelogix.model.common.PricingInfo;
import com.gridnine.xtrip.server.gds.farelogix.model.common.TravelerInfo;
import com.gridnine.xtrip.server.gds.farelogix.model.common.TravelerName;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import com.thoughtworks.xstream.converters.basic.BooleanConverter;
import java.util.ArrayList;
import java.util.List;
import org.joda.time.LocalDate;

public class PNRCreateRQ
extends BaseFlxRequest {
    @XStreamAlias(value="EndTransaction")
    private EndTransaction endTransaction;
    @XStreamAlias(value="RecordLocator")
    private String recordLocator;
    @XStreamAlias(value="CompletePNRElements")
    private CompletePNRElements completePNRElements;
    @XStreamAlias(value="OtherPNRElements")
    private OtherPNRElements otherPNRElements;
    @XStreamImplicit(itemFieldName="PricingInfo")
    private List<PricingInfo> pricingInfoList;

    public EndTransaction getEndTransaction() {
        return this.endTransaction;
    }

    public void setEndTransaction(EndTransaction endTransaction) {
        this.endTransaction = endTransaction;
    }

    public String getRecordLocator() {
        return this.recordLocator;
    }

    public void setRecordLocator(String recordLocator) {
        this.recordLocator = recordLocator;
    }

    public CompletePNRElements getCompletePNRElements() {
        return this.completePNRElements;
    }

    public void setCompletePNRElements(CompletePNRElements completePNRElements) {
        this.completePNRElements = completePNRElements;
    }

    public OtherPNRElements getOtherPNRElements() {
        return this.otherPNRElements;
    }

    public void setOtherPNRElements(OtherPNRElements otherPNRElements) {
        this.otherPNRElements = otherPNRElements;
    }

    public List<PricingInfo> getPricingInfoList() {
        if (this.pricingInfoList == null) {
            this.pricingInfoList = new ArrayList<PricingInfo>();
        }
        return this.pricingInfoList;
    }

    @XStreamConverter(value=XStreamAliasEnumToStringConverter.class, priority=1)
    public static enum AddressType {
        RESIDENCE_ADDRESS,
        DESTINATION_ADDRESS;

    }

    public static class StayingAt {
        @XStreamAsAttribute
        @XStreamAlias(value="AddressType")
        private AddressType addressType;
        @XStreamAlias(value="Address")
        private String address;
        @XStreamAlias(value="City")
        private String city;
        @XStreamAlias(value="StateCode")
        private String stateCode;
        @XStreamAlias(value="CountryCode")
        private String \u0441ountryCode;
        @XStreamAlias(value="PostalCode")
        private String postalCode;
        @XStreamAlias(value="InfantOnLap")
        @XStreamConverter(value=BooleanConverter.class, booleans={false}, strings={"Y", "N"})
        private boolean infantOnLap;

        public AddressType getAddressType() {
            return this.addressType;
        }

        public void setAddressType(AddressType addressType) {
            this.addressType = addressType;
        }

        public String getAddress() {
            return this.address;
        }

        public void setAddress(String address) {
            this.address = address;
        }

        public String getCity() {
            return this.city;
        }

        public void setCity(String city) {
            this.city = city;
        }

        public String getStateCode() {
            return this.stateCode;
        }

        public void setStateCode(String stateCode) {
            this.stateCode = stateCode;
        }

        public String get\u0421ountryCode() {
            return this.\u0441ountryCode;
        }

        public void set\u0421ountryCode(String \u0441ountryCode) {
            this.\u0441ountryCode = \u0441ountryCode;
        }

        public String getPostalCode() {
            return this.postalCode;
        }

        public void setPostalCode(String postalCode) {
            this.postalCode = postalCode;
        }

        public boolean isInfantOnLap() {
            return this.infantOnLap;
        }

        public void setInfantOnLap(boolean infantOnLap) {
            this.infantOnLap = infantOnLap;
        }
    }

    @XStreamConverter(value=XStreamAliasEnumToStringConverter.class, priority=1)
    public static enum VisaDocType {
        VISA,
        KNOWN_TRAVELER,
        REDRESS_NUMBER;

    }

    public static class Visa {
        @XStreamAlias(value="DocType")
        private VisaDocType docType;
        @XStreamAlias(value="DocNumber")
        private String docNumber;
        @XStreamAlias(value="PlaceOfBirth")
        private String placeOfBirth;
        @XStreamAlias(value="PlaceOfIssue")
        private String placeOfIssue;
        @XStreamAlias(value="IssueDate")
        @XStreamConverter(value=XStreamLocalDateConverter.class, strings={"yyyy-MM-dd"})
        private LocalDate issueDate;
        @XStreamAlias(value="IssuedForCountry")
        private String issuedForCountry;
        @XStreamAlias(value="InfantOnLap")
        @XStreamConverter(value=BooleanConverter.class, booleans={false}, strings={"Y", "N"})
        private boolean infantOnLap;

        public VisaDocType getDocType() {
            return this.docType;
        }

        public void setDocType(VisaDocType docType) {
            this.docType = docType;
        }

        public String getDocNumber() {
            return this.docNumber;
        }

        public void setDocNumber(String docNumber) {
            this.docNumber = docNumber;
        }

        public String getPlaceOfBirth() {
            return this.placeOfBirth;
        }

        public void setPlaceOfBirth(String placeOfBirth) {
            this.placeOfBirth = placeOfBirth;
        }

        public String getPlaceOfIssue() {
            return this.placeOfIssue;
        }

        public void setPlaceOfIssue(String placeOfIssue) {
            this.placeOfIssue = placeOfIssue;
        }

        public LocalDate getIssueDate() {
            return this.issueDate;
        }

        public void setIssueDate(LocalDate issueDate) {
            this.issueDate = issueDate;
        }

        public String getIssuedForCountry() {
            return this.issuedForCountry;
        }

        public void setIssuedForCountry(String issuedForCountry) {
            this.issuedForCountry = issuedForCountry;
        }

        public boolean isInfantOnLap() {
            return this.infantOnLap;
        }

        public void setInfantOnLap(boolean infantOnLap) {
            this.infantOnLap = infantOnLap;
        }
    }

    @XStreamConverter(value=XStreamAliasEnumToStringConverter.class, priority=1)
    public static enum DocType {
        ALIEN_RESIDENT_CARD,
        PERMANENT_RESIDENT_CARD,
        PASSPORT,
        TRAVEL_DOCUMENT,
        FACILITATION_DOCUMENT,
        MILITARY,
        NATURALIZATION_CERTIFICATE,
        BORDER_CROSSING_CARD,
        SECURE_FLIGHT_DATA;

    }

    public static class PictureID {
        @XStreamAlias(value="Surname")
        private String surname;
        @XStreamAlias(value="GivenName")
        private String givenName;
        @XStreamAlias(value="DateOfBirth")
        @XStreamConverter(value=XStreamLocalDateConverter.class, strings={"yyyy-MM-dd"})
        private LocalDate dateOfBirth;
        @XStreamAlias(value="Gender")
        private Gender gender;
        @XStreamAlias(value="DocType")
        private DocType docType;
        @XStreamAlias(value="DocNumber")
        private String docNumber;
        @XStreamAlias(value="DocExpirationDate")
        @XStreamConverter(value=XStreamLocalDateConverter.class, strings={"yyyy-MM-dd"})
        private LocalDate docExpirationDate;
        @XStreamAlias(value="NationalityCountry")
        private String nationalityCountry;
        @XStreamAlias(value="IssueCountry")
        private String issueCountry;

        public String getSurname() {
            return this.surname;
        }

        public void setSurname(String surname) {
            this.surname = surname;
        }

        public String getGivenName() {
            return this.givenName;
        }

        public void setGivenName(String givenName) {
            this.givenName = givenName;
        }

        public LocalDate getDateOfBirth() {
            return this.dateOfBirth;
        }

        public void setDateOfBirth(LocalDate dateOfBirth) {
            this.dateOfBirth = dateOfBirth;
        }

        public Gender getGender() {
            return this.gender;
        }

        public void setGender(Gender gender) {
            this.gender = gender;
        }

        public DocType getDocType() {
            return this.docType;
        }

        public void setDocType(DocType docType) {
            this.docType = docType;
        }

        public String getDocNumber() {
            return this.docNumber;
        }

        public void setDocNumber(String docNumber) {
            this.docNumber = docNumber;
        }

        public LocalDate getDocExpirationDate() {
            return this.docExpirationDate;
        }

        public void setDocExpirationDate(LocalDate docExpirationDate) {
            this.docExpirationDate = docExpirationDate;
        }

        public String getNationalityCountry() {
            return this.nationalityCountry;
        }

        public void setNationalityCountry(String nationalityCountry) {
            this.nationalityCountry = nationalityCountry;
        }

        public String getIssueCountry() {
            return this.issueCountry;
        }

        public void setIssueCountry(String issueCountry) {
            this.issueCountry = issueCountry;
        }
    }

    public static class Apis {
        @XStreamAlias(value="TravelerIDRef")
        private String travelerIDRef;
        @XStreamImplicit(itemFieldName="SegmentIDRef")
        private List<String> segmentIDRefs;
        @XStreamAlias(value="PictureID")
        private PictureID pictureID;
        @XStreamAlias(value="VISA")
        private Visa visa;
        @XStreamAlias(value="StayingAt")
        private StayingAt stayingAt;
        @XStreamOmitField
        private Mode mode = null;

        private void setMode(Mode value) {
            if (this.mode == null) {
                this.mode = value;
            } else if (this.mode != value) {
                throw new RuntimeException("other Mode");
            }
        }

        public PictureID getPictureID() {
            return this.pictureID;
        }

        public void setPictureID(PictureID pictureID) {
            this.pictureID = pictureID;
            this.setMode(Mode.PictureID);
        }

        public Visa getVisa() {
            return this.visa;
        }

        public void setVisa(Visa visa) {
            this.visa = visa;
            this.setMode(Mode.VISA);
        }

        public StayingAt getStayingAt() {
            return this.stayingAt;
        }

        public void setStayingAt(StayingAt stayingAt) {
            this.stayingAt = stayingAt;
            this.setMode(Mode.StayingAt);
        }

        public String getTravelerIDRef() {
            return this.travelerIDRef;
        }

        public void setTravelerIDRef(String travelerIDRef) {
            this.travelerIDRef = travelerIDRef;
        }

        public List<String> getSegmentIDRefs() {
            if (this.segmentIDRefs == null) {
                this.segmentIDRefs = new ArrayList<String>();
            }
            return this.segmentIDRefs;
        }

        static enum Mode {
            PictureID,
            VISA,
            StayingAt;

        }
    }

    public static class FrequentTravelerGroup {
        @XStreamAlias(value="TravelerIDRef")
        private String travelerIDRef;
        @XStreamAlias(value="FFCompanyCode")
        private String ffCompanyCode;
        @XStreamAlias(value="FFNumber")
        private String ffNumber;

        public String getTravelerIDRef() {
            return this.travelerIDRef;
        }

        public void setTravelerIDRef(String travelerIDRef) {
            this.travelerIDRef = travelerIDRef;
        }

        public String getFfCompanyCode() {
            return this.ffCompanyCode;
        }

        public void setFfCompanyCode(String ffCompanyCode) {
            this.ffCompanyCode = ffCompanyCode;
        }

        public String getFfNumber() {
            return this.ffNumber;
        }

        public void setFfNumber(String ffNumber) {
            this.ffNumber = ffNumber;
        }
    }

    public static class SpecialServiceRequest {
    }

    public static class CCExpiration {
        @XStreamAlias(value="Month")
        private Integer month;
        @XStreamAlias(value="Year")
        private Integer year;

        public Integer getMonth() {
            return this.month;
        }

        public void setMonth(Integer month) {
            this.month = month;
        }

        public Integer getYear() {
            return this.year;
        }

        public void setYear(Integer year) {
            this.year = year;
        }
    }

    public static class CreditCard {
        @XStreamAlias(value="CCCode")
        private String code;
        @XStreamAlias(value="CCNumber")
        private String number;
        @XStreamAlias(value="CardholderFirstName")
        private String cardholderFirstName;
        @XStreamAlias(value="CardholderLastName")
        private String cardholderLastName;
        @XStreamAlias(value="CCExpiration")
        private CCExpiration expiration;

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getNumber() {
            return this.number;
        }

        public void setNumber(String number) {
            this.number = number;
        }

        public String getCardholderFirstName() {
            return this.cardholderFirstName;
        }

        public void setCardholderFirstName(String cardholderFirstName) {
            this.cardholderFirstName = cardholderFirstName;
        }

        public String getCardholderLastName() {
            return this.cardholderLastName;
        }

        public void setCardholderLastName(String cardholderLastName) {
            this.cardholderLastName = cardholderLastName;
        }

        public CCExpiration getExpiration() {
            return this.expiration;
        }

        public void setExpiration(CCExpiration expiration) {
            this.expiration = expiration;
        }
    }

    public static class FormOfPayment {
        @XStreamImplicit(itemFieldName="TravelerIDRef")
        private List<String> travelerIDRefs;
        @XStreamImplicit(itemFieldName="SegmentIDRef")
        private List<String> segmentIDRefs;
        @XStreamImplicit(itemFieldName="ServiceIDRef")
        private List<String> serviceIDRefs;
        @XStreamAlias(value="CreditCard")
        private CreditCard creditCard;

        public CreditCard getCreditCard() {
            return this.creditCard;
        }

        public void setCreditCard(CreditCard creditCard) {
            this.creditCard = creditCard;
        }

        public List<String> getTravelerIDRefs() {
            if (this.travelerIDRefs == null) {
                this.travelerIDRefs = new ArrayList<String>();
            }
            return this.travelerIDRefs;
        }

        public List<String> getSegmentIDRefs() {
            if (this.segmentIDRefs == null) {
                this.segmentIDRefs = new ArrayList<String>();
            }
            return this.segmentIDRefs;
        }

        public List<String> getServiceIDRefs() {
            if (this.serviceIDRefs == null) {
                this.serviceIDRefs = new ArrayList<String>();
            }
            return this.serviceIDRefs;
        }
    }

    public static class BillingAndDeliveryData {
        @XStreamImplicit(itemFieldName="FormOfPayment")
        private List<FormOfPayment> formsOfPayment;

        public List<FormOfPayment> getFormsOfPayment() {
            if (this.formsOfPayment == null) {
                this.formsOfPayment = new ArrayList<FormOfPayment>();
            }
            return this.formsOfPayment;
        }
    }

    public static class EmailAddress {
        @XStreamAsAttribute
        @XStreamAlias(value="Type")
        private EmailAddressType type;
        @XStreamAsAttribute
        @XStreamAlias(value="OperationalContact")
        @XStreamConverter(value=BooleanConverter.class, booleans={false}, strings={"Y", "N"})
        private Boolean operationalContact;
        @XStreamImplicit(itemFieldName="TravelerIDRef")
        private List<String> travelerIDRefs;
        @XStreamAlias(value="Email")
        private String email;

        public EmailAddressType getType() {
            return this.type;
        }

        public void setType(EmailAddressType type) {
            this.type = type;
        }

        public Boolean getOperationalContact() {
            return this.operationalContact;
        }

        public void setOperationalContact(Boolean operationalContact) {
            this.operationalContact = operationalContact;
        }

        public String getEmail() {
            return this.email;
        }

        public void setEmail(String email) {
            this.email = email;
        }

        public List<String> getTravelerIDRefs() {
            if (this.travelerIDRefs == null) {
                this.travelerIDRefs = new ArrayList<String>();
            }
            return this.travelerIDRefs;
        }
    }

    public static class OtherPNRElements {
        @XStreamAlias(value="BillingAndDeliveryData")
        private BillingAndDeliveryData billingAndDeliveryData;
        @XStreamImplicit(itemFieldName="EmailAddress")
        private List<EmailAddress> emailAddresses;
        @XStreamImplicit(itemFieldName="FrequentTravelerGroup")
        private List<FrequentTravelerGroup> frequentTravelerGroups;
        @XStreamImplicit(itemFieldName="SpecialServiceRequest")
        private List<SpecialServiceRequest> specialServiceRequests;
        @XStreamImplicit(itemFieldName="APIS")
        private List<Apis> apisList;

        public BillingAndDeliveryData getBillingAndDeliveryData() {
            return this.billingAndDeliveryData;
        }

        public void setBillingAndDeliveryData(BillingAndDeliveryData billingAndDeliveryData) {
            this.billingAndDeliveryData = billingAndDeliveryData;
        }

        public List<EmailAddress> getEmailAddresses() {
            if (this.emailAddresses == null) {
                this.emailAddresses = new ArrayList<EmailAddress>();
            }
            return this.emailAddresses;
        }

        public List<FrequentTravelerGroup> getFrequentTravelerGroups() {
            if (this.frequentTravelerGroups == null) {
                this.frequentTravelerGroups = new ArrayList<FrequentTravelerGroup>();
            }
            return this.frequentTravelerGroups;
        }

        public List<SpecialServiceRequest> getSpecialServiceRequests() {
            if (this.specialServiceRequests == null) {
                this.specialServiceRequests = new ArrayList<SpecialServiceRequest>();
            }
            return this.specialServiceRequests;
        }

        public List<Apis> getApisList() {
            if (this.apisList == null) {
                this.apisList = new ArrayList<Apis>();
            }
            return this.apisList;
        }
    }

    public static class FlightRQ
    extends Flight {
        @XStreamAsAttribute
        @XStreamAlias(value="AssociationID")
        private String associationID;
        @XStreamAlias(value="FareRefKey")
        private String fareRefKey;
        @XStreamAlias(value="PriceClass")
        private FlightPriceClass priceClass;

        public String getAssociationID() {
            return this.associationID;
        }

        public void setAssociationID(String associationID) {
            this.associationID = associationID;
        }

        public String getFareRefKey() {
            return this.fareRefKey;
        }

        public void setFareRefKey(String fareRefKey) {
            this.fareRefKey = fareRefKey;
        }

        public FlightPriceClass getPriceClass() {
            return this.priceClass;
        }

        public void setPriceClass(FlightPriceClass priceClass) {
            this.priceClass = priceClass;
        }
    }

    public static class Itinerary {
        @XStreamImplicit(itemFieldName="Flight")
        private List<FlightRQ> flights;

        public List<FlightRQ> getFlights() {
            if (this.flights == null) {
                this.flights = new ArrayList<FlightRQ>();
            }
            return this.flights;
        }
    }

    public static class Telephone {
        @XStreamAsAttribute
        @XStreamAlias(value="Type")
        private PhoneType type;
        @XStreamAsAttribute
        @XStreamAlias(value="OperationalContact")
        @XStreamConverter(value=BooleanConverter.class, booleans={false}, strings={"Y", "N"})
        private Boolean operationalContact;
        @XStreamImplicit(itemFieldName="TravelerIDRef")
        private List<String> travelerIDRefs;
        @XStreamAlias(value="TelephoneNumber")
        private String telephoneNumber;
        @XStreamAlias(value="CountryCode")
        private String countryCode;
        @XStreamAlias(value="CityCode")
        private String cityCode;
        @XStreamAlias(value="StateCode")
        private String stateCode;
        @XStreamAlias(value="Remark")
        private String remark;

        public PhoneType getType() {
            return this.type;
        }

        public void setType(PhoneType type) {
            this.type = type;
        }

        public Boolean getOperationalContact() {
            return this.operationalContact;
        }

        public void setOperationalContact(Boolean operationalContact) {
            this.operationalContact = operationalContact;
        }

        public List<String> getTravelerIDRefs() {
            if (this.travelerIDRefs == null) {
                this.travelerIDRefs = new ArrayList<String>();
            }
            return this.travelerIDRefs;
        }

        public String getTelephoneNumber() {
            return this.telephoneNumber;
        }

        public void setTelephoneNumber(String telephoneNumber) {
            this.telephoneNumber = telephoneNumber;
        }

        public String getCountryCode() {
            return this.countryCode;
        }

        public void setCountryCode(String countryCode) {
            this.countryCode = countryCode;
        }

        public String getCityCode() {
            return this.cityCode;
        }

        public void setCityCode(String cityCode) {
            this.cityCode = cityCode;
        }

        public String getStateCode() {
            return this.stateCode;
        }

        public void setStateCode(String stateCode) {
            this.stateCode = stateCode;
        }

        public String getRemark() {
            return this.remark;
        }

        public void setRemark(String remark) {
            this.remark = remark;
        }
    }

    public static class Infant
    implements TravelerInfo {
        @XStreamAsAttribute
        @XStreamAlias(value="AssociationID")
        private String associationID;
        @XStreamAsAttribute
        @XStreamAlias(value="Type")
        private String type;
        @XStreamAlias(value="Surname")
        private String surname;
        @XStreamAlias(value="GivenName")
        private String givenName;
        @XStreamAlias(value="Title")
        private String title;
        @XStreamAlias(value="DateOfBirth")
        @XStreamConverter(value=XStreamLocalDateConverter.class, strings={"yyyy-MM-dd"})
        private LocalDate dateOfBirth;
        @XStreamAlias(value="Gender")
        private Gender gender;

        public String getAssociationID() {
            return this.associationID;
        }

        public void setAssociationID(String associationID) {
            this.associationID = associationID;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        @Override
        public String getSurname() {
            return this.surname;
        }

        @Override
        public void setSurname(String surname) {
            this.surname = surname;
        }

        @Override
        public String getGivenName() {
            return this.givenName;
        }

        @Override
        public void setGivenName(String givenName) {
            this.givenName = givenName;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        @Override
        public LocalDate getDateOfBirth() {
            return this.dateOfBirth;
        }

        @Override
        public void setDateOfBirth(LocalDate dateOfBirth) {
            this.dateOfBirth = dateOfBirth;
        }

        @Override
        public Gender getGender() {
            return this.gender;
        }

        @Override
        public void setGender(Gender gender) {
            this.gender = gender;
        }
    }

    public static class Traveler {
        @XStreamAsAttribute
        @XStreamAlias(value="Type")
        private String type;
        @XStreamAsAttribute
        @XStreamAlias(value="AssociationID")
        private String associationID;
        @XStreamAlias(value="TravelerName")
        private TravelerName travelerName;
        @XStreamAlias(value="Infant")
        private Infant infant;

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getAssociationID() {
            return this.associationID;
        }

        public void setAssociationID(String associationID) {
            this.associationID = associationID;
        }

        public TravelerName getTravelerName() {
            return this.travelerName;
        }

        public void setTravelerName(TravelerName travelerName) {
            this.travelerName = travelerName;
        }

        public Infant getInfant() {
            return this.infant;
        }

        public void setInfant(Infant infant) {
            this.infant = infant;
        }
    }

    public static class CompletePNRElements {
        @XStreamImplicit(itemFieldName="Traveler")
        private List<Traveler> travelers;
        @XStreamImplicit(itemFieldName="Telephone")
        private List<Telephone> telephones;
        @XStreamAlias(value="Itinerary")
        private Itinerary itinerary;

        public Itinerary getItinerary() {
            return this.itinerary;
        }

        public void setItinerary(Itinerary itinerary) {
            this.itinerary = itinerary;
        }

        public List<Traveler> getTravelers() {
            if (this.travelers == null) {
                this.travelers = new ArrayList<Traveler>();
            }
            return this.travelers;
        }

        public List<Telephone> getTelephones() {
            if (this.telephones == null) {
                this.telephones = new ArrayList<Telephone>();
            }
            return this.telephones;
        }
    }

    @XStreamConverter(value=XStreamAliasEnumToStringConverter.class, priority=1)
    public static enum TransactionType {
        END_TRANSACTION,
        END_TRANSACTION_RETRIEVE_PNR,
        IGNORE_TRANSACTION,
        IGNORE_TRANSACTION_RETRIEVE_PNR,
        REDISPLAY,
        END_TRANSACTION_QUEUE,
        END_TRANSACTION_QUEUE_RETRIEVE_PNR,
        CONFIRM_CHANGES_END_TRANSACTION;

    }

    public static class EndTransaction {
        @XStreamAsAttribute
        @XStreamAlias(value="TransactionType")
        TransactionType TransactionType;
        @XStreamAsAttribute
        @XStreamAlias(value="IgnoreWarnings")
        @XStreamConverter(value=BooleanConverter.class, booleans={false}, strings={"Y", "N"})
        private boolean ignoreWarnings;

        public TransactionType getTransactionType() {
            return this.TransactionType;
        }

        public void setTransactionType(TransactionType transactionType) {
            this.TransactionType = transactionType;
        }

        public boolean isIgnoreWarnings() {
            return this.ignoreWarnings;
        }

        public void setIgnoreWarnings(boolean ignoreWarnings) {
            this.ignoreWarnings = ignoreWarnings;
        }
    }
}

