
package com.gridnine.farelogix.ndc;

import java.io.Serializable;

/** 
 * Information relating to published fare rules that define the time prior to the flight departure that a reservation must be made, or a ticket must be issued.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AdvanceTicketing">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element name="AdvanceReservation" minOccurs="0">
 *         &lt;!-- Reference to inner class AdvanceReservation -->
 *       &lt;/xs:element>
 *       &lt;xs:element name="AdvanceDeparture" minOccurs="0">
 *         &lt;!-- Reference to inner class AdvanceDeparture -->
 *       &lt;/xs:element>
 *     &lt;/xs:sequence>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class AdvanceTicketing implements Serializable
{
    private AdvanceReservation advanceReservation;
    private AdvanceDeparture advanceDeparture;

    /** 
     * Get the 'AdvanceReservation' element value.
     * 
     * @return value
     */
    public AdvanceReservation getAdvanceReservation() {
        return advanceReservation;
    }

    /** 
     * Set the 'AdvanceReservation' element value.
     * 
     * @param advanceReservation
     */
    public void setAdvanceReservation(AdvanceReservation advanceReservation) {
        this.advanceReservation = advanceReservation;
    }

    /** 
     * Get the 'AdvanceDeparture' element value.
     * 
     * @return value
     */
    public AdvanceDeparture getAdvanceDeparture() {
        return advanceDeparture;
    }

    /** 
     * Set the 'AdvanceDeparture' element value.
     * 
     * @param advanceDeparture
     */
    public void setAdvanceDeparture(AdvanceDeparture advanceDeparture) {
        this.advanceDeparture = advanceDeparture;
    }
    /** 
     * Advance reservation/ ticketing value.  Example: P14D
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AdvanceReservation" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:simpleContent>
     *       &lt;xs:extension base="xs:string">
     *         &lt;xs:attribute type="xs:string" name="Context"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:simpleContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class AdvanceReservation implements Serializable
    {
        private String string;
        private String context;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public String getString() {
            return string;
        }

        /** 
         * Set the extension value.
         * 
         * @param string
         */
        public void setString(String string) {
            this.string = string;
        }

        /** 
         * Get the 'Context' attribute value. Restriction context. Example: EARLIEST, LATEST, Other
         * 
         * @return value
         */
        public String getContext() {
            return context;
        }

        /** 
         * Set the 'Context' attribute value. Restriction context. Example: EARLIEST, LATEST, Other
         * 
         * @param context
         */
        public void setContext(String context) {
            this.context = context;
        }
    }
    /** 
     * Advance departure value. Example: P3D (3 days)
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AdvanceDeparture" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:simpleContent>
     *       &lt;xs:extension base="xs:string">
     *         &lt;xs:attribute type="xs:string" name="Context"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:simpleContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class AdvanceDeparture implements Serializable
    {
        private String string;
        private String context;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public String getString() {
            return string;
        }

        /** 
         * Set the extension value.
         * 
         * @param string
         */
        public void setString(String string) {
            this.string = string;
        }

        /** 
         * Get the 'Context' attribute value. Restriction context. Example: EARLIEST, LATEST, Other
         * 
         * @return value
         */
        public String getContext() {
            return context;
        }

        /** 
         * Set the 'Context' attribute value. Restriction context. Example: EARLIEST, LATEST, Other
         * 
         * @param context
         */
        public void setContext(String context) {
            this.context = context;
        }
    }
}
