
package com.gridnine.farelogix.ndc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * AirShopReq Business Object: FLIGHT SPECIFIC definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AirShopFlightSpecificType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="FlightSegment" minOccurs="0" maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class FlightSegment -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="Flight" minOccurs="0" maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class Flight -->
 *     &lt;/xs:element>
 *     &lt;xs:element ref="OriginDestination" minOccurs="0" maxOccurs="unbounded"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class AirShopFlightSpecificType implements Serializable
{
    private List<FlightSegment> flightSegmentList = new ArrayList<FlightSegment>();
    private List<Flight> flightList = new ArrayList<Flight>();
    private List<OriginDestination> originDestinationList = new ArrayList<OriginDestination>();

    /** 
     * Get the list of 'FlightSegment' element items.
     * 
     * @return list
     */
    public List<FlightSegment> getFlightSegmentList() {
        return flightSegmentList;
    }

    /** 
     * Set the list of 'FlightSegment' element items.
     * 
     * @param list
     */
    public void setFlightSegmentList(List<FlightSegment> list) {
        flightSegmentList = list;
    }

    /** 
     * Get the list of 'Flight' element items.
     * 
     * @return list
     */
    public List<Flight> getFlightList() {
        return flightList;
    }

    /** 
     * Set the list of 'Flight' element items.
     * 
     * @param list
     */
    public void setFlightList(List<Flight> list) {
        flightList = list;
    }

    /** 
     * Get the list of 'OriginDestination' element items.
     * 
     * @return list
     */
    public List<OriginDestination> getOriginDestinationList() {
        return originDestinationList;
    }

    /** 
     * Set the list of 'OriginDestination' element items.
     * 
     * @param list
     */
    public void setOriginDestinationList(List<OriginDestination> list) {
        originDestinationList = list;
    }
    /** 
     * FlighSegment information. Contains details flight segment information.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FlightSegment" minOccurs="0" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element ref="Departure"/>
     *       &lt;xs:element ref="Arrival"/>
     *       &lt;xs:element type="MarketingCarrierFlightType" name="MarketingAirline"/>
     *       &lt;xs:element type="OperatingCarrierFlightType" name="OperatingAirline" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:string" use="required" name="SegmentKey"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class FlightSegment implements Serializable
    {
        private FlightDepartureType departure;
        private FlightArrivalType arrival;
        private MarketingCarrierFlightType marketingAirline;
        private OperatingCarrierFlightType operatingAirline;
        private String segmentKey;

        /** 
         * Get the 'Departure' element value.
         * 
         * @return value
         */
        public FlightDepartureType getDeparture() {
            return departure;
        }

        /** 
         * Set the 'Departure' element value.
         * 
         * @param departure
         */
        public void setDeparture(FlightDepartureType departure) {
            this.departure = departure;
        }

        /** 
         * Get the 'Arrival' element value.
         * 
         * @return value
         */
        public FlightArrivalType getArrival() {
            return arrival;
        }

        /** 
         * Set the 'Arrival' element value.
         * 
         * @param arrival
         */
        public void setArrival(FlightArrivalType arrival) {
            this.arrival = arrival;
        }

        /** 
         * Get the 'MarketingAirline' element value. Marketing Carrier information.
         * 
         * @return value
         */
        public MarketingCarrierFlightType getMarketingAirline() {
            return marketingAirline;
        }

        /** 
         * Set the 'MarketingAirline' element value. Marketing Carrier information.
         * 
         * @param marketingAirline
         */
        public void setMarketingAirline(
                MarketingCarrierFlightType marketingAirline) {
            this.marketingAirline = marketingAirline;
        }

        /** 
         * Get the 'OperatingAirline' element value. Operating Carrier information.

        Note: This is the carrier that holds the Air Operator’s Certificate for the aircraft used for that flight.
         * 
         * @return value
         */
        public OperatingCarrierFlightType getOperatingAirline() {
            return operatingAirline;
        }

        /** 
         * Set the 'OperatingAirline' element value. Operating Carrier information.

        Note: This is the carrier that holds the Air Operator’s Certificate for the aircraft used for that flight.
         * 
         * @param operatingAirline
         */
        public void setOperatingAirline(
                OperatingCarrierFlightType operatingAirline) {
            this.operatingAirline = operatingAirline;
        }

        /** 
         * Get the 'SegmentKey' attribute value. A globally unique identifier for this Flight Segment instance. Example: segment1
         * 
         * @return value
         */
        public String getSegmentKey() {
            return segmentKey;
        }

        /** 
         * Set the 'SegmentKey' attribute value. A globally unique identifier for this Flight Segment instance. Example: segment1
         * 
         * @param segmentKey
         */
        public void setSegmentKey(String segmentKey) {
            this.segmentKey = segmentKey;
        }
    }
    /** 
     * Flight information. Flight can be made of one to multiple FlightSegment elements. For example Flight can be made of flight segment BA123 and BA34.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Flight" minOccurs="0" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="TotalJourneyType" name="Journey" minOccurs="0"/>
     *       &lt;xs:element ref="SegmentReferences"/>
     *     &lt;/xs:sequence>
     *     &lt;xs:attributeGroup ref="ObjAssociationAttrGroup"/>
     *     &lt;xs:attribute type="xs:string" name="FlightKey"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * 
     * &lt;xs:attributeGroup xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
     *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
     * &lt;/xs:attributeGroup>
     * </pre>
     */
    public static class Flight implements Serializable
    {
        private TotalJourneyType journey;
        private SegmentReferences segmentReferences;
        private String refs;
        private String flightKey;

        /** 
         * Get the 'Journey' element value. Flight journey information.
         * 
         * @return value
         */
        public TotalJourneyType getJourney() {
            return journey;
        }

        /** 
         * Set the 'Journey' element value. Flight journey information.
         * 
         * @param journey
         */
        public void setJourney(TotalJourneyType journey) {
            this.journey = journey;
        }

        /** 
         * Get the 'SegmentReferences' element value.
         * 
         * @return value
         */
        public SegmentReferences getSegmentReferences() {
            return segmentReferences;
        }

        /** 
         * Set the 'SegmentReferences' element value.
         * 
         * @param segmentReferences
         */
        public void setSegmentReferences(SegmentReferences segmentReferences) {
            this.segmentReferences = segmentReferences;
        }

        /** 
         * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @return value
         */
        public String getRefs() {
            return refs;
        }

        /** 
         * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @param refs
         */
        public void setRefs(String refs) {
            this.refs = refs;
        }

        /** 
         * Get the 'FlightKey' attribute value. A globally unique identifier for this Flight instance. Example: flight1
         * 
         * @return value
         */
        public String getFlightKey() {
            return flightKey;
        }

        /** 
         * Set the 'FlightKey' attribute value. A globally unique identifier for this Flight instance. Example: flight1
         * 
         * @param flightKey
         */
        public void setFlightKey(String flightKey) {
            this.flightKey = flightKey;
        }
    }
}
