
package com.gridnine.farelogix.ndc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * AIRCRAFT EQUIPMENT CODE QUERY representation.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AircraftCodeQueryType">
 *   &lt;xs:sequence>
 *     &lt;xs:element ref="AircraftCode" maxOccurs="unbounded"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attributeGroup ref="ObjAssociationAttrGroup"/>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class AircraftCodeQueryType implements Serializable
{
    private List<AircraftCodeType> aircraftCodeList = new ArrayList<AircraftCodeType>();
    private String refs;

    /** 
     * Get the list of 'AircraftCode' element items. The IATA aircraft type 3 character code; use SSIM Appendix A. Example:318.
     * 
     * @return list
     */
    public List<AircraftCodeType> getAircraftCodeList() {
        return aircraftCodeList;
    }

    /** 
     * Set the list of 'AircraftCode' element items. The IATA aircraft type 3 character code; use SSIM Appendix A. Example:318.
     * 
     * @param list
     */
    public void setAircraftCodeList(List<AircraftCodeType> list) {
        aircraftCodeList = list;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getRefs() {
        return refs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param refs
     */
    public void setRefs(String refs) {
        this.refs = refs;
    }
}
