
package com.gridnine.farelogix.ndc;

import java.io.Serializable;

/** 
 * AIRCRAFT SUMMARY representation.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AircraftSummaryType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="AircraftCoreType">
 *       &lt;xs:sequence>
 *         &lt;xs:element type="xs:string" name="Name" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" name="AirlineEquipCode" minOccurs="0"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class AircraftSummaryType extends AircraftCoreType implements
    Serializable
{
    private String name;
    private String airlineEquipCode;

    /** 
     * Get the 'Name' element value. Equipment name. Example: Boeing 737-800
     * 
     * @return value
     */
    public String getName() {
        return name;
    }

    /** 
     * Set the 'Name' element value. Equipment name. Example: Boeing 737-800
     * 
     * @param name
     */
    public void setName(String name) {
        this.name = name;
    }

    /** 
     * Get the 'AirlineEquipCode' element value. Airline-specific aircraft equipment code.
    Example: 737-800
     * 
     * @return value
     */
    public String getAirlineEquipCode() {
        return airlineEquipCode;
    }

    /** 
     * Set the 'AirlineEquipCode' element value. Airline-specific aircraft equipment code.
    Example: 737-800
     * 
     * @param airlineEquipCode
     */
    public void setAirlineEquipCode(String airlineEquipCode) {
        this.airlineEquipCode = airlineEquipCode;
    }
}
