
package com.gridnine.farelogix.ndc;

import java.io.Serializable;

/** 
 * A data type for Core Airline Message Party Representation. Derived from AirlineCoreRepType.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AirlineMsgPartyCoreType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="AirlineCoreRepType">
 *       &lt;xs:sequence>
 *         &lt;xs:element ref="AgentUser" minOccurs="0"/>
 *         &lt;xs:element ref="Disclosures" minOccurs="0"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class AirlineMsgPartyCoreType extends AirlineCoreRepType implements
    Serializable
{
    private AgentUser agentUser;
    private DisclosureType disclosures;

    /** 
     * Get the 'AgentUser' element value.
     * 
     * @return value
     */
    public AgentUser getAgentUser() {
        return agentUser;
    }

    /** 
     * Set the 'AgentUser' element value.
     * 
     * @param agentUser
     */
    public void setAgentUser(AgentUser agentUser) {
        this.agentUser = agentUser;
    }

    /** 
     * Get the 'Disclosures' element value.
     * 
     * @return value
     */
    public DisclosureType getDisclosures() {
        return disclosures;
    }

    /** 
     * Set the 'Disclosures' element value.
     * 
     * @param disclosures
     */
    public void setDisclosures(DisclosureType disclosures) {
        this.disclosures = disclosures;
    }
}
