
package com.gridnine.farelogix.ndc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * A data type for AIRPORT Metadata.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AirportMetadataType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="MetadataObjectBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:element ref="Contacts" minOccurs="0"/>
 *         &lt;xs:element name="Directions" minOccurs="0">
 *           &lt;!-- Reference to inner class Directions -->
 *         &lt;/xs:element>
 *         &lt;xs:element ref="Position" minOccurs="0"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class AirportMetadataType extends MetadataObjectBaseType implements
    Serializable
{
    private Contacts contacts;
    private Directions directions;
    private PositionType position;

    /** 
     * Get the 'Contacts' element value.
     * 
     * @return value
     */
    public Contacts getContacts() {
        return contacts;
    }

    /** 
     * Set the 'Contacts' element value.
     * 
     * @param contacts
     */
    public void setContacts(Contacts contacts) {
        this.contacts = contacts;
    }

    /** 
     * Get the 'Directions' element value.
     * 
     * @return value
     */
    public Directions getDirections() {
        return directions;
    }

    /** 
     * Set the 'Directions' element value.
     * 
     * @param directions
     */
    public void setDirections(Directions directions) {
        this.directions = directions;
    }

    /** 
     * Get the 'Position' element value.
     * 
     * @return value
     */
    public PositionType getPosition() {
        return position;
    }

    /** 
     * Set the 'Position' element value.
     * 
     * @param position
     */
    public void setPosition(PositionType position) {
        this.position = position;
    }
    /** 
     * Direction(s).
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Directions" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element ref="Direction" maxOccurs="unbounded"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Directions implements Serializable
    {
        private List<DirectionsType> directionList = new ArrayList<DirectionsType>();

        /** 
         * Get the list of 'Direction' element items.
         * 
         * @return list
         */
        public List<DirectionsType> getDirectionList() {
            return directionList;
        }

        /** 
         * Set the list of 'Direction' element items.
         * 
         * @param list
         */
        public void setDirectionList(List<DirectionsType> list) {
            directionList = list;
        }
    }
}
