
package com.gridnine.farelogix.ndc;

import java.io.Serializable;

/** 
 * A data type for Baggage Allowance by Description.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BagAllowanceDescType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="ApplicableParty"/>
 *     &lt;xs:element type="xs:string" name="ApplicableBag" minOccurs="0"/>
 *     &lt;xs:element type="Descriptions" name="Descriptions"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attributeGroup ref="ObjAssociationAttrGroup"/>
 *   &lt;xs:attribute type="xs:string" name="Concept"/>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class BagAllowanceDescType implements Serializable
{
    private String applicableParty;
    private String applicableBag;
    private Descriptions descriptions;
    private String refs;
    private String concept;

    /** 
     * Get the 'ApplicableParty' element value. Baggage weight restriction application.  Examples: Party, Traveler

    Note: Party applies to all Travelers.
     * 
     * @return value
     */
    public String getApplicableParty() {
        return applicableParty;
    }

    /** 
     * Set the 'ApplicableParty' element value. Baggage weight restriction application.  Examples: Party, Traveler

    Note: Party applies to all Travelers.
     * 
     * @param applicableParty
     */
    public void setApplicableParty(String applicableParty) {
        this.applicableParty = applicableParty;
    }

    /** 
     * Get the 'ApplicableBag' element value. Applicable bag type.
    Examples: Carry-On, 1st Checked Bag, 2nd Checked Bag
     * 
     * @return value
     */
    public String getApplicableBag() {
        return applicableBag;
    }

    /** 
     * Set the 'ApplicableBag' element value. Applicable bag type.
    Examples: Carry-On, 1st Checked Bag, 2nd Checked Bag
     * 
     * @param applicableBag
     */
    public void setApplicableBag(String applicableBag) {
        this.applicableBag = applicableBag;
    }

    /** 
     * Get the 'Descriptions' element value.
     * 
     * @return value
     */
    public Descriptions getDescriptions() {
        return descriptions;
    }

    /** 
     * Set the 'Descriptions' element value.
     * 
     * @param descriptions
     */
    public void setDescriptions(Descriptions descriptions) {
        this.descriptions = descriptions;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getRefs() {
        return refs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param refs
     */
    public void setRefs(String refs) {
        this.refs = refs;
    }

    /** 
     * Get the 'Concept' attribute value. Defines the value type. Refer to PADIS Codeset 5463
     * 
     * @return value
     */
    public String getConcept() {
        return concept;
    }

    /** 
     * Set the 'Concept' attribute value. Defines the value type. Refer to PADIS Codeset 5463
     * 
     * @param concept
     */
    public void setConcept(String concept) {
        this.concept = concept;
    }
}
