
package com.gridnine.farelogix.ndc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Core Baggage Offer definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BaggageOfferCoreType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="TotalPrice">
 *       &lt;xs:complexType>
 *         &lt;xs:choice>
 *           &lt;xs:element ref="AwardPricing"/>
 *           &lt;xs:element ref="CombinationPricing"/>
 *           &lt;xs:element ref="SimpleCurrencyPrice"/>
 *           &lt;xs:element ref="DetailCurrencyPrice"/>
 *           &lt;xs:element ref="EncodedCurrencyPrice"/>
 *         &lt;/xs:choice>
 *       &lt;/xs:complexType>
 *     &lt;/xs:element>
 *     &lt;xs:element type="xs:string" name="ValidatingCarrier" minOccurs="0"/>
 *     &lt;xs:element name="BagDetails" minOccurs="0">
 *       &lt;!-- Reference to inner class BagDetails -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class BaggageOfferCoreType implements Serializable
{
    private int totalPriceSelect = -1;
    private static final int TOTAL_PRICE_AWARD_PRICING_CHOICE = 0;
    private static final int TOTAL_PRICE_COMBINATION_PRICING_CHOICE = 1;
    private static final int TOTAL_PRICE_SIMPLE_CURRENCY_PRICE_CHOICE = 2;
    private static final int TOTAL_PRICE_DETAIL_CURRENCY_PRICE_CHOICE = 3;
    private static final int TOTAL_PRICE_ENCODED_CURRENCY_PRICE_CHOICE = 4;
    private AwardPriceUnitType totalPriceAwardPricing;
    private CombinationPriceType totalPriceCombinationPricing;
    private SimpleCurrencyPrice totalPriceSimpleCurrencyPrice;
    private DetailCurrencyPriceType totalPriceDetailCurrencyPrice;
    private EncodedCurrencyPrice totalPriceEncodedCurrencyPrice;
    private String validatingCarrier;
    private BagDetails bagDetails;

    private void setTotalPriceSelect(int choice) {
        if (totalPriceSelect == -1) {
            totalPriceSelect = choice;
        } else if (totalPriceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearTotalPriceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearTotalPriceSelect() {
        totalPriceSelect = -1;
    }

    /** 
     * Check if TotalPriceAwardPricing is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifTotalPriceAwardPricing() {
        return totalPriceSelect == TOTAL_PRICE_AWARD_PRICING_CHOICE;
    }

    /** 
     * Get the 'AwardPricing' element value.
     * 
     * @return value
     */
    public AwardPriceUnitType getTotalPriceAwardPricing() {
        return totalPriceAwardPricing;
    }

    /** 
     * Set the 'AwardPricing' element value.
     * 
     * @param totalPriceAwardPricing
     */
    public void setTotalPriceAwardPricing(
            AwardPriceUnitType totalPriceAwardPricing) {
        setTotalPriceSelect(TOTAL_PRICE_AWARD_PRICING_CHOICE);
        this.totalPriceAwardPricing = totalPriceAwardPricing;
    }

    /** 
     * Check if TotalPriceCombinationPricing is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifTotalPriceCombinationPricing() {
        return totalPriceSelect == TOTAL_PRICE_COMBINATION_PRICING_CHOICE;
    }

    /** 
     * Get the 'CombinationPricing' element value.
     * 
     * @return value
     */
    public CombinationPriceType getTotalPriceCombinationPricing() {
        return totalPriceCombinationPricing;
    }

    /** 
     * Set the 'CombinationPricing' element value.
     * 
     * @param totalPriceCombinationPricing
     */
    public void setTotalPriceCombinationPricing(
            CombinationPriceType totalPriceCombinationPricing) {
        setTotalPriceSelect(TOTAL_PRICE_COMBINATION_PRICING_CHOICE);
        this.totalPriceCombinationPricing = totalPriceCombinationPricing;
    }

    /** 
     * Check if TotalPriceSimpleCurrencyPrice is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifTotalPriceSimpleCurrencyPrice() {
        return totalPriceSelect == TOTAL_PRICE_SIMPLE_CURRENCY_PRICE_CHOICE;
    }

    /** 
     * Get the 'SimpleCurrencyPrice' element value.
     * 
     * @return value
     */
    public SimpleCurrencyPrice getTotalPriceSimpleCurrencyPrice() {
        return totalPriceSimpleCurrencyPrice;
    }

    /** 
     * Set the 'SimpleCurrencyPrice' element value.
     * 
     * @param totalPriceSimpleCurrencyPrice
     */
    public void setTotalPriceSimpleCurrencyPrice(
            SimpleCurrencyPrice totalPriceSimpleCurrencyPrice) {
        setTotalPriceSelect(TOTAL_PRICE_SIMPLE_CURRENCY_PRICE_CHOICE);
        this.totalPriceSimpleCurrencyPrice = totalPriceSimpleCurrencyPrice;
    }

    /** 
     * Check if TotalPriceDetailCurrencyPrice is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifTotalPriceDetailCurrencyPrice() {
        return totalPriceSelect == TOTAL_PRICE_DETAIL_CURRENCY_PRICE_CHOICE;
    }

    /** 
     * Get the 'DetailCurrencyPrice' element value.
     * 
     * @return value
     */
    public DetailCurrencyPriceType getTotalPriceDetailCurrencyPrice() {
        return totalPriceDetailCurrencyPrice;
    }

    /** 
     * Set the 'DetailCurrencyPrice' element value.
     * 
     * @param totalPriceDetailCurrencyPrice
     */
    public void setTotalPriceDetailCurrencyPrice(
            DetailCurrencyPriceType totalPriceDetailCurrencyPrice) {
        setTotalPriceSelect(TOTAL_PRICE_DETAIL_CURRENCY_PRICE_CHOICE);
        this.totalPriceDetailCurrencyPrice = totalPriceDetailCurrencyPrice;
    }

    /** 
     * Check if TotalPriceEncodedCurrencyPrice is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifTotalPriceEncodedCurrencyPrice() {
        return totalPriceSelect == TOTAL_PRICE_ENCODED_CURRENCY_PRICE_CHOICE;
    }

    /** 
     * Get the 'EncodedCurrencyPrice' element value.
     * 
     * @return value
     */
    public EncodedCurrencyPrice getTotalPriceEncodedCurrencyPrice() {
        return totalPriceEncodedCurrencyPrice;
    }

    /** 
     * Set the 'EncodedCurrencyPrice' element value.
     * 
     * @param totalPriceEncodedCurrencyPrice
     */
    public void setTotalPriceEncodedCurrencyPrice(
            EncodedCurrencyPrice totalPriceEncodedCurrencyPrice) {
        setTotalPriceSelect(TOTAL_PRICE_ENCODED_CURRENCY_PRICE_CHOICE);
        this.totalPriceEncodedCurrencyPrice = totalPriceEncodedCurrencyPrice;
    }

    /** 
     * Get the 'ValidatingCarrier' element value. Validating Carrier Airline Designator.
    A two-character alpha-numeric code assigned according to the IATA Resolution 762 or a three-letter airline designator assigned by ICAO.  Refer to IATA Airline Coding Directory .  Example: BA

     * 
     * @return value
     */
    public String getValidatingCarrier() {
        return validatingCarrier;
    }

    /** 
     * Set the 'ValidatingCarrier' element value. Validating Carrier Airline Designator.
    A two-character alpha-numeric code assigned according to the IATA Resolution 762 or a three-letter airline designator assigned by ICAO.  Refer to IATA Airline Coding Directory .  Example: BA

     * 
     * @param validatingCarrier
     */
    public void setValidatingCarrier(String validatingCarrier) {
        this.validatingCarrier = validatingCarrier;
    }

    /** 
     * Get the 'BagDetails' element value.
     * 
     * @return value
     */
    public BagDetails getBagDetails() {
        return bagDetails;
    }

    /** 
     * Set the 'BagDetails' element value.
     * 
     * @param bagDetails
     */
    public void setBagDetails(BagDetails bagDetails) {
        this.bagDetails = bagDetails;
    }
    /** 
     * Baggage Details.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BagDetails" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="BagDetail" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class BagDetail -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class BagDetails implements Serializable
    {
        private List<BagDetail> bagDetailList = new ArrayList<BagDetail>();

        /** 
         * Get the list of 'BagDetail' element items.
         * 
         * @return list
         */
        public List<BagDetail> getBagDetailList() {
            return bagDetailList;
        }

        /** 
         * Set the list of 'BagDetail' element items.
         * 
         * @param list
         */
        public void setBagDetailList(List<BagDetail> list) {
            bagDetailList = list;
        }
        /** 
         * Baggage detail.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BagDetail" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="xs:string" name="ValidatingCarrier"/>
         *       &lt;xs:element type="BagOfferAssocType" name="Associations" minOccurs="0"/>
         *       &lt;xs:element ref="CheckedBags" minOccurs="0"/>
         *       &lt;xs:element ref="CarryOnBags" minOccurs="0"/>
         *       &lt;xs:element type="BagDisclosureType" name="Disclosure" minOccurs="0"/>
         *       &lt;xs:element name="Price" minOccurs="0">
         *         &lt;!-- Reference to inner class Price -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class BagDetail implements Serializable
        {
            private String validatingCarrier;
            private BagOfferAssocType associations;
            private CheckedBagAllowanceType checkedBags;
            private CarryOnAllowanceType carryOnBags;
            private BagDisclosureType disclosure;
            private Price price;

            /** 
             * Get the 'ValidatingCarrier' element value. Validating Carrier Airline Designator.
            A two-character alpha-numeric code assigned according to the IATA Resolution 762 or a three-letter airline designator assigned by ICAO.  Refer to IATA Airline Coding Directory .  Example: BA
             * 
             * @return value
             */
            public String getValidatingCarrier() {
                return validatingCarrier;
            }

            /** 
             * Set the 'ValidatingCarrier' element value. Validating Carrier Airline Designator.
            A two-character alpha-numeric code assigned according to the IATA Resolution 762 or a three-letter airline designator assigned by ICAO.  Refer to IATA Airline Coding Directory .  Example: BA
             * 
             * @param validatingCarrier
             */
            public void setValidatingCarrier(String validatingCarrier) {
                this.validatingCarrier = validatingCarrier;
            }

            /** 
             * Get the 'Associations' element value. 
                              Baggage Offer Association(s), including Shopper, Flight, Baggage Details, Optional Services and other miscellaneous association.
                            
             * 
             * @return value
             */
            public BagOfferAssocType getAssociations() {
                return associations;
            }

            /** 
             * Set the 'Associations' element value. 
                              Baggage Offer Association(s), including Shopper, Flight, Baggage Details, Optional Services and other miscellaneous association.
                            
             * 
             * @param associations
             */
            public void setAssociations(BagOfferAssocType associations) {
                this.associations = associations;
            }

            /** 
             * Get the 'CheckedBags' element value.
             * 
             * @return value
             */
            public CheckedBagAllowanceType getCheckedBags() {
                return checkedBags;
            }

            /** 
             * Set the 'CheckedBags' element value.
             * 
             * @param checkedBags
             */
            public void setCheckedBags(CheckedBagAllowanceType checkedBags) {
                this.checkedBags = checkedBags;
            }

            /** 
             * Get the 'CarryOnBags' element value.
             * 
             * @return value
             */
            public CarryOnAllowanceType getCarryOnBags() {
                return carryOnBags;
            }

            /** 
             * Set the 'CarryOnBags' element value.
             * 
             * @param carryOnBags
             */
            public void setCarryOnBags(CarryOnAllowanceType carryOnBags) {
                this.carryOnBags = carryOnBags;
            }

            /** 
             * Get the 'Disclosure' element value. Baggage Disclosure information.
             * 
             * @return value
             */
            public BagDisclosureType getDisclosure() {
                return disclosure;
            }

            /** 
             * Set the 'Disclosure' element value. Baggage Disclosure information.
             * 
             * @param disclosure
             */
            public void setDisclosure(BagDisclosureType disclosure) {
                this.disclosure = disclosure;
            }

            /** 
             * Get the 'Price' element value.
             * 
             * @return value
             */
            public Price getPrice() {
                return price;
            }

            /** 
             * Set the 'Price' element value.
             * 
             * @param price
             */
            public void setPrice(Price price) {
                this.price = price;
            }
            /** 
             * Elements relating to baggage charges.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Price" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:choice>
             *       &lt;xs:element type="AwardPriceUnitType" name="AwardPricing"/>
             *       &lt;xs:element type="CombinationPriceType" name="CombinationPricing"/>
             *       &lt;xs:element type="DetailCurrencyPriceType" name="DetailCurrencyPrice"/>
             *       &lt;xs:element type="CurrencyAmountEncodedType" name="EncodedCurrencyPrice"/>
             *       &lt;xs:element type="CurrencyAmountOptType" name="SimpleCurrencyPrice"/>
             *     &lt;/xs:choice>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Price implements Serializable
            {
                private int priceSelect = -1;
                private static final int AWARD_PRICING_CHOICE = 0;
                private static final int COMBINATION_PRICING_CHOICE = 1;
                private static final int DETAIL_CURRENCY_PRICE_CHOICE = 2;
                private static final int ENCODED_CURRENCY_PRICE_CHOICE = 3;
                private static final int SIMPLE_CURRENCY_PRICE_CHOICE = 4;
                private AwardPriceUnitType awardPricing;
                private CombinationPriceType combinationPricing;
                private DetailCurrencyPriceType detailCurrencyPrice;
                private CurrencyAmountEncodedType encodedCurrencyPrice;
                private CurrencyAmountOptType simpleCurrencyPrice;

                private void setPriceSelect(int choice) {
                    if (priceSelect == -1) {
                        priceSelect = choice;
                    } else if (priceSelect != choice) {
                        throw new IllegalStateException(
                                "Need to call clearPriceSelect() before changing existing choice");
                    }
                }

                /** 
                 * Clear the choice selection.
                 */
                public void clearPriceSelect() {
                    priceSelect = -1;
                }

                /** 
                 * Check if AwardPricing is current selection for choice.
                 * 
                 * @return <code>true</code> if selection, <code>false</code> if not
                 */
                public boolean ifAwardPricing() {
                    return priceSelect == AWARD_PRICING_CHOICE;
                }

                /** 
                 * Get the 'AwardPricing' element value. AWARD (Redemption Unit-based) Pricing information.
                 * 
                 * @return value
                 */
                public AwardPriceUnitType getAwardPricing() {
                    return awardPricing;
                }

                /** 
                 * Set the 'AwardPricing' element value. AWARD (Redemption Unit-based) Pricing information.
                 * 
                 * @param awardPricing
                 */
                public void setAwardPricing(AwardPriceUnitType awardPricing) {
                    setPriceSelect(AWARD_PRICING_CHOICE);
                    this.awardPricing = awardPricing;
                }

                /** 
                 * Check if CombinationPricing is current selection for choice.
                 * 
                 * @return <code>true</code> if selection, <code>false</code> if not
                 */
                public boolean ifCombinationPricing() {
                    return priceSelect == COMBINATION_PRICING_CHOICE;
                }

                /** 
                 * Get the 'CombinationPricing' element value. PARTIAL CURRENCY and AWARD Pricing Combination information.
                 * 
                 * @return value
                 */
                public CombinationPriceType getCombinationPricing() {
                    return combinationPricing;
                }

                /** 
                 * Set the 'CombinationPricing' element value. PARTIAL CURRENCY and AWARD Pricing Combination information.
                 * 
                 * @param combinationPricing
                 */
                public void setCombinationPricing(
                        CombinationPriceType combinationPricing) {
                    setPriceSelect(COMBINATION_PRICING_CHOICE);
                    this.combinationPricing = combinationPricing;
                }

                /** 
                 * Check if DetailCurrencyPrice is current selection for choice.
                 * 
                 * @return <code>true</code> if selection, <code>false</code> if not
                 */
                public boolean ifDetailCurrencyPrice() {
                    return priceSelect == DETAIL_CURRENCY_PRICE_CHOICE;
                }

                /** 
                 * Get the 'DetailCurrencyPrice' element value. A (detailed) CURRENCY-based Price with Price Break-down for Tax and/ or Fee information.
                 * 
                 * @return value
                 */
                public DetailCurrencyPriceType getDetailCurrencyPrice() {
                    return detailCurrencyPrice;
                }

                /** 
                 * Set the 'DetailCurrencyPrice' element value. A (detailed) CURRENCY-based Price with Price Break-down for Tax and/ or Fee information.
                 * 
                 * @param detailCurrencyPrice
                 */
                public void setDetailCurrencyPrice(
                        DetailCurrencyPriceType detailCurrencyPrice) {
                    setPriceSelect(DETAIL_CURRENCY_PRICE_CHOICE);
                    this.detailCurrencyPrice = detailCurrencyPrice;
                }

                /** 
                 * Check if EncodedCurrencyPrice is current selection for choice.
                 * 
                 * @return <code>true</code> if selection, <code>false</code> if not
                 */
                public boolean ifEncodedCurrencyPrice() {
                    return priceSelect == ENCODED_CURRENCY_PRICE_CHOICE;
                }

                /** 
                 * Get the 'EncodedCurrencyPrice' element value. Monetary value amount and currency code.
                 * 
                 * @return value
                 */
                public CurrencyAmountEncodedType getEncodedCurrencyPrice() {
                    return encodedCurrencyPrice;
                }

                /** 
                 * Set the 'EncodedCurrencyPrice' element value. Monetary value amount and currency code.
                 * 
                 * @param encodedCurrencyPrice
                 */
                public void setEncodedCurrencyPrice(
                        CurrencyAmountEncodedType encodedCurrencyPrice) {
                    setPriceSelect(ENCODED_CURRENCY_PRICE_CHOICE);
                    this.encodedCurrencyPrice = encodedCurrencyPrice;
                }

                /** 
                 * Check if SimpleCurrencyPrice is current selection for choice.
                 * 
                 * @return <code>true</code> if selection, <code>false</code> if not
                 */
                public boolean ifSimpleCurrencyPrice() {
                    return priceSelect == SIMPLE_CURRENCY_PRICE_CHOICE;
                }

                /** 
                 * Get the 'SimpleCurrencyPrice' element value. A (simple) CURRENCY-based Price with NO taxes and/ or fees.
                Examples: 100.00, 100, 100 (USD)
                 * 
                 * @return value
                 */
                public CurrencyAmountOptType getSimpleCurrencyPrice() {
                    return simpleCurrencyPrice;
                }

                /** 
                 * Set the 'SimpleCurrencyPrice' element value. A (simple) CURRENCY-based Price with NO taxes and/ or fees.
                Examples: 100.00, 100, 100 (USD)
                 * 
                 * @param simpleCurrencyPrice
                 */
                public void setSimpleCurrencyPrice(
                        CurrencyAmountOptType simpleCurrencyPrice) {
                    setPriceSelect(SIMPLE_CURRENCY_PRICE_CHOICE);
                    this.simpleCurrencyPrice = simpleCurrencyPrice;
                }
            }
        }
    }
}
