
package com.gridnine.farelogix.ndc;

import java.io.Serializable;

/** 
 * BASE FARE TRANSACTION definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BaseFareTransactionType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="CurrencyAmountOptType" name="Amount"/>
 *     &lt;xs:element type="FareAmountType" name="AmountType" minOccurs="0"/>
 *     &lt;xs:element type="CouponPurposeListType" name="Purpose" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class BaseFareTransactionType implements Serializable
{
    private CurrencyAmountOptType amount;
    private FareAmountType amountType;
    private CouponPurposeListType purpose;

    /** 
     * Get the 'Amount' element value. Base Fare Amount. Example 160 USD
     * 
     * @return value
     */
    public CurrencyAmountOptType getAmount() {
        return amount;
    }

    /** 
     * Set the 'Amount' element value. Base Fare Amount. Example 160 USD
     * 
     * @param amount
     */
    public void setAmount(CurrencyAmountOptType amount) {
        this.amount = amount;
    }

    /** 
     * Get the 'AmountType' element value. Total Fare Amount Type. Examples: ADC (Additional Charge); Bulk; IT (Tour Inclusive); NOADC (No Additional Charge)
     * 
     * @return value
     */
    public FareAmountType getAmountType() {
        return amountType;
    }

    /** 
     * Set the 'AmountType' element value. Total Fare Amount Type. Examples: ADC (Additional Charge); Bulk; IT (Tour Inclusive); NOADC (No Additional Charge)
     * 
     * @param amountType
     */
    public void setAmountType(FareAmountType amountType) {
        this.amountType = amountType;
    }

    /** 
     * Get the 'Purpose' element value. Base Fare Transaction Purpose. Example: Base, Equivalent

    Note: This is used to indicate if this is base or equivalent fare transaction information.
     * 
     * @return value
     */
    public CouponPurposeListType getPurpose() {
        return purpose;
    }

    /** 
     * Set the 'Purpose' element value. Base Fare Transaction Purpose. Example: Base, Equivalent

    Note: This is used to indicate if this is base or equivalent fare transaction information.
     * 
     * @param purpose
     */
    public void setPurpose(CouponPurposeListType purpose) {
        this.purpose = purpose;
    }
}
