
package com.gridnine.farelogix.ndc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Booking Reference information to include Record Locator, Assigning Airling Identifier, etc.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BookingReferences">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element type="BookingReferenceType" name="BookingReference" maxOccurs="unbounded"/>
 *     &lt;/xs:sequence>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class BookingReferences implements Serializable
{
    private List<BookingReferenceType> bookingReferenceList = new ArrayList<BookingReferenceType>();

    /** 
     * Get the list of 'BookingReference' element items. Booking Reference detail.
     * 
     * @return list
     */
    public List<BookingReferenceType> getBookingReferenceList() {
        return bookingReferenceList;
    }

    /** 
     * Set the list of 'BookingReference' element items. Booking Reference detail.
     * 
     * @param list
     */
    public void setBookingReferenceList(List<BookingReferenceType> list) {
        bookingReferenceList = list;
    }
}
