
package com.gridnine.farelogix.ndc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Provides rules on allowable combinations between priceclasses, services and other items.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://ndc.farelogix.com/aug" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Combinability">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element name="Association" minOccurs="0" maxOccurs="unbounded">
 *         &lt;!-- Reference to inner class Association -->
 *       &lt;/xs:element>
 *     &lt;/xs:sequence>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class Combinability implements Serializable
{
    private List<Association> associationList = new ArrayList<Association>();

    /** 
     * Get the list of 'Association' element items.
     * 
     * @return list
     */
    public List<Association> getAssociationList() {
        return associationList;
    }

    /** 
     * Set the list of 'Association' element items.
     * 
     * @param list
     */
    public void setAssociationList(List<Association> list) {
        associationList = list;
    }
    /** 
     * Combinability Association Detail.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://ndc.farelogix.com/aug" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Association" minOccurs="0" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="Type"/>
     *       &lt;xs:element type="xs:string" name="ReferenceValue" maxOccurs="unbounded"/>
     *       &lt;xs:element type="xs:string" name="ServiceReference" minOccurs="0" maxOccurs="unbounded"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Association implements Serializable
    {
        private String type;
        private List<String> referenceValueList = new ArrayList<String>();
        private List<String> serviceReferenceList = new ArrayList<String>();

        /** 
         * Get the 'Type' element value. Named association type. Examples: ServiceBundle, MediaGroup
         * 
         * @return value
         */
        public String getType() {
            return type;
        }

        /** 
         * Set the 'Type' element value. Named association type. Examples: ServiceBundle, MediaGroup
         * 
         * @param type
         */
        public void setType(String type) {
            this.type = type;
        }

        /** 
         * Get the list of 'ReferenceValue' element items. Associated object instance value. Example: mediagrp1
         * 
         * @return list
         */
        public List<String> getReferenceValueList() {
            return referenceValueList;
        }

        /** 
         * Set the list of 'ReferenceValue' element items. Associated object instance value. Example: mediagrp1
         * 
         * @param list
         */
        public void setReferenceValueList(List<String> list) {
            referenceValueList = list;
        }

        /** 
         * Get the list of 'ServiceReference' element items. Association to one Service instance. Example: srvc1
         * 
         * @return list
         */
        public List<String> getServiceReferenceList() {
            return serviceReferenceList;
        }

        /** 
         * Set the list of 'ServiceReference' element items. Association to one Service instance. Example: srvc1
         * 
         * @param list
         */
        public void setServiceReferenceList(List<String> list) {
            serviceReferenceList = list;
        }
    }
}
