
package com.gridnine.farelogix.ndc;

import java.io.Serializable;

/** 
 * COMBINATION PRICE BASIS UNIT: Partial currency and award.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CombinationPriceSimpleType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="Partial">
 *       &lt;xs:complexType>
 *         &lt;xs:sequence>
 *           &lt;xs:element name="Currency">
 *             &lt;xs:complexType>
 *               &lt;xs:choice>
 *                 &lt;xs:element ref="EncodedCurrencyAmount"/>
 *                 &lt;xs:element ref="SimpleCurrencyPrice"/>
 *               &lt;/xs:choice>
 *             &lt;/xs:complexType>
 *           &lt;/xs:element>
 *           &lt;xs:element type="AwardRedemptionType" name="Redemption"/>
 *         &lt;/xs:sequence>
 *       &lt;/xs:complexType>
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class CombinationPriceSimpleType implements Serializable
{
    private int partialCurrencySelect = -1;
    private static final int PARTIAL_ENCODED_CURRENCY_AMOUNT_CHOICE = 0;
    private static final int PARTIAL_SIMPLE_CURRENCY_PRICE_CHOICE = 1;
    private EncodedCurrencyAmount partialEncodedCurrencyAmount;
    private SimpleCurrencyPrice partialSimpleCurrencyPrice;
    private AwardRedemptionType partialRedemption;

    private void setPartialCurrencySelect(int choice) {
        if (partialCurrencySelect == -1) {
            partialCurrencySelect = choice;
        } else if (partialCurrencySelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearPartialCurrencySelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearPartialCurrencySelect() {
        partialCurrencySelect = -1;
    }

    /** 
     * Check if PartialEncodedCurrencyAmount is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifPartialEncodedCurrencyAmount() {
        return partialCurrencySelect == PARTIAL_ENCODED_CURRENCY_AMOUNT_CHOICE;
    }

    /** 
     * Get the 'EncodedCurrencyAmount' element value. Monetary value amount and currency code.
     * 
     * @return value
     */
    public EncodedCurrencyAmount getPartialEncodedCurrencyAmount() {
        return partialEncodedCurrencyAmount;
    }

    /** 
     * Set the 'EncodedCurrencyAmount' element value. Monetary value amount and currency code.
     * 
     * @param partialEncodedCurrencyAmount
     */
    public void setPartialEncodedCurrencyAmount(
            EncodedCurrencyAmount partialEncodedCurrencyAmount) {
        setPartialCurrencySelect(PARTIAL_ENCODED_CURRENCY_AMOUNT_CHOICE);
        this.partialEncodedCurrencyAmount = partialEncodedCurrencyAmount;
    }

    /** 
     * Check if PartialSimpleCurrencyPrice is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifPartialSimpleCurrencyPrice() {
        return partialCurrencySelect == PARTIAL_SIMPLE_CURRENCY_PRICE_CHOICE;
    }

    /** 
     * Get the 'SimpleCurrencyPrice' element value.
     * 
     * @return value
     */
    public SimpleCurrencyPrice getPartialSimpleCurrencyPrice() {
        return partialSimpleCurrencyPrice;
    }

    /** 
     * Set the 'SimpleCurrencyPrice' element value.
     * 
     * @param partialSimpleCurrencyPrice
     */
    public void setPartialSimpleCurrencyPrice(
            SimpleCurrencyPrice partialSimpleCurrencyPrice) {
        setPartialCurrencySelect(PARTIAL_SIMPLE_CURRENCY_PRICE_CHOICE);
        this.partialSimpleCurrencyPrice = partialSimpleCurrencyPrice;
    }

    /** 
     * Get the 'Redemption' element value. Redemption amount and unit.
    Example: 15000 Miles
     * 
     * @return value
     */
    public AwardRedemptionType getPartialRedemption() {
        return partialRedemption;
    }

    /** 
     * Set the 'Redemption' element value. Redemption amount and unit.
    Example: 15000 Miles
     * 
     * @param partialRedemption
     */
    public void setPartialRedemption(AwardRedemptionType partialRedemption) {
        this.partialRedemption = partialRedemption;
    }
}
