
package com.gridnine.farelogix.ndc;

import java.io.Serializable;

/** 
 * A data type for Currency Code Application constrained list.

 Examples: Actual, Display, Requested, Conversion, Other
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ConnectMethodListType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="DirectWithAirline"/>
 *     &lt;xs:enumeration value="DirectWithOther"/>
 *     &lt;xs:enumeration value="Gateway"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum ConnectMethodListType implements Serializable {
    DIRECT_WITH_AIRLINE("DirectWithAirline"), DIRECT_WITH_OTHER(
            "DirectWithOther"), GATEWAY("Gateway");
    private final String value;

    private ConnectMethodListType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static ConnectMethodListType convert(String value) {
        for (ConnectMethodListType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
