
package com.gridnine.farelogix.ndc;

import java.io.Serializable;

/** 
 * A data type for COUNTRY Metadata.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CountryMetadataType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="MetadataObjectBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:element type="xs:string" name="ICAO_Code" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" name="Name" minOccurs="0"/>
 *         &lt;xs:element ref="Position" minOccurs="0"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class CountryMetadataType extends MetadataObjectBaseType implements
    Serializable
{
    private String ICAOCode;
    private String name;
    private PositionType position;

    /** 
     * Get the 'ICAO_Code' element value. ICAO location code.
    Example: K (CONTIGUOUS UNITED STATES)
     * 
     * @return value
     */
    public String getICAOCode() {
        return ICAOCode;
    }

    /** 
     * Set the 'ICAO_Code' element value. ICAO location code.
    Example: K (CONTIGUOUS UNITED STATES)
     * 
     * @param ICAOCode
     */
    public void setICAOCode(String ICAOCode) {
        this.ICAOCode = ICAOCode;
    }

    /** 
     * Get the 'Name' element value. Country name.
    Example: United States
     * 
     * @return value
     */
    public String getName() {
        return name;
    }

    /** 
     * Set the 'Name' element value. Country name.
    Example: United States
     * 
     * @param name
     */
    public void setName(String name) {
        this.name = name;
    }

    /** 
     * Get the 'Position' element value.
     * 
     * @return value
     */
    public PositionType getPosition() {
        return position;
    }

    /** 
     * Set the 'Position' element value.
     * 
     * @param position
     */
    public void setPosition(PositionType position) {
        this.position = position;
    }
}
