
package com.gridnine.farelogix.ndc;

import java.io.Serializable;
import org.joda.time.DateTime;

/** 
 * A data type definition for Effective/ Expiration Date And Time Period Representation.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DateTimePeriodType">
 *   &lt;xs:attribute type="xs:dateTime" use="optional" name="Effective"/>
 *   &lt;xs:attribute type="xs:dateTime" use="optional" name="Expiration"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class DateTimePeriodType implements Serializable
{
    private DateTime effective;
    private DateTime expiration;

    /** 
     * Get the 'Effective' attribute value. Effective (start) Date/ Time. Example: 2017-01-13T06:00:00
     * 
     * @return value
     */
    public DateTime getEffective() {
        return effective;
    }

    /** 
     * Set the 'Effective' attribute value. Effective (start) Date/ Time. Example: 2017-01-13T06:00:00
     * 
     * @param effective
     */
    public void setEffective(DateTime effective) {
        this.effective = effective;
    }

    /** 
     * Get the 'Expiration' attribute value. Expiration (end) Date/ Time. Example: 2017-03-13T23:00:00
     * 
     * @return value
     */
    public DateTime getExpiration() {
        return expiration;
    }

    /** 
     * Set the 'Expiration' attribute value. Expiration (end) Date/ Time. Example: 2017-03-13T23:00:00
     * 
     * @param expiration
     */
    public void setExpiration(DateTime expiration) {
        this.expiration = expiration;
    }
}
